/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.hardware.device.Device;
import elliott803.machine.Computer;
import elliott803.view.TapeDeviceView;

public abstract class TapeDevice
extends Device {
    public int id;
    TapeDeviceView view;

    public TapeDevice(Computer computer, int id) {
        this.computer = computer;
        this.id = id;
    }

    protected void transfer(int ch) {
        this.computer.console.setBlockTr(true);
        this.devicePause();
        this.viewChar(ch);
    }

    protected void deviceWait() {
        this.viewBusy(true);
        super.deviceWait();
        this.viewBusy(false);
    }

    public void setView(TapeDeviceView view) {
        this.view = view;
    }

    void viewChar(int ch) {
        if (this.view != null) {
            this.view.updateCh(ch);
        }
    }

    void viewTape(Object tape) {
        if (this.view != null) {
            this.view.updateTape(tape);
        }
    }

    void viewBusy(boolean busy) {
        if (this.view != null) {
            this.view.updateWait(busy);
        }
    }
}

