/*
 * Decompiled with CFR 0.152.
 */
package elliott803.machine;

import java.util.StringTokenizer;

public abstract class Instruction {
    public static final int OP_BITS = 63;
    public static final int ADDR_BITS = 8191;
    public static final int INSTR_MASK = 524287;
    public static final int OP_MASK = Instruction.asOp(63);
    public static final int ADDR_MASK = Instruction.asAddr(8191);

    public static final int asOp(int op) {
        return (op & 0x3F) << 13;
    }

    public static final int asAddr(int addr) {
        return addr & 0x1FFF;
    }

    public static final int asInstr(int op, int addr) {
        return Instruction.asOp(op) | Instruction.asAddr(addr);
    }

    public static final int asInstr(int instr) {
        return instr & 0x7FFFF;
    }

    public static final int getOp(int instr) {
        return instr >> 13 & 0x3F;
    }

    public static final int getAddr(int instr) {
        return instr & 0x1FFF;
    }

    public static final String toOpString(int op) {
        StringBuilder result = new StringBuilder();
        String text = Integer.toOctalString(op);
        result.append("00", 0, 2 - text.length()).append(text);
        return result.toString();
    }

    public static final String toAddrString(int addr) {
        StringBuilder result = new StringBuilder();
        String text = Integer.toString(addr);
        result.append("    ", 0, 4 - text.length()).append(text);
        return result.toString();
    }

    public static final String toInstrString(int instr) {
        StringBuilder result = new StringBuilder();
        String text1 = Integer.toOctalString(Instruction.getOp(instr));
        String text2 = Integer.toString(Instruction.getAddr(instr));
        result.append("00", 0, 2 - text1.length()).append(text1);
        result.append("     ", 0, 5 - text2.length()).append(text2);
        return result.toString();
    }

    public static final int parseInstr(String s) {
        int op = 0;
        int addr = 0;
        StringTokenizer t = new StringTokenizer(s, " ");
        if (t.hasMoreTokens()) {
            op = Integer.parseInt(t.nextToken(), 8);
        }
        if (t.hasMoreTokens()) {
            addr = Integer.parseInt(t.nextToken());
        }
        return Instruction.asInstr(op, addr);
    }
}

