/*
 * Decompiled with CFR 0.152.
 */
package elliott803.utils;

import elliott803.machine.Dump;
import elliott803.utils.Args;
import elliott803.utils.PrintCore;
import elliott803.view.MachineImage;
import elliott803.view.ViewImage;
import java.awt.Rectangle;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;

public class PrintMachine {
    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("nodump");
        Args parms = new Args("PrintMachine", "machine [outputfile]", args, options);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile(2);
        boolean nodump = parms.getFlag("nodump");
        if (inputFile == null) {
            parms.usage();
        }
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        MachineImage image = MachineImage.readImage(inputFile);
        Dump dump = image.imageDump;
        ViewImage view = image.imageView;
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        output.println("Elliott 803B Machine Image");
        output.println("created: " + df.format(dump.timestamp));
        output.println();
        if (nodump) {
            output.println("Core store omitted.");
            output.println();
        } else {
            output.println("Core store:");
            PrintCore formatter = new PrintCore(output);
            formatter.printStore(dump.core, 0, 8192);
        }
        if (view == null) {
            output.println("No view details.");
        } else {
            output.println("View details:");
            output.println("  Application: " + view.title);
            output.println("    position = " + PrintMachine.printRect(view.position) + ", " + PrintMachine.printRect(view.position2));
            output.println();
            output.println("  Windows:");
            for (ViewImage v : view.windows) {
                System.out.println("    " + v.title);
                System.out.println("      position = " + PrintMachine.printRect(v.position));
                System.out.println("      isMin = " + v.isMin + ", isMax = " + v.isMax);
            }
            output.println();
        }
    }

    private static String printRect(Rectangle rect) {
        return "[x=" + rect.x + " y=" + rect.y + " w=" + rect.width + " h=" + rect.height + "]";
    }
}

