/*
 * Decompiled with CFR 0.152.
 */
package elliott803.utils;

import elliott803.machine.Instruction;
import elliott803.machine.Trace;
import elliott803.machine.Word;
import elliott803.utils.Args;
import java.io.File;
import java.io.PrintStream;
import java.text.DateFormat;

public class PrintTrace {
    public static void main(String[] args) throws Exception {
        Args parms = new Args("PrintTrace", "tracefile [outputfile]", args, null);
        File inputFile = parms.getInputFile(1);
        File outputFile = parms.getOutputFile(2);
        if (inputFile == null) {
            parms.usage();
        }
        PrintStream output = System.out;
        if (outputFile != null) {
            output = new PrintStream(outputFile);
        }
        Trace trace = Trace.readTrace(inputFile);
        DateFormat df = DateFormat.getDateTimeInstance(1, 1);
        output.println("Elliott 803B Instruction Trace");
        output.println("created: " + df.format(trace.timestamp));
        output.println();
        Trace.Entry entry = trace.nextEntry();
        while (entry != null) {
            output.print(String.valueOf(Instruction.toAddrString(entry.scr)) + "." + entry.scr2 + ":  ");
            output.print(Word.toInstrString(entry.ir));
            output.print("   " + (entry.oflow ? "O" : "-"));
            output.print("   " + Word.toOctalString(entry.acc) + " (" + Word.toIntegerString(entry.acc) + ")");
            output.println();
            entry = trace.nextEntry();
        }
        output.println();
    }
}

