/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.machine.Computer;
import elliott803.machine.Dump;
import elliott803.view.ComputerView;
import elliott803.view.ViewImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class MachineImage {
    public Dump imageDump;
    public ViewImage imageView;

    public MachineImage() {
    }

    public MachineImage(Computer computer, ComputerView view) {
        this.imageDump = new Dump(computer);
        this.imageView = new ViewImage(view);
    }

    public boolean apply(Computer computer, ComputerView view) {
        boolean layout = false;
        computer.cpu.reset();
        computer.core.restore(this.imageDump);
        if (this.imageView != null) {
            layout = this.imageView.layout(view);
        }
        return layout;
    }

    public void write(File file) {
        try {
            DeflaterOutputStream stream = new DeflaterOutputStream(new FileOutputStream(file));
            this.imageDump.write(stream);
            if (this.imageView != null) {
                this.imageView.write(stream);
            }
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static MachineImage readImage(File file) {
        MachineImage machine = new MachineImage();
        try {
            InflaterInputStream stream = new InflaterInputStream(new FileInputStream(file));
            machine.imageDump = Dump.readDump(stream);
            machine.imageView = ViewImage.readImage(stream);
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return machine;
    }
}

