/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.view.component.DeviceLight;
import elliott803.view.component.DeviceMode;
import elliott803.view.component.DeviceModeSelect;
import elliott803.view.component.DisplayLight;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public abstract class TapeDeviceView
extends JInternalFrame
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    static final String DEV_EJECT = "Eject";
    static final String DEV_LOAD = "Load";
    static final String DEV_SAVE = "Save";
    static final String DEV_OPEN = "Open";
    JLabel file;
    DeviceMode mode;
    DeviceLight wait;
    DeviceLight busy;
    JFileChooser select;
    JButton open;
    DeviceModeSelect modeSelect;
    Timer busyTimer;

    public TapeDeviceView(String name) {
        super(name, true, false, true, true);
        this.file = new JLabel();
        this.mode = new DeviceMode("System");
        this.modeSelect = new DeviceModeSelect(false, false);
        this.select = new JFileChooser(new File("."));
        this.select.setDialogTitle(String.valueOf(this.getTitle()) + " - Output Log");
        this.select.setAccessory(this.modeSelect);
    }

    public TapeDeviceView(String name, String type, String operation, int id) {
        super(String.valueOf(name) + " " + id, false, false, false, true);
        this.setFocusable(true);
        this.addFocusListener(this);
        this.file = new JLabel(" ");
        this.mode = new DeviceMode("Elliott");
        this.wait = new DeviceLight("Waiting", DisplayLight.RED);
        this.busy = new DeviceLight("Busy", DisplayLight.GREEN);
        this.modeSelect = new DeviceModeSelect(operation.equals(DEV_LOAD), true);
        this.select = new JFileChooser(new File("."));
        this.select.setDialogTitle(String.valueOf(this.getTitle()) + " - " + operation + " Tape");
        this.select.setAccessory(this.modeSelect);
        this.busyTimer = new Timer(1000, this);
        this.busyTimer.setRepeats(false);
        this.busyTimer.start();
        JPanel tape = new JPanel();
        tape.setLayout(new BoxLayout(tape, 1));
        tape.setBorder(BorderFactory.createTitledBorder(String.valueOf(type) + " Tape"));
        tape.setAlignmentX(0.5f);
        tape.add(this.file);
        JPanel action = new JPanel();
        action.setLayout(new BoxLayout(action, 0));
        action.setAlignmentX(0.5f);
        JPanel bp = new JPanel();
        bp.setLayout(new BoxLayout(bp, 1));
        bp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton eb = new JButton(DEV_EJECT);
        eb.setAlignmentX(0.0f);
        eb.addActionListener(this);
        this.open = new JButton(String.valueOf(operation) + "...");
        this.open.setAlignmentX(0.0f);
        this.open.setActionCommand(DEV_OPEN);
        this.open.addActionListener(this);
        bp.add(eb);
        bp.add(Box.createVerticalStrut(5));
        bp.add(this.open);
        JPanel sp = new JPanel();
        sp.setLayout(new BoxLayout(sp, 1));
        sp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        sp.add(this.busy);
        sp.add(Box.createVerticalStrut(3));
        sp.add(this.wait);
        sp.add(Box.createVerticalGlue());
        sp.add(this.mode);
        action.add(bp);
        action.add(Box.createHorizontalGlue());
        action.add(sp);
        Container content = this.getContentPane();
        content.add((Component)tape, "North");
        content.add((Component)action, "South");
        this.pack();
        this.setVisible(true);
    }

    void setTape(File file, String mode, boolean ascii) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.busyTimer) {
            this.busy.setValue(false);
        } else if (e.getActionCommand().equals(DEV_EJECT)) {
            this.file.setText(" ");
            this.setTape(null, null, false);
        } else if (e.getActionCommand().equals(DEV_OPEN) && this.select.showDialog(this, e.getActionCommand()) == 0) {
            File f = this.select.getSelectedFile();
            this.file.setText(f.getName());
            this.mode.setMode(this.modeSelect.getMode());
            this.setTape(f, this.modeSelect.getMode(), this.modeSelect.getAscii());
        }
    }

    public void focusGained(FocusEvent e) {
        this.getRootPane().setDefaultButton(this.open);
    }

    public void focusLost(FocusEvent e) {
    }

    public void updateCh(int ch) {
        this.busy.setValue(true);
        this.busyTimer.restart();
    }

    public void updateTape(Object tape) {
        if (tape == null) {
            this.file.setText(" ");
        }
    }

    public void updateWait(boolean state) {
        this.wait.setValue(state);
    }
}

