/*
 * Decompiled with CFR 0.152.
 */
package elliott803;

import elliott803.machine.Computer;
import elliott803.utils.Args;
import elliott803.view.ComputerView;
import elliott803.view.Loudspeaker;
import elliott803.view.MachineImage;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class Main
implements Runnable {
    JFrame frame;
    Computer computer;
    ComputerView computerView;
    boolean layout;

    public static void main(String[] args) throws Exception {
        Args.Map options = Args.optionMap();
        options.put("look", "lookAndFeel");
        options.put("volume", "volume");
        options.put("sound", "sampleRate:bufferSize");
        options.put("debug");
        Args parms = new Args("elliott803.Main", "[machine]", args, options);
        Computer.debug = parms.getFlag("debug");
        String sound = parms.getOption("sound");
        if (sound != null) {
            String[] sp = sound.split(":");
            if (sp.length > 0 && sp[0].length() > 0) {
                Loudspeaker.sampleRate = Math.max(8000, Integer.parseInt(sp[0]));
            }
            if (sp.length > 1 && sp[1].length() > 0) {
                Loudspeaker.bufferSize = Math.max(0, Integer.parseInt(sp[1]));
            }
        }
        Main.setLookAndFeel(parms.getOption("look"));
        File imageFile = parms.getInputFile(1);
        MachineImage image = null;
        if (imageFile != null) {
            image = MachineImage.readImage(imageFile);
        }
        int volume = parms.getInteger("volume");
        volume = (volume = Math.max(-1, Math.min(10, volume))) < 0 ? 50 : volume * 10;
        Computer computer = new Computer(volume);
        ComputerView view = new ComputerView(computer);
        computer.start();
        Main gui = new Main(computer, view, image);
        SwingUtilities.invokeLater(gui);
    }

    private static void setLookAndFeel(String look) throws Exception {
        UIManager.LookAndFeelInfo info;
        int n;
        int n2;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        String lafClass = null;
        String lafTheme = null;
        if (Computer.debug) {
            System.out.println("Look:");
            lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            n2 = lookAndFeelInfoArray.length;
            n = 0;
            while (n < n2) {
                info = lookAndFeelInfoArray[n];
                String name = info.getName();
                if (name.equals("Metal")) {
                    name = String.valueOf(name) + "/Steel/Ocean";
                }
                System.out.println("  " + name);
                ++n;
            }
        }
        if (look != null) {
            if (look.equalsIgnoreCase("Steel") || look.equalsIgnoreCase("Ocean")) {
                lafTheme = look;
                look = "Metal";
            }
            lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            n2 = lookAndFeelInfoArray.length;
            n = 0;
            while (n < n2) {
                info = lookAndFeelInfoArray[n];
                if (info.getName().equalsIgnoreCase(look)) {
                    lafClass = info.getClassName();
                    break;
                }
                ++n;
            }
            if (lafClass == null) {
                look = look.toUpperCase();
                lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
                n2 = lookAndFeelInfoArray.length;
                n = 0;
                while (n < n2) {
                    info = lookAndFeelInfoArray[n];
                    if (info.getName().toUpperCase().contains(look)) {
                        lafClass = info.getClassName();
                        break;
                    }
                    ++n;
                }
            }
        } else {
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf == null || laf.getID().equals("Metal")) {
                lafClass = UIManager.getSystemLookAndFeelClassName();
            }
        }
        if (lafClass != null) {
            if (lafTheme != null) {
                if (lafTheme.equalsIgnoreCase("Steel")) {
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                } else if (lafTheme.equalsIgnoreCase("Ocean")) {
                    MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                }
            }
            UIManager.setLookAndFeel(lafClass);
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
    }

    public Main(Computer computer, ComputerView view, MachineImage image) {
        this.computer = computer;
        this.computerView = view;
        Image icon = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("icon/803-32.png"));
        this.frame = new JFrame(String.valueOf(computer.name) + " Simulation (v" + computer.version + ")");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setIconImage(icon);
        this.frame.setContentPane(view);
        this.layout = view.defaultLayout();
        if (image != null) {
            this.layout = image.apply(computer, view);
        }
    }

    public void run() {
        if (!this.layout) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.pack();
            this.frame.setLocation((screen.width - this.frame.getWidth()) / 2, (screen.height - this.frame.getHeight()) / 2);
        }
        this.frame.setVisible(true);
    }
}

