/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.machine.Computer;
import elliott803.machine.Word;
import java.math.BigInteger;

public class ALU {
    public Computer computer;
    boolean overflow = false;
    long extension = 0L;

    public ALU(Computer computer) {
        this.computer = computer;
    }

    public long add(long n1, long n2) {
        long result = Word.getLong(n1) + Word.getLong(n2);
        this.checkOverflow(result);
        return Word.asInteger(result);
    }

    public long sub(long n1, long n2) {
        long result = Word.getLong(n1) - Word.getLong(n2);
        this.checkOverflow(result);
        return Word.asInteger(result);
    }

    public long and(long n1, long n2) {
        long result = Word.getLong(n1) & Word.getLong(n2);
        this.checkOverflow(result);
        return Word.asInteger(result);
    }

    public long shr(long n1, int n) {
        long result = Word.getBits(n1) >> n;
        return Word.asInteger(result);
    }

    /*
     * Unable to fully structure code
     */
    public long shl(long n1, int n) {
        block1: {
            result = Word.getLong(n1);
            if (n >= 26) ** GOTO lbl6
            this.checkOverflow(result <<= n);
            break block1;
lbl-1000:
            // 1 sources

            {
                this.checkOverflow(result <<= 1);
lbl6:
                // 2 sources

                ** while (n-- > 0)
            }
        }
        return Word.asInteger(result);
    }

    public long mul(long n1, long n2) {
        long result;
        if (n1 == (long)((int)n1) && n2 == (long)((int)n2)) {
            result = Word.getLong(n1) * Word.getLong(n2);
            this.checkOverflow(result);
        } else {
            BigInteger bigResult = this.makeBig(n1).multiply(this.makeBig(n2));
            this.overflow = bigResult.bitLength() > 38;
            result = bigResult.longValue();
        }
        return Word.asInteger(result);
    }

    public boolean isZero(long n) {
        return Word.getLong(n) == 0L;
    }

    public boolean isNeg(long n) {
        return Word.getLong(n) < 0L;
    }

    public long longMul(long n1, long n2) {
        BigInteger result = this.makeBig(n1).multiply(this.makeBig(n2));
        this.overflow = result.bitLength() > 76;
        return this.makeLong2(result);
    }

    public long longDiv(long n1, long nx, long n2) {
        long n = 0L;
        if (n2 != 0L) {
            BigInteger result = this.makeBig(n1, nx).divide(this.makeBig(n2));
            this.overflow = result.bitLength() > 76;
            n = this.makeLong1(result);
        } else {
            this.overflow = true;
            this.extension = 0L;
        }
        return n;
    }

    public long longShr(long n1, long nx, int n) {
        BigInteger result = this.makeBig(n1, nx).shiftRight(n);
        this.overflow = result.bitLength() > 76;
        return this.makeLong2(result);
    }

    public long longShl(long n1, long nx, int n) {
        BigInteger result = this.makeBig(n1, nx).shiftLeft(n);
        this.overflow = result.bitLength() > 76;
        return this.makeLong2(result);
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public long getExtension() {
        return this.extension;
    }

    BigInteger makeBig(long n) {
        return BigInteger.valueOf(Word.getLong(n));
    }

    BigInteger makeBig(long n, long nx) {
        return BigInteger.valueOf(Word.getLong(n)).shiftLeft(38).or(BigInteger.valueOf(nx));
    }

    long makeLong1(BigInteger n) {
        this.extension = 0L;
        return Word.asInteger(n.longValue());
    }

    long makeLong2(BigInteger n) {
        this.extension = Word.asExtension(n.longValue());
        return Word.asInteger(n.shiftRight(38).longValue());
    }

    void checkOverflow(long n) {
        this.overflow = (n &= 0xFFFFFFC000000000L) != 0L && n != -274877906944L;
    }
}

