/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.hardware.TapeDevice;
import elliott803.machine.Computer;
import java.io.IOException;
import java.io.OutputStream;

public class Punch
extends TapeDevice {
    OutputStream outputTape = null;

    public Punch(Computer computer, int id) {
        super(computer, id);
        this.setSpeed(100);
    }

    public void setTape(OutputStream tape) {
        if (this.outputTape != null) {
            try {
                this.outputTape.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        this.outputTape = tape;
        this.viewTape(tape);
        this.deviceReady();
    }

    public void write(int ch) {
        this.writeCh(ch &= 0x1F);
        if (this.outputTape == null) {
            this.deviceWait();
            this.writeCh(ch);
        }
        if (this.outputTape != null) {
            this.transfer(ch);
        }
    }

    void writeCh(int ch) {
        if (this.outputTape != null) {
            try {
                this.outputTape.write(ch);
            }
            catch (IOException e) {
                System.err.println(e);
                this.setTape(null);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PUNCH ").append(this.id).append(":");
        sb.append(" tape=").append(this.outputTape);
        sb.append(" ").append(this.deviceBusy() ? "WAITING" : "READY");
        return sb.toString();
    }
}

