/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.hardware.TapeDevice;
import elliott803.machine.Computer;
import java.io.IOException;
import java.io.InputStream;

public class Reader
extends TapeDevice {
    InputStream inputTape = null;

    public Reader(Computer computer, int id) {
        super(computer, id);
        this.setSpeed(500);
    }

    public void setTape(InputStream tape) {
        if (this.inputTape != null) {
            try {
                this.inputTape.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        this.inputTape = tape;
        this.viewTape(tape);
        this.deviceReady();
    }

    public int read() {
        int ch = this.readCh();
        if (this.inputTape == null) {
            this.deviceWait();
            ch = this.readCh();
        }
        if (this.inputTape != null) {
            this.transfer(ch);
        }
        return ch & 0x1F;
    }

    private int readCh() {
        int ch = 0;
        if (this.inputTape != null) {
            try {
                ch = this.inputTape.read();
                if (ch == -1) {
                    this.setTape(null);
                    ch = 0;
                }
            }
            catch (IOException e) {
                System.err.println(e);
                this.setTape(null);
            }
        }
        return ch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("READER ").append(this.id).append(":");
        sb.append(" tape=").append(this.inputTape);
        sb.append(" ").append(this.deviceBusy() ? "WAITING" : "READY");
        return sb.toString();
    }
}

