/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.hardware.CPU;
import elliott803.view.component.DeviceLight;
import elliott803.view.component.DisplayAddress;
import elliott803.view.component.DisplayInstruction;
import elliott803.view.component.DisplayLight;
import elliott803.view.component.DisplayWord;
import elliott803.view.component.PushButton;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class CpuView
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    CPU cpu;
    DisplayWord acc;
    DisplayWord ar;
    DisplayInstruction ir;
    DisplayAddress scr;
    DisplayWord iw;
    DeviceLight overflow;
    DeviceLight fpOverflow;
    PushButton dump;
    JCheckBox trace;

    public CpuView(CPU cpu) {
        super("CPU", false, false, false, true);
        this.cpu = cpu;
        this.acc = new DisplayWord("ACC", DisplayWord.Type.OCTAL);
        this.ar = new DisplayWord("AR", DisplayWord.Type.OCTAL);
        this.ir = new DisplayInstruction("IR", 6);
        this.scr = new DisplayAddress();
        this.iw = new DisplayWord(DisplayWord.Type.INSTRUCTION);
        this.overflow = new DeviceLight("Overflow", DisplayLight.CYAN);
        this.fpOverflow = new DeviceLight("FP Overflow", DisplayLight.CYAN);
        JPanel p0 = new JPanel();
        p0.setLayout(new BoxLayout(p0, 0));
        p0.setAlignmentX(0.0f);
        p0.setBorder(BorderFactory.createTitledBorder("Registers"));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.setAlignmentX(0.0f);
        p1.add(this.acc);
        p1.add(this.ar);
        p1.add(this.ir);
        p0.add(p1);
        p0.add(Box.createHorizontalGlue());
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.setBorder(BorderFactory.createTitledBorder("State"));
        p2.setAlignmentX(0.0f);
        this.overflow.setAlignmentX(0.0f);
        this.fpOverflow.setAlignmentX(1.0f);
        p2.add(this.overflow);
        p2.add(Box.createHorizontalStrut(10));
        p2.add(Box.createHorizontalGlue());
        p2.add(this.fpOverflow);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 0));
        p3.setAlignmentX(0.0f);
        p3.setBorder(BorderFactory.createTitledBorder("Instruction"));
        p3.add(this.scr);
        p3.add(Box.createHorizontalStrut(5));
        p3.add(this.iw);
        p3.add(Box.createHorizontalGlue());
        JPanel p4 = new JPanel();
        p4.setLayout(new BoxLayout(p4, 0));
        p4.setBorder(BorderFactory.createTitledBorder("Debug"));
        p4.setAlignmentX(0.0f);
        this.dump = new PushButton("Dump", true);
        this.dump.addActionListener(this);
        p4.add(this.dump);
        p4.add(Box.createHorizontalGlue());
        this.trace = new JCheckBox("Trace");
        this.trace.addActionListener(this);
        p4.add(this.trace);
        cpu.setView(this);
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        content.add(p0);
        content.add(p2);
        content.add(p3);
        content.add(Box.createVerticalStrut(10));
        content.add(p4);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dump) {
            this.cpu.computer.dump();
        } else if (e.getSource() == this.trace) {
            if (this.trace.isSelected()) {
                this.cpu.computer.traceStart();
            } else {
                this.cpu.computer.traceStop();
            }
        }
    }

    public void updateRegisters(long a, long x, int i, int pc, long instr) {
        if (!this.isIcon()) {
            this.acc.setValue(a);
            this.ar.setValue(x);
            this.ir.setValue(i);
            this.scr.setValue(pc);
            this.iw.setValue(instr);
        }
    }

    public void updateFlags(boolean over, boolean fpOver) {
        if (!this.isIcon()) {
            this.overflow.setValue(over);
            this.fpOverflow.setValue(fpOver);
        }
    }

    public void updateTrace(boolean enabled) {
        if (!this.isIcon()) {
            this.trace.setSelected(enabled);
        }
    }
}

