/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.hardware.Reader;
import elliott803.telecode.Telecode;
import elliott803.telecode.TelecodeInputStream;
import elliott803.view.TapeDeviceView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;

public class ReaderView
extends TapeDeviceView {
    private static final long serialVersionUID = 1L;
    Reader reader;

    public ReaderView(Reader reader, int id) {
        super("Reader", "Input", "Load", id);
        this.reader = reader;
        reader.setView(this);
    }

    void setTape(File file, String fmode, boolean ascii) {
        if (file == null) {
            this.reader.setTape(null);
        } else {
            try {
                if (fmode.equals("Auto")) {
                    fmode = Telecode.isTelecode(file) ? "Elliott" : "System";
                    this.mode.setMode(fmode);
                }
                InputStream input = null;
                input = fmode.equals("Elliott") ? new FileInputStream(file) : new TelecodeInputStream(new FileReader(file));
                this.reader.setTape(input);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }
}

