/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.hardware.Punch;
import elliott803.telecode.TelecodeInputStream;
import elliott803.telecode.TelecodeOutputStream;
import elliott803.telecode.TelecodeToChar;
import elliott803.view.TapeDeviceView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class TeletypeView
extends TapeDeviceView
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final int TT_COLUMNS = 80;
    static final String TT_CURSOR = "\u220e";
    static final String TT_CLEAR = "Clear";
    static final String TT_SCROLL = "Scroll";
    static final String TT_SAVE = "Save...";
    Punch teletype;
    JTextArea paper;
    TelecodeToChar converter = new TelecodeToChar();
    byte[] tc = new byte[1];
    char[] cc = new char[1];

    public TeletypeView(Punch teletype) {
        super("Teletype");
        this.teletype = teletype;
        this.paper = new JTextArea(TT_CURSOR, 15, 80);
        this.paper.setFont(Font.decode("Monospaced-bold"));
        this.paper.setLineWrap(false);
        this.paper.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.paper);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(30);
        JPanel actions = new JPanel();
        actions.setLayout(new BoxLayout(actions, 0));
        actions.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        actions.setAlignmentX(0.0f);
        JButton clear = new JButton(TT_CLEAR);
        clear.setActionCommand("Eject");
        clear.addActionListener(this);
        JButton scb = new JButton(TT_SCROLL);
        scb.addActionListener(this);
        this.open = new JButton(TT_SAVE);
        this.open.setActionCommand("Open");
        this.open.addActionListener(this);
        actions.add(scb);
        actions.add(Box.createHorizontalStrut(5));
        actions.add(clear);
        actions.add(Box.createHorizontalStrut(5));
        actions.add(this.open);
        actions.add(Box.createHorizontalGlue());
        actions.add(this.file);
        teletype.setView(this);
        Container content = this.getContentPane();
        content.add((Component)scroll, "Center");
        content.add((Component)actions, "South");
        this.pack();
        this.setVisible(true);
    }

    public void setChar(char ch) {
        int pos = this.paper.getDocument().getLength() - 1;
        try {
            int line = this.paper.getLineCount() - 1;
            if (line >= 0 && ch != '\n' && this.paper.getLineEndOffset(line) - this.paper.getLineStartOffset(line) >= 80) {
                this.paper.insert("\n", pos++);
            }
        }
        catch (BadLocationException e) {
            System.err.println(e);
        }
        this.paper.insert(Character.toString(ch), pos);
        this.paper.setCaretPosition(pos);
    }

    public void clearText() {
        this.paper.setText(TT_CURSOR);
        this.paper.setCaretPosition(0);
    }

    void setTape(File lfile, String mode, boolean ascii) {
        if (lfile == null) {
            this.clearText();
            this.teletype.setTape(null);
        } else {
            try {
                TelecodeOutputStream output = new TelecodeOutputStream(new FileWriter(lfile, true), ascii);
                TelecodeInputStream input = new TelecodeInputStream(new StringReader(this.paper.getText()));
                output.write(input);
                this.teletype.setTape(output);
                this.file.setText("Output log: " + lfile.getName());
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand().equals(TT_SCROLL)) {
            this.setChar('\n');
        }
    }

    public void updateCh(int ch) {
        if (ch != 0 && ch != 29) {
            this.tc[0] = (byte)ch;
            if (this.converter.convert(this.tc, 1, this.cc) != 0) {
                this.setChar(this.cc[0]);
            }
        }
    }
}

