/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view.component;

import elliott803.machine.Word;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DisplayWord
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final Font monoFont = Font.decode("monospaced");
    Type type;
    JLabel text;

    public DisplayWord(Type type) {
        this(null, type, 0);
    }

    public DisplayWord(String name, Type type) {
        this(name, type, 0);
    }

    public DisplayWord(String name, Type type, int fill) {
        this.type = type;
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(1.0f);
        if (name != null) {
            JLabel title = new JLabel(String.valueOf(name) + ":");
            title.setAlignmentY(0.5f);
            title.setAlignmentX(1.0f);
            this.add(title);
            this.add(Box.createHorizontalStrut(5));
        }
        if (fill > 0) {
            JLabel filler = new JLabel(new String(new char[fill]).replace('\u0000', ' '));
            filler.setFont(monoFont);
            this.add(filler);
        }
        this.text = new JLabel();
        this.text.setAlignmentY(0.5f);
        this.text.setAlignmentX(0.0f);
        this.text.setFont(monoFont);
        this.text.setHorizontalTextPosition(2);
        this.add(this.text);
        this.setValue(0L);
    }

    public void setValue(long value) {
        String txt = null;
        switch (this.type) {
            default: {
                break;
            }
            case BIN39: {
                txt = Word.toBinaryString(value);
                break;
            }
            case BIN38: {
                txt = Word.toBin38String(value);
                break;
            }
            case OCTAL: {
                txt = Word.toOctalString(value);
                break;
            }
            case INTEGER: {
                txt = Word.toIntegerString(value);
                break;
            }
            case FLOAT: {
                txt = Word.toFloatString(value);
                break;
            }
            case INSTRUCTION: {
                txt = Word.toInstrString(value);
            }
        }
        this.text.setText(txt);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BIN39,
        BIN38,
        OCTAL,
        INTEGER,
        FLOAT,
        INSTRUCTION,
        TEXT;

    }
}

