/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.machine.Computer;
import elliott803.machine.Dump;
import elliott803.machine.Instruction;
import elliott803.machine.Trace;
import elliott803.machine.Word;
import elliott803.view.CpuView;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class CPU {
    public Computer computer;
    long acc;
    long ar;
    boolean overflow;
    boolean fpOverflow;
    long ir;
    int irx;
    int scr;
    int scr2;
    AtomicBoolean running;
    boolean jump;
    Trace trace;
    boolean useSpin;
    int cycleNano;
    int cycles;
    long spinPause;
    long sleepPause;
    long busyStart;
    AtomicBoolean realTime;
    AtomicLong cpuStart;
    AtomicLong cpuBusy;
    AtomicLong cpuCycles;
    CpuView view;

    public CPU(Computer computer) {
        this.computer = computer;
        this.running = new AtomicBoolean();
        this.realTime = new AtomicBoolean();
        this.cpuStart = new AtomicLong();
        this.cpuBusy = new AtomicLong();
        this.cpuCycles = new AtomicLong();
        this.setCycleTime(288);
        this.calibrate();
        if (Computer.debug) {
            System.out.println("CPU:");
            System.out.println("  sleep time: " + this.sleepPause + "ns");
            System.out.println("  spin time: " + this.spinPause + "ns");
            System.out.println("  pause method: " + (this.useSpin ? "spin" : "sleep"));
            System.out.println("  cycle time: " + this.cycleNano / 1000 + "us");
        }
    }

    public void setCycleTime(int us) {
        this.cycleNano = us * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstruction(int instruction) {
        CPU cPU = this;
        synchronized (cPU) {
            this.irx = Instruction.asInstr(instruction);
            this.viewState();
        }
    }

    public void stop() {
        this.running.set(false);
        this.computer.console.setStep(true);
        this.cpuCycles.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.stop();
        this.computer.busyClear();
        this.computer.console.setOverflow(false, false);
        this.computer.console.setBusy(false);
        CPU cPU = this;
        synchronized (cPU) {
            this.ar = 0L;
            this.acc = 0L;
            this.scr = 0;
            this.scr2 = 0;
            this.irx = 0;
            this.ir = 0;
            this.fpOverflow = false;
            this.overflow = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        this.stop();
        CPU cPU = this;
        synchronized (cPU) {
            this.jump = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long now;
        this.computer.console.setStep(false);
        this.cpuStart.set(System.currentTimeMillis());
        this.cpuBusy.set(0L);
        this.cpuCycles.set(0L);
        long end = now = System.nanoTime();
        this.running.set(true);
        while (this.running.get()) {
            CPU cPU = this;
            synchronized (cPU) {
                this.obey();
                this.cpuCycles.addAndGet(this.cycles);
                if (this.realTime.get()) {
                    if (this.busyStart != 0L) {
                        now = end = System.nanoTime();
                    } else {
                        long pause = (end += (long)(this.cycles * this.cycleNano)) - now;
                        if (pause > this.sleepPause) {
                            try {
                                Thread.sleep(pause / 1000000L, (int)pause % 1000000);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            now = System.nanoTime();
                        } else if (this.useSpin) {
                            while (end - now > this.spinPause) {
                                now = System.nanoTime();
                            }
                        }
                    }
                }
                this.computer.console.setBlockTr(false);
                this.computer.console.setBusy(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obey() {
        CPU cPU = this;
        synchronized (cPU) {
            this.execute();
            if (!this.jump) {
                if (this.scr2 == 0) {
                    this.scr2 = 1;
                } else {
                    this.scr2 = 0;
                    this.scr = Instruction.getAddr(this.scr + 1);
                }
            }
            this.fetch();
            this.viewState();
        }
    }

    void fetch() {
        if (this.scr2 == 0) {
            this.ir = this.computer.core.fetch(this.scr);
            this.irx = Word.getInstr1(this.ir);
        } else if (this.jump || Word.getB(this.ir) == 0) {
            this.ir = this.computer.core.fetch(this.scr);
            this.irx = Word.getInstr2(this.ir);
        } else {
            long b = this.computer.core.read(Instruction.getAddr(this.irx));
            this.irx = Word.getInstr2(this.ir) + Word.getInstr2(b);
        }
        if (this.trace != null && (this.jump || this.scr2 == 0)) {
            this.trace.trace(this.scr, this.scr2, this.ir, this.acc, this.overflow);
        }
    }

    void execute() {
        int op = Instruction.getOp(this.irx);
        int addr = Instruction.getAddr(this.irx);
        this.computer.console.speakerSound(op > 31, 1);
        this.busyStart = 0L;
        this.jump = false;
        this.cycles = 2;
        switch (op >> 3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.group0123(op, addr);
                break;
            }
            case 4: {
                this.group4(op, addr);
                break;
            }
            case 5: {
                this.group5(op, addr);
                break;
            }
            case 6: {
                this.group6(op, addr);
                break;
            }
            case 7: {
                this.group7(op, addr);
            }
        }
        if (this.busyStart == 0L) {
            this.computer.console.speakerSound(false, this.cycles - 1);
        }
        this.computer.console.setOverflow(this.overflow, this.fpOverflow);
        if (this.fpOverflow) {
            this.computer.console.suspend();
            this.fpOverflow = false;
            this.computer.console.setOverflow(this.overflow, this.fpOverflow);
        }
    }

    void group0123(int op, int addr) {
        long a = this.acc;
        long n = this.computer.core.read(addr);
        long x = (op & 8) == 0 ? a : n;
        long result = 0L;
        switch (op & 7) {
            case 0: {
                result = this.computer.alu.add(0L, x);
                break;
            }
            case 1: {
                result = this.computer.alu.sub(0L, x);
                break;
            }
            case 2: {
                result = this.computer.alu.add(1L, n);
                break;
            }
            case 3: {
                result = this.computer.alu.and(a, n);
                break;
            }
            case 4: {
                result = this.computer.alu.add(a, n);
                break;
            }
            case 5: {
                result = this.computer.alu.sub(a, n);
                break;
            }
            case 6: {
                result = this.computer.alu.add(0L, 0L);
                break;
            }
            case 7: {
                result = this.computer.alu.sub(n, a);
            }
        }
        this.overflow |= this.computer.alu.isOverflow();
        switch (op >> 3) {
            case 0: {
                this.acc = result;
                x = n;
                break;
            }
            case 1: {
                this.acc = result;
                x = a;
                break;
            }
            case 2: {
                this.acc = a;
                x = result;
                break;
            }
            case 3: {
                this.acc = n;
                x = result;
            }
        }
        this.computer.core.write(addr, x);
        this.cycles = 2;
    }

    void group4(int op, int addr) {
        switch (op & 3) {
            case 0: {
                this.jump = true;
                break;
            }
            case 1: {
                this.jump = this.computer.alu.isNeg(this.acc);
                break;
            }
            case 2: {
                this.jump = this.computer.alu.isZero(this.acc);
                break;
            }
            case 3: {
                this.jump = this.overflow;
                this.overflow = false;
            }
        }
        if (this.jump) {
            this.scr = addr;
            this.scr2 = (op & 7) >> 2;
        }
        this.cycles = 1;
    }

    void group5(int op, int addr) {
        long n = this.computer.core.read(addr);
        int s = addr & 0x7F;
        if ((op & 1) != 0) {
            switch (op & 7) {
                case 1: {
                    this.acc = this.computer.alu.shr(this.acc, s);
                    this.ar = 0L;
                    this.cycles = s + 2;
                    break;
                }
                case 5: {
                    this.acc = this.computer.alu.shl(this.acc, s);
                    this.ar = 0L;
                    this.cycles = s + 2;
                    break;
                }
                case 3: {
                    this.acc = this.computer.alu.mul(this.acc, n);
                    this.ar = 0L;
                    this.cycles = 43 - this.y();
                    break;
                }
                case 7: {
                    this.acc = this.ar;
                    this.cycles = 2;
                }
            }
        } else {
            switch (op & 7) {
                case 0: {
                    this.acc = this.computer.alu.longShr(this.acc, this.ar, s);
                    this.cycles = s + 2;
                    break;
                }
                case 4: {
                    this.acc = this.computer.alu.longShl(this.acc, this.ar, s);
                    this.cycles = s + 2;
                    break;
                }
                case 2: {
                    this.acc = this.computer.alu.longMul(this.acc, n);
                    this.cycles = 42 - this.y();
                    break;
                }
                case 6: {
                    this.acc = this.computer.alu.longDiv(this.acc, this.ar, n);
                    this.cycles = 42;
                }
            }
            this.ar = this.computer.alu.getExtension();
        }
        this.overflow |= this.computer.alu.isOverflow();
    }

    int y() {
        long a = this.acc;
        long bit = this.acc & 0x4000000000L;
        int y = 0;
        while (y < 39 && (a & 0x4000000000L) == bit) {
            a <<= 1;
            ++y;
        }
        return y;
    }

    void group6(int op, int addr) {
        if (this.computer.fpu != null) {
            long n = this.computer.core.read(addr);
            switch (op & 7) {
                case 0: {
                    this.acc = this.computer.fpu.add(this.acc, n);
                    this.cycles = 3;
                    break;
                }
                case 1: {
                    this.acc = this.computer.fpu.sub(this.acc, n);
                    this.cycles = 3;
                    break;
                }
                case 2: {
                    this.acc = this.computer.fpu.sub(n, this.acc);
                    this.cycles = 3;
                    break;
                }
                case 3: {
                    this.acc = this.computer.fpu.mul(this.acc, n);
                    this.cycles = 17;
                    break;
                }
                case 4: {
                    this.acc = this.computer.fpu.div(this.acc, n);
                    this.cycles = 34;
                    break;
                }
                case 5: {
                    if (addr < 4096) {
                        this.acc = this.computer.fpu.shl(this.acc, addr % 64);
                        this.cycles = 2;
                        break;
                    }
                    this.acc = this.computer.fpu.convert(this.acc);
                    this.cycles = 2;
                    break;
                }
                case 6: {
                    this.acc = this.computer.fpu.sdiv(this.acc, n);
                    this.cycles = 16;
                    break;
                }
                case 7: {
                    this.acc = this.computer.fpu.sqrt(this.acc);
                    this.cycles = 15;
                }
            }
            this.ar = 0L;
            this.overflow |= this.computer.fpu.isOverflow();
            this.fpOverflow |= this.computer.fpu.isFpOverflow();
        }
    }

    void group7(int op, int addr) {
        switch (op & 7) {
            case 0: {
                this.acc = this.computer.console.read();
                break;
            }
            case 3: {
                this.computer.core.write(addr, Word.asInstr(this.scr, 0, this.scr));
                break;
            }
            case 1: {
                this.acc |= (long)this.computer.pts.read(addr);
                break;
            }
            case 4: {
                this.computer.pts.write(addr);
                break;
            }
            case 2: {
                this.computer.devices.controlWrite(addr, this.acc);
                break;
            }
            case 5: {
                long a = this.computer.devices.controlRead(addr);
                if (a == -1L) break;
                this.acc = a;
                break;
            }
        }
    }

    public void setRealTime(boolean rt) {
        this.realTime.set(rt);
    }

    public float getSpeed() {
        float factor = 0.0f;
        if (this.cpuCycles.get() > 0L) {
            float cpuTime = System.currentTimeMillis() - this.cpuStart.get() - this.cpuBusy.get();
            factor = (float)(this.cpuCycles.get() * (long)(this.cycleNano / 1000)) / (cpuTime * 1000.0f);
            this.cpuStart.set(System.currentTimeMillis());
            this.cpuBusy.set(0L);
            this.cpuCycles.set(0L);
        }
        return factor;
    }

    public synchronized void busy(boolean start) {
        if (start) {
            this.busyStart = System.currentTimeMillis();
        } else if (this.busyStart != 0L) {
            this.cpuBusy.addAndGet(System.currentTimeMillis() - this.busyStart);
        }
    }

    public synchronized void addDelay(int us) {
        this.cycles += us * 1000 / this.cycleNano;
    }

    void calibrate() {
        long nt = 0L;
        long st = 0L;
        int i = 0;
        while (i < 5) {
            long t1 = System.nanoTime();
            long t2 = System.nanoTime();
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long t3 = System.nanoTime();
            nt += t2 - t1;
            st += t3 - t2;
            ++i;
        }
        this.spinPause = nt / 5L;
        this.sleepPause = st / 5L;
        this.useSpin = this.sleepPause > (long)(40 * this.cycleNano);
    }

    public synchronized void dump(Dump dump) {
        dump.acc = this.acc;
        dump.ar = this.ar;
        dump.ir = this.ir;
        dump.ix = this.irx;
        dump.scr = this.scr;
        dump.scr2 = this.scr2;
        dump.overflow = this.overflow;
        dump.fpOverflow = this.fpOverflow;
    }

    public synchronized void trace(Trace trace) {
        this.trace = trace;
        this.viewTrace();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CPU:");
        sb.append(" acc=").append(Word.toOctalString(this.acc));
        sb.append(" scr=").append(this.scr).append(".").append(this.scr2);
        sb.append(" ir=\"").append(Word.toInstrString(this.ir)).append("\"");
        sb.append(" overflow=").append(this.overflow);
        return sb.toString();
    }

    public void setView(CpuView view) {
        this.view = view;
    }

    void viewState() {
        if (this.view != null) {
            this.view.updateRegisters(this.acc, this.ar, this.irx, this.scr, this.ir);
            this.view.updateFlags(this.overflow, this.fpOverflow);
        }
    }

    void viewTrace() {
        if (this.view != null) {
            this.view.updateTrace(this.trace != null);
        }
    }
}

