/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.machine.Computer;
import elliott803.machine.Word;

public class FPU {
    public Computer computer;
    boolean overflow = false;
    boolean fpOverflow = false;

    public FPU(Computer computer) {
        this.computer = computer;
    }

    public long add(long n1, long n2) {
        double result = Word.getDouble(n1) + Word.getDouble(n2);
        return this.makeFloat(result);
    }

    public long sub(long n1, long n2) {
        double result = Word.getDouble(n1) - Word.getDouble(n2);
        return this.makeFloat(result);
    }

    public long mul(long n1, long n2) {
        double result = Word.getDouble(n1) * Word.getDouble(n2);
        return this.makeFloat(result);
    }

    public long div(long n1, long n2) {
        double result = 0.0;
        if (n2 != 0L) {
            result = Word.getDouble(n1) / Word.getDouble(n2);
        } else {
            this.fpOverflow = true;
            this.overflow = true;
        }
        return this.makeFloat(result);
    }

    public long convert(long n) {
        return this.makeFloat(Word.getLong(n));
    }

    public long shl(long n1, int n) {
        return Word.asInteger(n1 << n | n1 >> 39 - n);
    }

    public long sdiv(long n1, long n2) {
        long result = 0L;
        if (n2 != 0L) {
            result = Word.getLong(n1) / Word.getLong(n2);
        }
        return Word.asInteger(result);
    }

    public long sqrt(long n) {
        long result = (long)Math.sqrt(Word.getLong(n));
        return Word.asInteger(result);
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public boolean isFpOverflow() {
        return this.fpOverflow;
    }

    long makeFloat(double value) {
        long result = Word.asFloat(value);
        this.fpOverflow = false;
        this.overflow = false;
        if (result == -1L) {
            this.fpOverflow = true;
            result = 0L;
        }
        return result;
    }
}

