/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.hardware.Punch;
import elliott803.hardware.Reader;
import elliott803.hardware.TapeDevice;
import elliott803.hardware.Teletype;
import elliott803.machine.Computer;
import java.io.InputStream;
import java.io.OutputStream;

public class PaperTapeStation {
    public static final int READER1 = 0;
    public static final int READER2 = 1;
    public static final int PUNCH1 = 0;
    public static final int PUNCH2 = 1;
    public static final int TELETYPE = 2;
    public Computer computer;
    public Reader[] readers;
    public Punch[] punches;
    boolean swapReader;
    boolean swapPunch;

    public PaperTapeStation(Computer computer) {
        this.computer = computer;
        this.readers = new Reader[2];
        this.readers[0] = new Reader(computer, 1);
        this.readers[1] = new Reader(computer, 2);
        this.swapReader = false;
        this.punches = new Punch[3];
        this.punches[0] = new Punch(computer, 1);
        this.punches[1] = new Punch(computer, 2);
        this.punches[2] = new Teletype(computer, 3);
        this.swapPunch = false;
    }

    public void setReaderTape(int id, InputStream tape) {
        if (id < this.readers.length && this.readers[id] != null) {
            this.readers[id].setTape(tape);
        }
    }

    public void setPunchTape(int id, OutputStream tape) {
        if (id < this.punches.length && this.punches[id] != null) {
            this.punches[id].setTape(tape);
        }
    }

    public void setReaders(boolean exchange) {
        if (exchange != this.swapReader) {
            Reader r = this.readers[0];
            this.readers[0] = this.readers[1];
            this.readers[1] = r;
            this.swapReader = exchange;
        }
    }

    public void setPunches(boolean exchange) {
        if (exchange != this.swapPunch) {
            Punch p = this.punches[0];
            this.punches[0] = this.punches[1];
            this.punches[1] = p;
            this.swapPunch = exchange;
        }
    }

    public void setRealTime(boolean rt) {
        TapeDevice[] tapeDeviceArray = this.punches;
        int n = this.punches.length;
        int n2 = 0;
        while (n2 < n) {
            Punch punch = tapeDeviceArray[n2];
            punch.setRealTime(rt);
            ++n2;
        }
        tapeDeviceArray = this.readers;
        n = this.readers.length;
        n2 = 0;
        while (n2 < n) {
            TapeDevice reader = tapeDeviceArray[n2];
            reader.setRealTime(rt);
            ++n2;
        }
    }

    public int read(int addr) {
        int ch = 0;
        ch = addr >= 2048 && this.readers[1] != null ? this.readers[1].read() : this.readers[0].read();
        return ch;
    }

    public void write(int addr) {
        if (addr >= 4096 && this.punches[2] != null) {
            this.punches[2].write(addr);
        } else if (addr >= 2048 && this.punches[1] != null) {
            this.punches[1].write(addr);
        } else {
            this.punches[0].write(addr);
        }
    }
}

