/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.machine.Computer;
import elliott803.machine.Dump;
import elliott803.machine.Instruction;
import elliott803.machine.Word;
import elliott803.view.StoreView;

public class Store {
    static final int STORE_SIZE = 8192;
    static final int STORE_START = 4;
    public Computer computer;
    long[] store = null;
    int lastAddr;
    long lastValue;
    StoreView view;

    public Store(Computer computer) {
        this.computer = computer;
        this.store = new long[8192];
        this.store[0] = Word.parseInstr("26 4 : 06 0");
        this.store[1] = Word.parseInstr("22 4 / 16 3");
        this.store[2] = Word.parseInstr("55 5 : 71 0");
        this.store[3] = Word.parseInstr("43 1 : 40 2");
    }

    public void clear() {
        int i = 4;
        while (i < 8192) {
            this.store[i] = 0L;
            this.viewWord(i, 0L);
            ++i;
        }
    }

    public long read(int addr) {
        if ((addr &= Instruction.ADDR_MASK) >= 4) {
            return this.store[addr];
        }
        return 0L;
    }

    public long fetch(int addr) {
        return this.store[addr &= Instruction.ADDR_MASK];
    }

    public void write(int addr, long value) {
        if ((addr &= Instruction.ADDR_MASK) >= 4) {
            this.store[addr] = value;
            this.lastAddr = addr;
            this.lastValue = value;
            this.viewWord(addr, value);
        }
    }

    public void dump(Dump dump) {
        dump.core = this.store;
    }

    public void restore(Dump dump) {
        System.arraycopy(dump.core, 4, this.store, 4, 8188);
        this.viewStore(this.store);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("STORE: last write ").append(this.lastAddr).append("=").append(Word.toOctalString(this.lastValue));
        return sb.toString();
    }

    public void setView(StoreView view) {
        this.view = view;
    }

    void viewWord(int addr, long value) {
        if (this.view != null) {
            this.view.updateCore(addr, value);
        }
    }

    void viewStore(long[] store) {
        if (this.view != null) {
            this.view.updateCore(store);
        }
    }
}

