/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware.device;

import elliott803.machine.Computer;

public abstract class Device {
    public Computer computer;
    boolean busy;
    boolean realTime;
    int delay;

    public void setComputer(Computer computer) {
        this.computer = computer;
    }

    public boolean deviceBusy() {
        return this.busy;
    }

    protected void deviceWait() {
        this.busy = true;
        this.computer.busyWait();
    }

    protected void deviceReady() {
        if (this.busy) {
            this.computer.busyClear();
            this.busy = false;
        }
    }

    public void setRealTime(boolean rt) {
        this.realTime = rt;
    }

    protected void setSpeed(int cps) {
        this.delay = cps == 0 ? 0 : 1000000 / cps;
    }

    protected void devicePause() {
        if (this.realTime && this.delay > 0) {
            this.computer.cpu.addDelay(this.delay);
        }
    }
}

