/*
 * Decompiled with CFR 0.152.
 */
package elliott803.machine;

import elliott803.hardware.ALU;
import elliott803.hardware.CPU;
import elliott803.hardware.Console;
import elliott803.hardware.FPU;
import elliott803.hardware.PaperTapeStation;
import elliott803.hardware.Plotter;
import elliott803.hardware.Store;
import elliott803.machine.DeviceManager;
import elliott803.machine.Dump;
import elliott803.machine.Instruction;
import elliott803.machine.Trace;
import elliott803.machine.extension.RandomNumberDevice;
import elliott803.machine.extension.SimulatorControlDevice;

public class Computer
extends Thread {
    public static boolean debug = false;
    public static final int ACT_WAIT = 0;
    public static final int ACT_CLEAR = 1;
    public static final int ACT_STEP = 2;
    public static final int ACT_RUN = 3;
    public String name;
    public String version;
    public Store core;
    public CPU cpu;
    public ALU alu;
    public FPU fpu;
    public PaperTapeStation pts;
    public Console console;
    public Plotter plotter;
    public DeviceManager devices;
    boolean busyExit;
    boolean busyWait;
    Object threadRun = new Object();
    int action = 0;
    Trace trace;

    public Computer() {
        this(0);
    }

    public Computer(int volume) {
        this.name = this.getClass().getPackage().getImplementationTitle();
        this.version = this.getClass().getPackage().getImplementationVersion();
        if (this.name == null || this.version == null) {
            this.name = "Elliott 803B";
            this.version = "0.0.0";
        }
        this.setName(this.name);
        this.setPriority(Math.max(1, this.getPriority() / 2));
        this.core = new Store(this);
        this.cpu = new CPU(this);
        this.alu = new ALU(this);
        this.fpu = new FPU(this);
        this.pts = new PaperTapeStation(this);
        this.plotter = new Plotter(this);
        this.devices = new DeviceManager(this);
        this.devices.addControlDevice(this.plotter);
        this.devices.addControlDevice(new RandomNumberDevice());
        this.devices.addControlDevice(new SimulatorControlDevice());
        this.console = new Console(this);
        this.console.setVolume(volume);
        this.console.setStep(true);
        this.setRealTime(true);
    }

    public synchronized void busyWait() {
        this.console.setBusy(true);
        if (this.busyExit) {
            this.cpu.exit();
        } else {
            this.busyWait = true;
            this.cpu.busy(true);
            while (this.busyWait) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cpu.busy(false);
        }
    }

    public synchronized void busyClear() {
        if (this.busyWait) {
            this.busyWait = false;
            this.notify();
        }
        this.console.setBusy(false);
    }

    public void dump(Dump dump) {
        dump.busy = this.busyWait;
    }

    public void setRealTime(boolean rt) {
        this.cpu.setRealTime(rt);
        this.pts.setRealTime(rt);
        this.plotter.setRealTime(rt);
        this.console.setSpeaker(rt);
    }

    public void runInstructions(int addr) {
        this.cpu.setInstruction(Instruction.asInstr(32, addr));
        this.runInstructions();
    }

    public void runInstructions() {
        this.busyExit = true;
        this.cpu.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int act) {
        Object object = this.threadRun;
        synchronized (object) {
            this.action = act;
            this.threadRun.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            int act = 0;
            Object object = this.threadRun;
            synchronized (object) {
                try {
                    this.threadRun.wait();
                    act = this.action;
                    this.action = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            switch (act) {
                case 2: {
                    this.cpu.obey();
                    break;
                }
                case 3: {
                    this.cpu.run();
                    break;
                }
                case 1: {
                    this.cpu.stop();
                    this.core.clear();
                }
            }
        }
    }

    public void dump() {
        Dump dump = new Dump(this);
        dump.write();
    }

    public void traceStart() {
        if (this.trace == null) {
            this.trace = new Trace(this);
            this.cpu.trace(this.trace);
        }
    }

    public void traceStop() {
        if (this.trace != null) {
            this.cpu.trace(null);
            this.trace.write();
            this.trace = null;
        }
    }

    public Computer(boolean test) {
        this.cpu = new CPU(this);
        this.core = new Store(this);
        this.console = new Console(this);
    }
}

