/*
 * Decompiled with CFR 0.152.
 */
package elliott803.machine;

import elliott803.machine.Computer;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Trace
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int BUFFER_SIZE = 8192;
    public String name;
    public String version;
    public Date timestamp;
    transient Entry[] traceLog;
    transient int maximum;
    transient int position;
    transient ObjectOutputStream out;
    transient ObjectInputStream in;

    public Trace(Computer computer) {
        this.name = computer.name;
        this.version = computer.version;
        this.timestamp = new Date();
        this.maximum = 8192;
        this.position = 0;
        this.traceLog = new Entry[this.maximum];
    }

    public void trace(int scr, int scr2, long ir, long acc, boolean oflow) {
        if (this.position == this.maximum) {
            this.flush(false);
            this.position = 0;
        }
        this.traceLog[this.position++] = new Entry(scr, scr2, ir, acc, oflow);
    }

    public void write() {
        this.flush(true);
    }

    synchronized void flush(boolean close) {
        if (this.out == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
            String filename = "elliott-" + df.format(this.timestamp) + ".trace";
            try {
                FileOutputStream fout = new FileOutputStream(filename);
                DeflaterOutputStream zout = new DeflaterOutputStream(fout);
                this.out = new ObjectOutputStream(zout);
                this.out.writeObject(this);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        if (this.out != null) {
            try {
                int i = 0;
                while (i < this.position) {
                    this.out.writeObject(this.traceLog[i]);
                    ++i;
                }
                if (close) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public Entry nextEntry() {
        Entry entry = null;
        if (this.in != null) {
            try {
                entry = (Entry)this.in.readObject();
            }
            catch (EOFException e) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (IOException e1) {
                    System.err.println(e1);
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return entry;
    }

    public static Trace readTrace(File file) {
        Trace trace = null;
        try {
            InflaterInputStream stream = new InflaterInputStream(new FileInputStream(file));
            ObjectInputStream in = new ObjectInputStream(stream);
            trace = (Trace)in.readObject();
            trace.in = in;
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return trace;
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int scr;
        public int scr2;
        public long ir;
        public long acc;
        public boolean oflow;

        public Entry(int scr, int scr2, long ir, long acc, boolean oflow) {
            this.scr = scr;
            this.scr2 = scr2;
            this.ir = ir;
            this.acc = acc;
            this.oflow = oflow;
        }
    }
}

