/*
 * Decompiled with CFR 0.152.
 */
package elliott803.telecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public abstract class Telecode {
    public static final byte TELE_BL = 0;
    public static final byte TELE_FS = 27;
    public static final byte TELE_SP = 28;
    public static final byte TELE_CR = 29;
    public static final byte TELE_LF = 30;
    public static final byte TELE_LS = 31;
    public static final char GBP = '\u00a3';
    public static final char NUM = '#';
    public static final int CHAR_MASK = 31;
    static final String letterShift = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZ\u0000 \r\n\u0000";
    static final String figureShift = "\u000012*4$=78',+:-.%0()3?56/@9#\u0000 \r\n\u0000";

    public static char asLetter(int tc) {
        return letterShift.charAt(tc & 0x1F);
    }

    public static char asFigure(int tc) {
        return figureShift.charAt(tc & 0x1F);
    }

    public static boolean isTelecode(File file) throws IOException {
        boolean telecode = true;
        byte[] buf = new byte[128];
        FileInputStream in = new FileInputStream(file);
        int i = 0;
        while (i < in.read(buf)) {
            if (buf[i] > 31) {
                telecode = false;
                break;
            }
            ++i;
        }
        in.close();
        return telecode;
    }
}

