/*
 * Decompiled with CFR 0.152.
 */
package elliott803.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Args {
    String name;
    String parms;
    Map opts;
    HashMap<String, String> options = new HashMap();
    List<String> parameters = new ArrayList<String>();

    public static Map optionMap() {
        return new Map();
    }

    public Args(String name, String parms, String[] args, Map opts) {
        this.name = name;
        this.parms = parms;
        this.opts = opts;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if ((arg = arg.substring(1)).equals("?")) {
                    this.usage();
                }
                if (opts != null && opts.containsKey(arg)) {
                    if (opts.get(arg) != null && i < args.length - 1) {
                        this.options.put(arg, args[++i]);
                    } else {
                        this.options.put(arg, null);
                    }
                } else {
                    this.error("Incorrect option", arg, true);
                }
            } else if (arg.equals("?")) {
                this.usage();
            } else {
                this.parameters.add(arg);
            }
            ++i;
        }
    }

    public String getParameter(int position) {
        String result = null;
        if (position <= this.parameters.size()) {
            result = this.parameters.get(position - 1);
        }
        return result;
    }

    public List<String> getParameters(int firstPos) {
        return this.getParameters(firstPos, 0);
    }

    public List<String> getParameters(int firstPos, int lastPos) {
        ArrayList<String> results = new ArrayList<String>();
        int i = firstPos;
        while (lastPos == 0 || i <= lastPos) {
            String result = this.getParameter(i);
            if (result == null) break;
            results.add(result);
            ++i;
        }
        return results;
    }

    public String getOption(String option) {
        return this.options.get(option);
    }

    public boolean getFlag(String option) {
        return this.options.containsKey(option);
    }

    public File getInputFile(int position) {
        return this.getNamedInputFile(this.getParameter(position));
    }

    public File getInputFile(String option) {
        return this.getNamedInputFile(this.getOption(option));
    }

    private File getNamedInputFile(String name) {
        File result = null;
        if (!(name == null || (result = new File(name)).exists() && result.isFile() && result.canRead())) {
            this.error("Cannot open input file", name, false);
        }
        return result;
    }

    public List<File> getInputFiles(int position) {
        return this.getNamedInputFiles(this.getParameters(position));
    }

    private List<File> getNamedInputFiles(List<String> names) {
        ArrayList<File> results = new ArrayList<File>();
        for (String name : names) {
            results.add(this.getNamedInputFile(name));
        }
        return results;
    }

    public File getOutputFile(int position) {
        return this.getNamedOutputFile(this.getParameter(position));
    }

    public File getOutputFile(String option) {
        return this.getNamedOutputFile(this.getOption(option));
    }

    private File getNamedOutputFile(String name) {
        File result = null;
        if (!(name == null || !(result = new File(name)).exists() || result.isFile() && result.canWrite())) {
            this.error("Cannot open output file", name, false);
        }
        return result;
    }

    public int getInteger(int position) {
        return this.getIntegerValue(this.getParameter(position));
    }

    public int getInteger(String option) {
        return this.getIntegerValue(this.getOption(option));
    }

    private int getIntegerValue(String value) {
        int result = -1;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.error("Expected numeric parameter", value, true);
            }
        }
        return result;
    }

    public void usage() {
        System.out.println("Usage:\n");
        if (this.opts == null) {
            System.out.println("  " + this.name + " " + this.parms + "\n");
        } else {
            System.out.println("  " + this.name + " [options] " + this.parms + "\n");
            String hdr = "options:";
            for (String opt : this.opts.keySet()) {
                System.out.print(String.valueOf(hdr) + " -" + opt);
                hdr = "        ";
                String value = (String)this.opts.get(opt);
                if (value != null) {
                    if (value.startsWith("+")) {
                        value = value.substring(1);
                        hdr = "";
                    }
                    System.out.print(" " + value);
                }
                if (hdr.length() <= 0) continue;
                System.out.println();
            }
        }
        System.exit(1);
    }

    private void error(String msg, String parm, boolean usage) {
        System.out.println(String.valueOf(msg) + ": " + parm);
        if (usage) {
            System.out.println();
            this.usage();
        }
        System.exit(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Map
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1L;

        public void put(String key) {
            this.put(key, null);
        }
    }
}

