/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.hardware.Console;
import elliott803.view.Loudspeaker;
import elliott803.view.component.ConsoleButtons;
import elliott803.view.component.ConsoleControl;
import elliott803.view.component.ConsoleLights;
import elliott803.view.component.ConsoleOperation;
import elliott803.view.component.ConsoleVolume;
import elliott803.view.component.DisplayWord;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class ConsoleView
extends JInternalFrame
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    static final String CONSOLE_OPERATE = "Operate";
    static final String[] FN_NAMES = new String[]{"4", "2", "1", "4", "2", "1"};
    static final String[] ADDR_NAMES = new String[]{"4096", "2048", "1024", "512", "256", "128", "64", "32", "16", "8", "4", "2", "1", "B"};
    Console console;
    Loudspeaker speaker;
    ConsoleLights lights;
    ConsoleVolume volume;
    JButton operate;
    DisplayWord wordgen;

    public ConsoleView(Console console) {
        super("Operator Console", false, false, false, true);
        this.console = console;
        this.setFocusable(true);
        this.addFocusListener(this);
        this.speaker = new Loudspeaker();
        this.speaker.setVolume(console.getVolume());
        this.volume = new ConsoleVolume(console);
        console.computer.cpu.setCycleTime(this.speaker.getCycleTime());
        JPanel wg = new JPanel();
        wg.setLayout(new BoxLayout(wg, 1));
        wg.add(new ConsoleButtons("Function 1", FN_NAMES, 6, 39, console));
        wg.add(Box.createVerticalStrut(10));
        wg.add(new ConsoleButtons("Address 1", ADDR_NAMES, 14, 33, console));
        wg.add(Box.createVerticalStrut(10));
        wg.add(new ConsoleButtons("Function 2", FN_NAMES, 6, 19, console));
        wg.add(Box.createVerticalStrut(10));
        wg.add(new ConsoleButtons("Address 2", ADDR_NAMES, 13, 13, console));
        wg.add(Box.createVerticalStrut(20));
        this.wordgen = new DisplayWord("Word", DisplayWord.Type.INSTRUCTION);
        this.wordgen.setAlignmentX(0.0f);
        this.wordgen.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wg.add(this.wordgen);
        this.lights = new ConsoleLights();
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.add(Box.createVerticalGlue());
        controls.add(this.volume);
        controls.add(Box.createVerticalGlue());
        controls.add(new ConsoleControl(console));
        controls.add(Box.createVerticalStrut(10));
        controls.add(new ConsoleOperation(console));
        controls.add(Box.createVerticalStrut(10));
        this.operate = new JButton(CONSOLE_OPERATE);
        this.operate.setAlignmentX(0.5f);
        this.operate.addActionListener(this);
        controls.add(this.operate);
        controls.add(Box.createVerticalStrut(10));
        console.setView(this);
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 0));
        content.add(wg);
        content.add(Box.createHorizontalStrut(5));
        content.add(this.lights);
        content.add(Box.createHorizontalStrut(5));
        content.add(controls);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(CONSOLE_OPERATE)) {
            this.console.operate();
        }
    }

    public void focusGained(FocusEvent e) {
        this.getRootPane().setDefaultButton(this.operate);
    }

    public void focusLost(FocusEvent e) {
    }

    public void updateWordGen(long value) {
        this.wordgen.setValue(value);
    }

    public void updateLights(boolean isStep, boolean blockTr, boolean isBusy, boolean isOverflow, boolean isFpOver) {
        this.lights.setStep(isStep);
        this.lights.setBlockTr(blockTr);
        this.lights.setBusy(isBusy);
        this.lights.setOverflow(isOverflow);
        this.lights.setFpOverflow(isFpOver);
    }

    public void updateVolume(boolean on, int vol) {
        this.speaker.setVolume(on ? vol : 0);
        this.volume.setEnabled(on);
    }

    public void soundSpeaker(boolean click, int count) {
        this.speaker.sound(click, count);
    }

    public void silenceSpeaker() {
        this.speaker.silence();
    }
}

