/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.hardware.Plotter;
import elliott803.view.PlotterPaper;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PlotterView
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static final String PLOT_CLEAR = "Clear";
    Plotter plotter;
    PlotterPaper paper;

    public PlotterView(Plotter plotter) {
        super("Plotter", true, false, true, true);
        this.plotter = plotter;
        this.paper = new PlotterPaper();
        JScrollPane scroll = new JScrollPane(this.paper);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(31);
        JPanel actions = new JPanel();
        actions.setLayout(new BoxLayout(actions, 0));
        actions.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        actions.setAlignmentX(0.0f);
        JButton clear = new JButton(PLOT_CLEAR);
        clear.addActionListener(this);
        actions.add(clear);
        plotter.setView(this);
        Container content = this.getContentPane();
        content.add((Component)scroll, "Center");
        content.add((Component)actions, "South");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(PLOT_CLEAR)) {
            this.plotter.reset();
            this.paper.plotClear();
        }
    }

    public void penMove(int x, int y, int dir) {
        this.paper.plotMove(x, y, dir);
    }

    public void penDraw(int x, int y, int dir) {
        this.paper.plotDraw(x, y, dir);
    }
}

