/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

public class ViewImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String title;
    public Rectangle position;
    public Rectangle position2;
    public boolean isMin;
    public boolean isMax;
    public List<ViewImage> windows;

    public ViewImage(JDesktopPane desktop) {
        JFrame app = (JFrame)desktop.getTopLevelAncestor();
        this.title = app.getTitle();
        this.position = app.getBounds();
        this.position2 = desktop.getBounds();
        this.windows = new ArrayList<ViewImage>();
        JInternalFrame[] jInternalFrameArray = desktop.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame frame = jInternalFrameArray[n2];
            this.windows.add(new ViewImage(frame));
            ++n2;
        }
    }

    public ViewImage(JInternalFrame frame) {
        this.title = frame.getTitle();
        this.position = frame.getNormalBounds();
        this.isMin = frame.isIcon();
        this.isMax = frame.isMaximum();
    }

    public boolean layout(JDesktopPane desktop) {
        JFrame app = (JFrame)desktop.getTopLevelAncestor();
        desktop.setPreferredSize(this.position2.getSize());
        desktop.setBounds(this.position2);
        app.setBounds(this.position);
        app.validate();
        LinkedHashMap<String, JInternalFrame> index = new LinkedHashMap<String, JInternalFrame>();
        JInternalFrame[] jInternalFrameArray = desktop.getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame frame = jInternalFrameArray[n2];
            index.put(frame.getTitle(), frame);
            ++n2;
        }
        desktop.removeAll();
        for (ViewImage window : this.windows) {
            JInternalFrame frame = (JInternalFrame)index.remove(window.title);
            if (frame == null) continue;
            desktop.add(frame);
            window.layout(frame);
        }
        for (JInternalFrame frame : index.values()) {
            desktop.add(frame);
        }
        return true;
    }

    public void layout(JInternalFrame frame) {
        try {
            frame.setIcon(false);
            frame.setMaximum(false);
            frame.setLocation(this.position.getLocation());
            if (frame.isResizable()) {
                frame.setSize(this.position.getSize());
            }
            if (this.isMin) {
                frame.setIcon(true);
            }
            if (this.isMax) {
                frame.setMaximum(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void write(OutputStream stream) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(stream);
        out.writeObject(this);
        out.flush();
    }

    public static ViewImage readImage(InputStream stream) throws IOException, ClassNotFoundException {
        ViewImage view = null;
        try {
            ObjectInputStream in = new ObjectInputStream(stream);
            view = (ViewImage)in.readObject();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return view;
    }
}

