/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view.component;

import elliott803.hardware.Console;
import elliott803.view.component.DisplaySpeaker;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConsoleVolume
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    Console console;
    JSlider slider;

    public ConsoleVolume(Console console) {
        this.console = console;
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.5f);
        DisplaySpeaker grill = new DisplaySpeaker();
        this.add(grill);
        this.add(Box.createVerticalStrut(5));
        this.slider = new JSlider(0, 100, console.getVolume());
        this.slider.addChangeListener(this);
        this.slider.setAlignmentX(0.5f);
        this.slider.setMajorTickSpacing(20);
        this.slider.setPaintTicks(true);
        this.slider.setFocusable(false);
        Dimension size = new Dimension(grill.getPreferredSize().width, this.slider.getPreferredSize().height);
        this.slider.setMaximumSize(size);
        this.slider.setPreferredSize(size);
        this.add(this.slider);
        JLabel t = new JLabel("Volume");
        t.setAlignmentX(0.5f);
        this.add(t);
    }

    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
    }

    public void stateChanged(ChangeEvent e) {
        JSlider slider = (JSlider)e.getSource();
        if (!slider.getValueIsAdjusting()) {
            this.console.setVolume(slider.getValue());
        }
    }
}

