/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.hardware.device.Device;
import elliott803.machine.Computer;
import elliott803.machine.Word;
import elliott803.view.ConsoleView;

public class Console
extends Device {
    public static final int CONSOLE_READ = 1;
    public static final int CONSOLE_OBEY = 2;
    public static final int CONSOLE_NORMAL = 3;
    long wordGen;
    int action;
    boolean clearStore;
    boolean manualData;
    boolean manualDataDelay;
    boolean blockTr;
    boolean busy;
    boolean step;
    boolean overflow;
    boolean fpOverflow;
    boolean speakerOn;
    int speakerVol;
    ConsoleView view;

    public Console(Computer computer) {
        this.computer = computer;
        this.action = 1;
    }

    public long read() {
        if (this.manualData) {
            this.suspend();
        } else if (this.manualDataDelay) {
            this.manualData = true;
            this.manualDataDelay = false;
        }
        return this.wordGen;
    }

    public long readWordGen() {
        return this.wordGen;
    }

    public void setWordGen(long value) {
        this.wordGen = value;
        this.viewWordGen();
    }

    public void setWordGenBit(int bit) {
        if (bit > 0 && bit < 40) {
            this.wordGen |= 1L << bit - 1;
            this.viewWordGen();
        }
    }

    public void clearWordGenBit(int bit) {
        if (bit > 0 && bit < 40) {
            this.wordGen &= 1L << bit - 1 ^ 0xFFFFFFFFFFFFFFFFL;
            this.viewWordGen();
        }
    }

    public void toggleWordGenBit(int bit) {
        if (bit > 0 && bit < 40) {
            this.wordGen ^= 1L << bit - 1;
            this.viewWordGen();
        }
    }

    public void setManualData(boolean isManualData) {
        this.manualData = isManualData;
    }

    public void setManualDataDelay() {
        this.manualData = false;
        this.manualDataDelay = true;
    }

    public void setClearStore(boolean isClearStore) {
        this.clearStore = isClearStore;
    }

    public void setBlockTr(boolean isBlockTr) {
        if (this.blockTr != isBlockTr) {
            this.blockTr = isBlockTr;
            this.viewLights();
        }
    }

    public void setBusy(boolean isBusy) {
        if (this.busy != isBusy) {
            this.busy = isBusy;
            this.viewLights();
            if (this.busy) {
                this.soundSilence();
            }
        }
    }

    public void setOverflow(boolean isOverflow, boolean isFpOver) {
        if (this.overflow != isOverflow || this.fpOverflow != isFpOver) {
            this.overflow = isOverflow;
            this.fpOverflow = isFpOver;
            this.viewLights();
        }
    }

    public void setStep(boolean isStep) {
        if (this.step != isStep) {
            this.step = isStep;
            this.viewLights();
            if (this.step) {
                this.soundSilence();
            }
        }
    }

    public void suspend() {
        this.deviceWait();
    }

    public void reset() {
        this.computer.cpu.reset();
    }

    public void setAction(int value) {
        this.computer.cpu.stop();
        this.action = value;
    }

    public void operate() {
        if (this.deviceBusy()) {
            this.deviceReady();
        } else if (this.clearStore) {
            switch (this.action) {
                case 3: {
                    this.computer.run(1);
                }
            }
        } else {
            switch (this.action) {
                case 1: {
                    this.computer.cpu.setInstruction(Word.getInstr1(this.wordGen));
                    break;
                }
                case 2: {
                    this.computer.run(2);
                    break;
                }
                case 3: {
                    this.computer.run(3);
                }
            }
        }
    }

    public void setSpeaker(boolean on) {
        this.speakerOn = on;
        this.viewVolume();
    }

    public void setVolume(int volume) {
        this.speakerVol = Math.max(0, Math.min(100, volume));
        this.viewVolume();
    }

    public int getVolume() {
        return this.speakerVol;
    }

    public void speakerSound(boolean click, int cycles) {
        this.soundClicks(click, cycles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CONSOLE:");
        sb.append(" wordgen=").append(Word.toOctalString(this.wordGen));
        sb.append(", \"").append(Word.toInstrString(this.wordGen)).append("\"");
        return sb.toString();
    }

    public void setView(ConsoleView view) {
        this.view = view;
        this.viewLights();
    }

    void viewWordGen() {
        if (this.view != null) {
            this.view.updateWordGen(this.wordGen);
        }
    }

    void viewLights() {
        if (this.view != null) {
            this.view.updateLights(this.step, this.blockTr, this.busy, this.overflow, this.fpOverflow);
        }
    }

    void viewVolume() {
        if (this.view != null) {
            this.view.updateVolume(this.speakerOn, this.speakerVol);
        }
    }

    void soundClicks(boolean click, int cycles) {
        if (this.view != null) {
            this.view.soundSpeaker(click, cycles);
        }
    }

    void soundSilence() {
        if (this.view != null) {
            this.view.silenceSpeaker();
        }
    }
}

