/*
 * Decompiled with CFR 0.152.
 */
package elliott803.hardware;

import elliott803.hardware.device.ControlDevice;
import elliott803.machine.Computer;
import elliott803.view.PlotterView;

public class Plotter
extends ControlDevice {
    static final int X_MIN = 0;
    static final int X_MAX = 1099;
    boolean penDown;
    int penX;
    int penY;
    PlotterView view;

    public Plotter(Computer computer) {
        this.computer = computer;
        this.setSpeed(300);
    }

    public int addressBase() {
        return 7168;
    }

    public int addressMask() {
        return 8128;
    }

    public void controlWrite(int addr, long acc) {
        int x = 0;
        int y = 0;
        switch (addr) {
            case 7184: {
                this.penDown = false;
                break;
            }
            case 7200: {
                this.penDown = true;
                break;
            }
            case 7169: {
                x = 1;
                break;
            }
            case 7170: {
                x = -1;
                break;
            }
            case 7172: {
                y = 1;
                break;
            }
            case 7176: {
                y = -1;
                break;
            }
            case 7173: {
                x = 1;
                y = 1;
                break;
            }
            case 7174: {
                x = -1;
                y = 1;
                break;
            }
            case 7177: {
                x = 1;
                y = -1;
                break;
            }
            case 7178: {
                x = -1;
                y = -1;
            }
        }
        if (x != 0 || y != 0) {
            this.penX += x;
            this.penY += y;
            this.penX = Math.max(0, Math.min(1099, this.penX));
            this.computer.console.setBlockTr(true);
            this.devicePause();
            this.viewPlot(this.penX, this.penY, addr);
        }
    }

    public void reset() {
        this.penY = 0;
        this.penX = 0;
        this.penDown = false;
    }

    public void setView(PlotterView view) {
        this.view = view;
    }

    void viewPlot(int x, int y, int dir) {
        if (this.view != null) {
            if (this.penDown) {
                this.view.penDraw(x, y, dir);
            } else {
                this.view.penMove(x, y, dir);
            }
        }
    }
}

