/*
 * Decompiled with CFR 0.152.
 */
package elliott803.machine;

import elliott803.hardware.device.ControlDevice;
import elliott803.machine.Computer;
import java.util.ArrayList;
import java.util.Collection;

public class DeviceManager {
    public Computer computer;
    Collection<ControlDevice> controlDevices;

    public DeviceManager(Computer computer) {
        this.computer = computer;
        this.controlDevices = new ArrayList<ControlDevice>();
    }

    public void addControlDevice(ControlDevice device) {
        device.setComputer(this.computer);
        this.controlDevices.add(device);
    }

    public void controlWrite(int addr, long acc) {
        ControlDevice device = this.findDevice(addr);
        if (device != null) {
            device.controlWrite(addr, acc);
        }
    }

    public long controlRead(int addr) {
        long acc = -1L;
        ControlDevice device = this.findDevice(addr);
        if (device != null) {
            acc = device.controlRead(addr);
        }
        return acc;
    }

    private ControlDevice findDevice(int addr) {
        ControlDevice device = null;
        for (ControlDevice dev : this.controlDevices) {
            if ((addr & dev.addressMask()) != dev.addressBase()) continue;
            device = dev;
            break;
        }
        return device;
    }
}

