/*
 * Decompiled with CFR 0.152.
 */
package elliott803.machine;

import elliott803.machine.Instruction;
import java.util.StringTokenizer;

public abstract class Word {
    public static final long NOTHING = -1L;
    public static final long CARRY_BIT = 0x8000000000L;
    public static final long SIGN_BIT = 0x4000000000L;
    public static final long WORD_MASK = 0x7FFFFFFFFFL;
    public static final long INT_MASK = 0x3FFFFFFFFFL;
    public static final long CHAR_MASK = 31L;
    static final int FP_FRAC_MASK = 0x3FFFFFFF;
    static final int FP_EXP_MASK = 511;
    static final int FP_FRAC_SIGN = 0x20000000;
    static final int FP_FRAC_BITS = 0x1FFFFFFF;
    static final int IEEE_EXP_MASK = 2047;
    static final long IEEE_FRAC_MASK = 0xFFFFFFFFFFFFFL;
    static final long IEEE_HIDDEN_BIT = 0x10000000000000L;
    static final long IEEE_TOP_BITS = 0x30000000000000L;

    public static final long getBits(long word) {
        return word & 0x7FFFFFFFFFL;
    }

    public static final long asWord(long word) {
        return word & 0x7FFFFFFFFFL;
    }

    public static final String toOctalString(long word) {
        StringBuilder result = new StringBuilder();
        String text = Long.toOctalString(Word.getBits(word));
        result.append("0000000000000", 0, 13 - text.length()).append(text);
        return result.toString();
    }

    public static final String toBinaryString(long word) {
        StringBuilder result = new StringBuilder();
        String text = Long.toBinaryString(Word.getBits(word));
        result.append("000000000000000000000000000000000000000", 0, 39 - text.length()).append(text);
        return result.toString();
    }

    public static final String toBin38String(long word) {
        StringBuilder result = new StringBuilder(Word.toBinaryString(word));
        result.setCharAt(0, ' ');
        return result.toString();
    }

    public static final int getInstr1(long word) {
        return (int)(word >> 20) & 0x7FFFF;
    }

    public static final int getInstr2(long word) {
        return (int)word & 0x7FFFF;
    }

    public static final int getB(long word) {
        return (int)(word >> 19) & 1;
    }

    public static final long asInstr1(int instr) {
        return (long)(instr & 0x7FFFF) << 20;
    }

    public static final long asInstr2(int instr) {
        return instr & 0x7FFFF;
    }

    public static final long asB(int b) {
        return (long)(b & 1) << 19;
    }

    public static final long asInstr(int instr1, int b, int instr2) {
        return Word.asInstr1(instr1) | Word.asB(b) | Word.asInstr2(instr2);
    }

    public static final String toInstrString(long word) {
        StringBuilder result = new StringBuilder();
        result.append(Instruction.toInstrString(Word.getInstr1(word)));
        result.append(Word.getB(word) == 0 ? " : " : " / ");
        result.append(Instruction.toInstrString(Word.getInstr2(word)));
        return result.toString();
    }

    public static final long parseInstr(String s) {
        int instr1 = 0;
        int instr2 = 0;
        int b = 0;
        StringTokenizer t = new StringTokenizer(s, ":/", true);
        if (t.hasMoreTokens()) {
            instr1 = Instruction.parseInstr(t.nextToken());
        }
        if (t.hasMoreTokens()) {
            int n = b = t.nextToken().equals("/") ? 1 : 0;
        }
        if (t.hasMoreTokens()) {
            instr2 = Instruction.parseInstr(t.nextToken());
        }
        return Word.asInstr(instr1, b, instr2);
    }

    public static final long getLong(long word) {
        return (word & 0x4000000000L) == 0L ? word & 0x3FFFFFFFFFL : word | 0xFFFFFFC000000000L;
    }

    public static final long asInteger(long value) {
        return value & 0x7FFFFFFFFFL;
    }

    public static final long asExtension(long value) {
        return value & 0x3FFFFFFFFFL;
    }

    public static final String toIntegerString(long word) {
        StringBuilder result = new StringBuilder();
        long value = Word.getLong(word);
        String text = Long.toString(Word.getLong(word));
        result.append(value > 0L ? "+" : "").append(text);
        return result.toString();
    }

    public static final double getDouble(long value) {
        double result = 0.0;
        if (value != 0L) {
            value = Word.getLong(value);
            int em = (int)(value >> 9);
            int ee = (int)(value & 0x1FFL) - 256;
            long s = em > 0 ? 0 : 1;
            if (em < 0) {
                em = -em;
            }
            while ((em & 0x20000000) == 0) {
                em <<= 1;
                --ee;
            }
            long a = (long)(em & 0x1FFFFFFF) << 23;
            long b = ee + 1023 & 0x7FF;
            result = Double.longBitsToDouble(s << 63 | b << 52 | a);
        }
        return result;
    }

    public static final long asFloat(double value) {
        long result = 0L;
        if (value != 0.0) {
            long bits = Double.doubleToLongBits(value);
            int ds = (int)(bits >>> 63);
            int de = ((int)(bits >>> 52) & 0x7FF) - 1023;
            long df = bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (ds != 0) {
                df = -df;
            }
            while ((df & 0x30000000000000L) == 0L || (df & 0x30000000000000L) == 0x30000000000000L) {
                df <<= 1;
                --de;
            }
            long a = df >> 24 & 0x3FFFFFFFL;
            int b = de + 257;
            result = b > 511 ? -1L : (b < 0 ? 0L : a << 9 | (long)b);
        }
        return result;
    }

    public static final String toFloatString(long value) {
        return Double.toString(Word.getDouble(value));
    }
}

