/*
 * Decompiled with CFR 0.152.
 */
package elliott803.telecode;

import elliott803.telecode.Telecode;

public class CharToTelecode
extends Telecode {
    static final String figureShift = "12*4$=78',+:-.%0()3?56/@9" + Character.toString('\u00a3');
    static final String figureAlt = "    &   ;       [] !  \\  " + Character.toString('#');
    static final String letterUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final String letterLower = "abcdefghijklmnopqrstuvwxyz";
    boolean isFigure = false;
    boolean isFirst = true;

    public void resetShift() {
        this.isFirst = true;
    }

    public int convert(char[] input, int inputSize, byte[] output) {
        int outputSize = 0;
        int i = 0;
        while (i < inputSize) {
            char ch = input[i];
            int li = this.isLetter(ch);
            int fi = this.isFigure(ch);
            int si = this.isSpecial(ch);
            if (li > 0) {
                if (this.isFirst || this.isFigure) {
                    output[outputSize++] = 31;
                    this.isFirst = false;
                    this.isFigure = false;
                }
                output[outputSize++] = (byte)li;
            } else if (fi > 0) {
                if (this.isFirst || !this.isFigure) {
                    output[outputSize++] = 27;
                    this.isFirst = false;
                    this.isFigure = true;
                }
                output[outputSize++] = (byte)fi;
            } else if (si >= 0) {
                output[outputSize++] = (byte)si;
            }
            ++i;
        }
        return outputSize;
    }

    private int isLetter(char ch) {
        int i = letterUpper.indexOf(ch);
        if (i == -1) {
            i = letterLower.indexOf(ch);
        }
        return i + 1;
    }

    private int isFigure(char ch) {
        int i = figureShift.indexOf(ch);
        if (i == -1 && ch != ' ') {
            i = figureAlt.indexOf(ch);
        }
        return i + 1;
    }

    private int isSpecial(char ch) {
        int i = -1;
        if (ch == '\u0000' || ch == '_') {
            i = 0;
        } else if (ch == ' ' || ch == '\t') {
            i = 28;
        } else if (ch == '\r') {
            i = 29;
        } else if (ch == '\n') {
            i = 30;
        }
        return i;
    }
}

