/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import elliott803.machine.Computer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public class Loudspeaker {
    public static int sampleRate = 44100;
    public static int bufferSize = 0;
    int frame = (sampleRate * 288 + 250000) / 1000000;
    int cycle = this.frame * 1000000 / sampleRate;
    byte[] pulse;
    byte[] quiet;
    AtomicBoolean on = new AtomicBoolean(false);
    SourceDataLine line;

    public Loudspeaker() {
        this.pulse = new byte[this.frame];
        this.quiet = new byte[this.frame];
        try {
            AudioFormat af = new AudioFormat(sampleRate, 8, 1, false, false);
            this.line = AudioSystem.getSourceDataLine(af);
            if (bufferSize > 0) {
                this.line.open(af, bufferSize / this.frame * this.frame);
            } else {
                this.line.open();
            }
        }
        catch (Throwable e) {
            System.err.println(e);
            this.line = null;
        }
        if (Computer.debug) {
            System.out.println("Speaker:");
            if (this.line != null) {
                System.out.println("  sample rate: " + this.line.getFormat().getFrameRate() / 1000.0f + "kHz");
                System.out.println("  frame length: " + this.frame);
                System.out.println("  buffer size: " + this.line.getBufferSize());
                System.out.println("  cycle time: " + this.cycle + "us");
            } else {
                System.out.println("  not available");
            }
        }
    }

    public int getCycleTime() {
        return this.cycle;
    }

    public void sound(boolean click, int count) {
        if (this.on.get()) {
            byte[] b = click ? this.pulse : this.quiet;
            while (count-- > 0) {
                if (this.line.available() < this.frame) continue;
                this.line.write(b, 0, this.frame);
            }
            this.line.start();
        }
    }

    public void silence() {
        this.line.stop();
        this.line.flush();
    }

    public void setVolume(int volume) {
        if (volume == 0) {
            this.on.set(false);
            this.silence();
        } else if (this.line != null) {
            volume = 255 * volume * volume / 10000;
            Arrays.fill(this.pulse, 0, this.frame / 2, (byte)volume);
            this.on.set(true);
        }
    }

    public boolean isFull() {
        return this.line.available() < this.frame;
    }
}

