/*
 * Decompiled with CFR 0.152.
 */
package elliott803.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class PlotterPaper
extends JPanel
implements Scrollable,
ComponentListener {
    private static final long serialVersionUID = 1L;
    int minY;
    int maxY;
    AffineTransform transform;
    List<Segment> segments;
    Point p1;
    Point p2;
    Rectangle r1;

    public PlotterPaper() {
        this.setBackground(Color.WHITE);
        this.addComponentListener(this);
        this.segments = Collections.synchronizedList(new ArrayList());
        this.plotClear();
    }

    public void plotDraw(int x, int y) {
        this.plotDraw(x, y, 0);
    }

    public void plotMove(int x, int y) {
        this.plotMove(x, y, 0);
    }

    public void plotDraw(int x, int y, int dir) {
        Segment lastSeg = this.segments.get(this.segments.size() - 1);
        if (lastSeg.draw && lastSeg.dir != 0 && lastSeg.dir == dir) {
            lastSeg.x = x;
            lastSeg.y = y;
            this.mapToPoint(lastSeg, false);
        } else {
            this.segments.add(this.mapToPoint(new Segment(true, x, y, dir), true));
        }
        if (y < this.minY || y > this.maxY) {
            this.minY = Math.min(y - 10, this.minY);
            this.maxY = Math.max(y + 10, this.maxY);
            this.setTransform();
            this.revalidate();
            this.repaint();
        } else {
            this.repaint(this.r1);
        }
        this.scrollRectToVisible(this.r1);
    }

    public void plotMove(int x, int y, int dir) {
        Segment lastSeg = this.segments.get(this.segments.size() - 1);
        if (!lastSeg.draw) {
            lastSeg.x = x;
            lastSeg.y = y;
            this.mapToPoint(lastSeg, false);
        } else {
            this.segments.add(this.mapToPoint(new Segment(false, x, y, dir), true));
        }
    }

    public void plotClear() {
        this.segments.clear();
        this.segments.add(new Segment(false, 0, 0, 0));
        this.p1 = new Point();
        this.p2 = new Point();
        this.r1 = new Rectangle();
        this.minY = 9999;
        this.maxY = -9999;
        this.setTransform();
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.p2.setLocation(0, 0);
        this.mapToPoint(this.segments.get(0), true);
        List<Segment> list = this.segments;
        synchronized (list) {
            int i = 1;
            while (i < this.segments.size()) {
                if (this.mapToPoint((Segment)this.segments.get((int)i), (boolean)true).draw) {
                    g.drawLine(this.p1.x, this.p1.y, this.p2.x, this.p2.y);
                }
                ++i;
            }
        }
    }

    private void setTransform() {
        double scale = (double)this.getWidth() / 1100.0;
        this.transform = new AffineTransform();
        this.transform.translate(0.0, ((double)this.getHeight() + (double)(this.maxY + this.minY) * scale) / 2.0);
        this.transform.scale(scale, -scale);
    }

    private Segment mapToPoint(Segment seg, boolean add) {
        if (add) {
            Point p = this.p2;
            this.p2 = this.p1;
            this.p1 = p;
        }
        this.p2.x = seg.x;
        this.p2.y = seg.y;
        this.transform.transform(this.p2, this.p2);
        this.r1.setBounds(this.p1.x, this.p1.y, 0, 0);
        this.r1.add(this.p2);
        this.r1.grow(1, 1);
        return seg;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), (int)((double)(this.maxY - this.minY) * this.transform.getScaleX()));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height / 10;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public void componentResized(ComponentEvent e) {
        this.setTransform();
        this.repaint();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private static class Segment {
        boolean draw;
        int x;
        int y;
        int dir;

        Segment(boolean draw, int x, int y, int dir) {
            this.draw = draw;
            this.x = x;
            this.y = y;
            this.dir = dir;
        }

        public String toString() {
            return String.valueOf(this.draw) + ": [" + this.x + "," + this.y + "] " + this.dir;
        }
    }
}

