/*
 * Decompiled with CFR 0.152.
 */
package emu.fmgen;

import emu.fmgen.Chip;
import emu.fmgen.Operator;

public class Channel4 {
    private int[] fbtable = new int[]{31, 7, 6, 5, 4, 3, 2, 1};
    private int[] kftable = new int[64];
    private boolean tablehasmade = false;
    private int[][][] pmtable = new int[2][8][256];
    private int fb;
    private int[][] buf = new int[4][1];
    private int[][] in = new int[3][];
    private int[][] out = new int[3][];
    private int[] pms;
    private int algo_;
    private Chip chip_;
    Operator[] op = new Operator[]{new Operator(), new Operator(), new Operator(), new Operator()};
    private final int[][] table1;

    Channel4() {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[6];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[5] = 2;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[6];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 2;
        nArray5[4] = 2;
        nArray5[5] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[6];
        nArray6[1] = 1;
        nArray6[3] = 1;
        nArray6[5] = 1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArray7[3] = 1;
        nArray7[4] = 2;
        nArray7[5] = 1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = 1;
        nArray8[2] = 1;
        nArray8[4] = 1;
        nArrayArray[7] = nArray8;
        this.table1 = nArrayArray;
        if (!this.tablehasmade) {
            this.MakeTable();
        }
        this.SetAlgorithm(0);
        this.pms = this.pmtable[0][0];
    }

    private void MakeTable() {
        int i = 0;
        while (i < 64) {
            this.kftable[i] = (int)(65536.0 * Math.pow(2.0, (double)i / 768.0));
            ++i;
        }
    }

    void Reset() {
        this.op[0].Reset();
        this.op[1].Reset();
        this.op[2].Reset();
        this.op[3].Reset();
    }

    int Prepare() {
        this.op[0].Prepare();
        this.op[1].Prepare();
        this.op[2].Prepare();
        this.op[3].Prepare();
        this.pms = this.pmtable[this.op[0].type_][this.op[0].ms_ & 7];
        int key = this.op[0].IsOn() != 0 | this.op[1].IsOn() != 0 | this.op[2].IsOn() != 0 | this.op[3].IsOn() != 0 ? 1 : 0;
        int lfo = (this.op[0].ms_ & (this.op[0].amon_ | this.op[1].amon_ | this.op[2].amon_ | this.op[3].amon_ ? 55 : 7)) != 0 ? 2 : 0;
        return key | lfo;
    }

    void SetFNum(int f) {
        this.op[0].SetFNum(f);
        this.op[1].SetFNum(f);
        this.op[2].SetFNum(f);
        this.op[3].SetFNum(f);
    }

    void KeyControl(int key) {
        if ((key & 1) != 0) {
            this.op[0].KeyOn();
        } else {
            this.op[0].KeyOff();
        }
        if ((key & 2) != 0) {
            this.op[1].KeyOn();
        } else {
            this.op[1].KeyOff();
        }
        if ((key & 4) != 0) {
            this.op[2].KeyOn();
        } else {
            this.op[2].KeyOff();
        }
        if ((key & 8) != 0) {
            this.op[3].KeyOn();
        } else {
            this.op[3].KeyOff();
        }
    }

    void SetAlgorithm(int algo) {
        this.in[0] = this.buf[this.table1[algo][0]];
        this.out[0] = this.buf[this.table1[algo][1]];
        this.in[1] = this.buf[this.table1[algo][2]];
        this.out[1] = this.buf[this.table1[algo][3]];
        this.in[2] = this.buf[this.table1[algo][4]];
        this.out[2] = this.buf[this.table1[algo][5]];
        this.op[0].ResetFB();
        this.algo_ = algo;
    }

    int Calc() {
        int r = 0;
        switch (this.algo_) {
            case 0: {
                this.op[2].Calc(this.op[1].Out());
                this.op[1].Calc(this.op[0].Out());
                r = this.op[3].Calc(this.op[2].Out());
                this.op[0].CalcFB(this.fb);
                break;
            }
            case 1: {
                this.op[2].Calc(this.op[0].Out() + this.op[1].Out());
                this.op[1].Calc(0);
                r = this.op[3].Calc(this.op[2].Out());
                this.op[0].CalcFB(this.fb);
                break;
            }
            case 2: {
                this.op[2].Calc(this.op[1].Out());
                this.op[1].Calc(0);
                r = this.op[3].Calc(this.op[0].Out() + this.op[2].Out());
                this.op[0].CalcFB(this.fb);
                break;
            }
            case 3: {
                this.op[2].Calc(0);
                this.op[1].Calc(this.op[0].Out());
                r = this.op[3].Calc(this.op[1].Out() + this.op[2].Out());
                this.op[0].CalcFB(this.fb);
                break;
            }
            case 4: {
                this.op[2].Calc(0);
                r = this.op[1].Calc(this.op[0].Out());
                r += this.op[3].Calc(this.op[2].Out());
                this.op[0].CalcFB(this.fb);
                break;
            }
            case 5: {
                r = this.op[2].Calc(this.op[0].Out());
                r += this.op[1].Calc(this.op[0].Out());
                r += this.op[3].Calc(this.op[0].Out());
                this.op[0].CalcFB(this.fb);
                break;
            }
            case 6: {
                r = this.op[2].Calc(0);
                r += this.op[1].Calc(this.op[0].Out());
                r += this.op[3].Calc(0);
                this.op[0].CalcFB(this.fb);
                break;
            }
            case 7: {
                r = this.op[2].Calc(0);
                r += this.op[1].Calc(0);
                r += this.op[3].Calc(0);
                r += this.op[0].CalcFB(this.fb);
            }
        }
        return r;
    }

    int CalcL() {
        this.chip_.SetPMV(this.pms[this.chip_.GetPML()]);
        int r = 0;
        switch (this.algo_) {
            case 0: {
                this.op[2].CalcL(this.op[1].Out());
                this.op[1].CalcL(this.op[0].Out());
                r = this.op[3].CalcL(this.op[2].Out());
                this.op[0].CalcFBL(this.fb);
                break;
            }
            case 1: {
                this.op[2].CalcL(this.op[0].Out() + this.op[1].Out());
                this.op[1].CalcL(0);
                r = this.op[3].CalcL(this.op[2].Out());
                this.op[0].CalcFBL(this.fb);
                break;
            }
            case 2: {
                this.op[2].CalcL(this.op[1].Out());
                this.op[1].CalcL(0);
                r = this.op[3].CalcL(this.op[0].Out() + this.op[2].Out());
                this.op[0].CalcFBL(this.fb);
                break;
            }
            case 3: {
                this.op[2].CalcL(0);
                this.op[1].CalcL(this.op[0].Out());
                r = this.op[3].CalcL(this.op[1].Out() + this.op[2].Out());
                this.op[0].CalcFBL(this.fb);
                break;
            }
            case 4: {
                this.op[2].CalcL(0);
                r = this.op[1].CalcL(this.op[0].Out());
                r += this.op[3].CalcL(this.op[2].Out());
                this.op[0].CalcFBL(this.fb);
                break;
            }
            case 5: {
                r = this.op[2].CalcL(this.op[0].Out());
                r += this.op[1].CalcL(this.op[0].Out());
                r += this.op[3].CalcL(this.op[0].Out());
                this.op[0].CalcFBL(this.fb);
                break;
            }
            case 6: {
                r = this.op[2].CalcL(0);
                r += this.op[1].CalcL(this.op[0].Out());
                r += this.op[3].CalcL(0);
                this.op[0].CalcFBL(this.fb);
                break;
            }
            case 7: {
                r = this.op[2].CalcL(0);
                r += this.op[1].CalcL(0);
                r += this.op[3].CalcL(0);
                r += this.op[0].CalcFBL(this.fb);
            }
        }
        return r;
    }

    int CalcN(int noise) {
        this.buf[3][0] = 0;
        this.buf[2][0] = 0;
        this.buf[1][0] = 0;
        this.buf[0][0] = this.op[0].out_;
        this.op[0].CalcFB(this.fb);
        int[] nArray = this.out[0];
        nArray[0] = nArray[0] + this.op[1].Calc(this.in[0][0]);
        int[] nArray2 = this.out[1];
        nArray2[0] = nArray2[0] + this.op[2].Calc(this.in[1][0]);
        int o = this.op[3].out_;
        this.op[3].CalcN(noise);
        return this.out[2][0] + o;
    }

    int CalcLN(int noise) {
        this.chip_.SetPMV(this.pms[this.chip_.GetPML()]);
        this.buf[3][0] = 0;
        this.buf[2][0] = 0;
        this.buf[1][0] = 0;
        this.buf[0][0] = this.op[0].out_;
        this.op[0].CalcFBL(this.fb);
        int[] nArray = this.out[0];
        nArray[0] = nArray[0] + this.op[1].CalcL(this.in[0][0]);
        int[] nArray2 = this.out[1];
        nArray2[0] = nArray2[0] + this.op[2].CalcL(this.in[1][0]);
        int o = this.op[3].out_;
        this.op[3].CalcN(noise);
        return this.out[2][0] + o;
    }

    void SetType(int type) {
        int i = 0;
        while (i < 4) {
            this.op[i].type_ = type;
            ++i;
        }
    }

    void SetFB(int feedback) {
        this.fb = this.fbtable[feedback];
    }

    void SetMS(int ms) {
        this.op[0].SetMS(ms);
        this.op[1].SetMS(ms);
        this.op[2].SetMS(ms);
        this.op[3].SetMS(ms);
    }

    void Mute(boolean m) {
        int i = 0;
        while (i < 4) {
            this.op[i].Mute(m);
            ++i;
        }
    }

    void Refresh() {
        int i = 0;
        while (i < 4) {
            this.op[i].param_changed_ = true;
            ++i;
        }
    }

    void SetChip(Chip chip) {
        this.chip_ = chip;
        int i = 0;
        while (i < 4) {
            this.op[i].SetChip(chip);
            ++i;
        }
    }
}

