/*
 * Decompiled with CFR 0.152.
 */
package emu.fmgen;

public class Chip {
    private int ratio_;
    private int aml_;
    private int pml_;
    private int pmv_;
    private int[][] multable_ = new int[4][16];

    Chip() {
    }

    void SetRatio(int ratio) {
        if (this.ratio_ != ratio) {
            this.ratio_ = ratio;
            this.MakeTable();
        }
    }

    private void MakeTable() {
        float[] dt2lv = new float[]{1.0f, 1.414f, 1.581f, 1.732f};
        int h = 0;
        while (h < 4) {
            double rr = (double)dt2lv[h] * (double)this.ratio_ / 1.0;
            int l = 0;
            while (l < 16) {
                int mul = l != 0 ? l * 2 : 1;
                this.multable_[h][l] = (int)((double)mul * rr);
                ++l;
            }
            ++h;
        }
    }

    void SetAML(int l) {
        this.aml_ = l & 0xFF;
    }

    void SetPML(int l) {
        this.pml_ = l & 0xFF;
    }

    void SetPMV(int pmv) {
        this.pmv_ = pmv;
    }

    int GetMulValue(int dt2, int mul) {
        return this.multable_[dt2][mul];
    }

    int GetAML() {
        return this.aml_;
    }

    int GetPML() {
        return this.pml_;
    }

    int GetPMV() {
        return this.pmv_;
    }

    int GetRatio() {
        return this.ratio_;
    }
}

