/*
 * Decompiled with CFR 0.152.
 */
package emu.fmgen;

public class PSG {
    static final int noisetablesize = 2048;
    static final int toneshift = 24;
    static final int envshift = 22;
    static final int noiseshift = 14;
    static final int oversampling = 2;
    private int[] reg = new int[16];
    private int[] envelop;
    private int[][] olevel = new int[3][1];
    private int[] scount = new int[3];
    private int[] speriod = new int[3];
    private int ecount;
    private int eperiod;
    private int ncount;
    private int nperiod;
    private int tperiodbase;
    private int eperiodbase;
    private int nperiodbase;
    private int mask;
    private int[][] enveloptable = new int[16][64];
    private int[] noisetable = new int[2048];
    private int[] EmitTable = new int[32];
    private int rcnt;
    private int[][] rbuf = new int[3][512];
    private final int[] table1;
    private final int[] table2;
    private final int[] table3;

    PSG() {
        int[] nArray = new int[32];
        nArray[0] = 2;
        nArray[2] = 2;
        nArray[4] = 2;
        nArray[6] = 2;
        nArray[8] = 1;
        nArray[10] = 1;
        nArray[12] = 1;
        nArray[14] = 1;
        nArray[16] = 2;
        nArray[17] = 2;
        nArray[18] = 2;
        nArray[20] = 2;
        nArray[21] = 1;
        nArray[22] = 2;
        nArray[23] = 3;
        nArray[24] = 1;
        nArray[25] = 1;
        nArray[26] = 1;
        nArray[27] = 3;
        nArray[28] = 1;
        nArray[29] = 2;
        nArray[30] = 1;
        this.table1 = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 31;
        nArray2[3] = 31;
        this.table2 = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = -1;
        this.table3 = nArray3;
        this.SetVolume(0);
        this.MakeNoiseTable();
        this.Reset();
        this.mask = 63;
    }

    void Reset() {
        int i = 0;
        while (i < 14) {
            this.SetReg(i, 0);
            ++i;
        }
        this.SetReg(7, 255);
        this.SetReg(14, 255);
        this.SetReg(15, 255);
    }

    void SetClock(int clock, int rate) {
        this.tperiodbase = (int)(4194304.0 * (double)clock / (double)rate);
        this.eperiodbase = (int)(1048576.0 * (double)clock / (double)rate);
        this.nperiodbase = (int)(4096.0 * (double)clock / (double)rate);
        int tmp = this.reg[0] + this.reg[1] * 256 & 0xFFF;
        this.speriod[0] = tmp != 0 ? this.tperiodbase / tmp : this.tperiodbase;
        tmp = this.reg[2] + this.reg[3] * 256 & 0xFFF;
        this.speriod[1] = tmp != 0 ? this.tperiodbase / tmp : this.tperiodbase;
        tmp = this.reg[4] + this.reg[5] * 256 & 0xFFF;
        this.speriod[2] = tmp != 0 ? this.tperiodbase / tmp : this.tperiodbase;
        tmp = this.reg[6] & 0x1F;
        this.nperiod = tmp != 0 ? this.nperiodbase / tmp / 2 : this.nperiodbase / 2;
        tmp = this.reg[11] + this.reg[12] * 256 & 0xFFFF;
        this.eperiod = tmp != 0 ? this.eperiodbase / tmp : this.eperiodbase * 2;
    }

    private void MakeNoiseTable() {
        if (this.noisetable[0] == 0) {
            int noise = 14321;
            int i = 0;
            while (i < 2048) {
                int n = 0;
                int j = 0;
                while (j < 32) {
                    n = n * 2 + (noise & 1);
                    noise = noise >> 1 | (noise << 14 ^ noise << 16) & 0x10000;
                    ++j;
                }
                this.noisetable[i] = n;
                ++i;
            }
        }
    }

    void SetVolume(int volume) {
        double base = 5461.333333333333 * Math.pow(10.0, (double)volume / 40.0);
        int i = 31;
        while (i >= 2) {
            this.EmitTable[i] = (int)base;
            base /= 1.189207115;
            --i;
        }
        this.EmitTable[1] = 0;
        this.EmitTable[0] = 0;
        this.MakeEnvelopTable();
        this.SetChannelMask(~this.mask);
    }

    void SetChannelMask(int c) {
        this.mask = ~c;
        int i = 0;
        while (i < 3) {
            this.olevel[i][0] = (this.mask & 1 << i) != 0 ? this.EmitTable[(this.reg[8 + i] & 0xF) * 2 + 1] : 0;
            ++i;
        }
    }

    private void MakeEnvelopTable() {
        int ptr = 0;
        int i = 0;
        while (i < 32) {
            int v = this.table2[this.table1[i]];
            int j = 0;
            while (j < 32) {
                this.enveloptable[ptr / 64][ptr % 64] = this.EmitTable[v];
                v += this.table3[this.table1[i]];
                ++ptr;
                ++j;
            }
            ++i;
        }
    }

    void SetReg(int regnum, int data) {
        if (regnum < 16) {
            this.reg[regnum] = data;
            switch (regnum) {
                case 0: 
                case 1: {
                    int tmp = this.reg[0] + this.reg[1] * 256 & 0xFFF;
                    this.speriod[0] = tmp != 0 ? this.tperiodbase / tmp : this.tperiodbase;
                    break;
                }
                case 2: 
                case 3: {
                    int tmp = this.reg[2] + this.reg[3] * 256 & 0xFFF;
                    this.speriod[1] = tmp != 0 ? this.tperiodbase / tmp : this.tperiodbase;
                    break;
                }
                case 4: 
                case 5: {
                    int tmp = this.reg[4] + this.reg[5] * 256 & 0xFFF;
                    this.speriod[2] = tmp != 0 ? this.tperiodbase / tmp : this.tperiodbase;
                    break;
                }
                case 6: {
                    this.nperiod = (data &= 0x1F) != 0 ? this.nperiodbase / data : this.nperiodbase;
                    break;
                }
                case 8: {
                    this.olevel[0][0] = (this.mask & 1) != 0 ? this.EmitTable[(data & 0xF) * 2 + 1] : 0;
                    break;
                }
                case 9: {
                    this.olevel[1][0] = (this.mask & 2) != 0 ? this.EmitTable[(data & 0xF) * 2 + 1] : 0;
                    break;
                }
                case 10: {
                    this.olevel[2][0] = (this.mask & 4) != 0 ? this.EmitTable[(data & 0xF) * 2 + 1] : 0;
                    break;
                }
                case 11: 
                case 12: {
                    int tmp = this.reg[11] + this.reg[12] * 256 & 0xFFFF;
                    this.eperiod = tmp != 0 ? this.eperiodbase / tmp : this.eperiodbase * 2;
                    break;
                }
                case 13: {
                    this.ecount = 0;
                    this.envelop = this.enveloptable[data & 0xF];
                }
            }
        }
    }

    int GetReg(int regnum) {
        return this.reg[regnum & 0xF];
    }

    private void StoreSample(int[] dest, int didx, int data) {
        int value = dest[didx] + data;
        dest[didx] = value > Short.MAX_VALUE ? Short.MAX_VALUE : (value < Short.MIN_VALUE ? Short.MIN_VALUE : value);
    }

    private int SCOUNT(int ch) {
        return this.scount[ch] >>> 26;
    }

    void Mix(int[] dest, int nsamples) {
        int[] chenable = new int[3];
        int[] nenable = new int[3];
        int r7 = ~this.reg[7];
        int didx = 0;
        if ((r7 & 0x3F | (this.reg[8] | this.reg[9] | this.reg[10]) & 0x1F) != 0) {
            int[] p3;
            chenable[0] = (r7 & 1) != 0 && this.speriod[0] <= 0x1000000 ? 1 : 0;
            chenable[1] = (r7 & 2) != 0 && this.speriod[1] <= 0x1000000 ? 1 : 0;
            chenable[2] = (r7 & 4) != 0 && this.speriod[2] <= 0x1000000 ? 1 : 0;
            nenable[0] = r7 >> 3 & 1;
            nenable[1] = r7 >> 4 & 1;
            nenable[2] = r7 >> 5 & 1;
            int[] env = new int[1];
            int[] p1 = (this.mask & 1) != 0 && (this.reg[8] & 0x10) != 0 ? env : this.olevel[0];
            int[] p2 = (this.mask & 2) != 0 && (this.reg[9] & 0x10) != 0 ? env : this.olevel[1];
            int[] nArray = p3 = (this.mask & 4) != 0 && (this.reg[10] & 0x10) != 0 ? env : this.olevel[2];
            if (p1 != env && p2 != env && p3 != env) {
                if ((r7 & 0x38) == 0) {
                    int i = 0;
                    while (i < nsamples) {
                        this.rcnt = this.rcnt + 1 & 0x1FF;
                        this.rbuf[0][this.rcnt] = p1[0];
                        this.rbuf[1][this.rcnt] = p2[0];
                        this.rbuf[2][this.rcnt] = p3[0];
                        int sample = 0;
                        int j = 0;
                        while (j < 4) {
                            int x = (this.SCOUNT(0) & chenable[0]) - 1;
                            sample += this.olevel[0][0] + x ^ x;
                            this.scount[0] = this.scount[0] + this.speriod[0];
                            int y = (this.SCOUNT(1) & chenable[1]) - 1;
                            sample += this.olevel[1][0] + y ^ y;
                            this.scount[1] = this.scount[1] + this.speriod[1];
                            int z = (this.SCOUNT(2) & chenable[2]) - 1;
                            sample += this.olevel[2][0] + z ^ z;
                            this.scount[2] = this.scount[2] + this.speriod[2];
                            ++j;
                        }
                        this.StoreSample(dest, didx, sample /= 4);
                        ++didx;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < nsamples) {
                        this.rcnt = this.rcnt + 1 & 0x1FF;
                        this.rbuf[0][this.rcnt] = p1[0];
                        this.rbuf[1][this.rcnt] = p2[0];
                        this.rbuf[2][this.rcnt] = p3[0];
                        int sample = 0;
                        int j = 0;
                        while (j < 4) {
                            int noise = this.noisetable[this.ncount >> 22 & 0x7FF] >> (this.ncount >> 17);
                            this.ncount += this.nperiod;
                            int x = (this.SCOUNT(0) & chenable[0] | nenable[0] & noise) - 1;
                            sample += this.olevel[0][0] + x ^ x;
                            this.scount[0] = this.scount[0] + this.speriod[0];
                            int y = (this.SCOUNT(1) & chenable[1] | nenable[1] & noise) - 1;
                            sample += this.olevel[1][0] + y ^ y;
                            this.scount[1] = this.scount[1] + this.speriod[1];
                            int z = (this.SCOUNT(2) & chenable[2] | nenable[2] & noise) - 1;
                            sample += this.olevel[2][0] + z ^ z;
                            this.scount[2] = this.scount[2] + this.speriod[2];
                            ++j;
                        }
                        this.StoreSample(dest, didx, sample /= 4);
                        ++didx;
                        ++i;
                    }
                }
                this.ecount = (this.ecount >> 8) + (this.eperiod >> 6) * nsamples;
                if (this.ecount >= 0x400000) {
                    if ((this.reg[13] & 0xB) != 10) {
                        this.ecount |= 0x200000;
                    }
                    this.ecount &= 0x3FFFFF;
                }
                this.ecount <<= 8;
            } else {
                int i = 0;
                while (i < nsamples) {
                    int sample = 0;
                    int j = 0;
                    while (j < 4) {
                        env[0] = this.envelop[this.ecount >> 24];
                        this.ecount += this.eperiod;
                        if (this.ecount >= 0x40000000) {
                            if ((this.reg[13] & 0xB) != 10) {
                                this.ecount |= 0x20000000;
                            }
                            this.ecount &= 0x3FFFFFFF;
                        }
                        int noise = this.noisetable[this.ncount >> 22 & 0x7FF] >> (this.ncount >> 17);
                        this.ncount += this.nperiod;
                        int x = (this.SCOUNT(0) & chenable[0] | nenable[0] & noise) - 1;
                        sample += p1[0] + x ^ x;
                        this.scount[0] = this.scount[0] + this.speriod[0];
                        int y = (this.SCOUNT(1) & chenable[1] | nenable[1] & noise) - 1;
                        sample += p2[0] + y ^ y;
                        this.scount[1] = this.scount[1] + this.speriod[1];
                        int z = (this.SCOUNT(2) & chenable[2] | nenable[2] & noise) - 1;
                        sample += p3[0] + z ^ z;
                        this.scount[2] = this.scount[2] + this.speriod[2];
                        ++j;
                    }
                    this.rcnt = this.rcnt + 1 & 0x1FF;
                    this.rbuf[0][this.rcnt] = p1[0];
                    this.rbuf[1][this.rcnt] = p2[0];
                    this.rbuf[2][this.rcnt] = p3[0];
                    this.StoreSample(dest, didx, sample /= 4);
                    ++didx;
                    ++i;
                }
            }
        }
    }

    void Mix2(int[] dest, int nsamples, int vol_l, int vol_r) {
        int[] chenable = new int[3];
        int[] nenable = new int[3];
        int r7 = ~this.reg[7];
        int didx = 0;
        if ((r7 & 0x3F | (this.reg[8] | this.reg[9] | this.reg[10]) & 0x1F) != 0) {
            int[] p3;
            chenable[0] = (r7 & 1) != 0 && this.speriod[0] <= 0x1000000 ? 1 : 0;
            chenable[1] = (r7 & 2) != 0 && this.speriod[1] <= 0x1000000 ? 1 : 0;
            chenable[2] = (r7 & 4) != 0 && this.speriod[2] <= 0x1000000 ? 1 : 0;
            nenable[0] = r7 >> 3 & 1;
            nenable[1] = r7 >> 4 & 1;
            nenable[2] = r7 >> 5 & 1;
            int[] env = new int[1];
            int[] p1 = (this.mask & 1) != 0 && (this.reg[8] & 0x10) != 0 ? env : this.olevel[0];
            int[] p2 = (this.mask & 2) != 0 && (this.reg[9] & 0x10) != 0 ? env : this.olevel[1];
            int[] nArray = p3 = (this.mask & 4) != 0 && (this.reg[10] & 0x10) != 0 ? env : this.olevel[2];
            if (p1 != env && p2 != env && p3 != env) {
                if ((r7 & 0x38) == 0) {
                    int i = 0;
                    while (i < nsamples) {
                        this.rcnt = this.rcnt + 1 & 0x1FF;
                        this.rbuf[0][this.rcnt] = p1[0];
                        this.rbuf[1][this.rcnt] = p2[0];
                        this.rbuf[2][this.rcnt] = p3[0];
                        int sample = 0;
                        int j = 0;
                        while (j < 4) {
                            int x = (this.SCOUNT(0) & chenable[0]) - 1;
                            sample += this.olevel[0][0] + x ^ x;
                            this.scount[0] = this.scount[0] + this.speriod[0];
                            int y = (this.SCOUNT(1) & chenable[1]) - 1;
                            sample += this.olevel[1][0] + y ^ y;
                            this.scount[1] = this.scount[1] + this.speriod[1];
                            int z = (this.SCOUNT(2) & chenable[2]) - 1;
                            sample += this.olevel[2][0] + z ^ z;
                            this.scount[2] = this.scount[2] + this.speriod[2];
                            ++j;
                        }
                        this.StoreSample(dest, didx, (sample /= 4) * vol_l >> 4);
                        this.StoreSample(dest, didx + 1, sample * vol_r >> 4);
                        didx += 2;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < nsamples) {
                        this.rcnt = this.rcnt + 1 & 0x1FF;
                        this.rbuf[0][this.rcnt] = p1[0];
                        this.rbuf[1][this.rcnt] = p2[0];
                        this.rbuf[2][this.rcnt] = p3[0];
                        int sample = 0;
                        int j = 0;
                        while (j < 4) {
                            int noise = this.noisetable[this.ncount >> 22 & 0x7FF] >> (this.ncount >> 17);
                            this.ncount += this.nperiod;
                            int x = (this.SCOUNT(0) & chenable[0] | nenable[0] & noise) - 1;
                            sample += this.olevel[0][0] + x ^ x;
                            this.scount[0] = this.scount[0] + this.speriod[0];
                            int y = (this.SCOUNT(1) & chenable[1] | nenable[1] & noise) - 1;
                            sample += this.olevel[1][0] + y ^ y;
                            this.scount[1] = this.scount[1] + this.speriod[1];
                            int z = (this.SCOUNT(2) & chenable[2] | nenable[2] & noise) - 1;
                            sample += this.olevel[2][0] + z ^ z;
                            this.scount[2] = this.scount[2] + this.speriod[2];
                            ++j;
                        }
                        this.StoreSample(dest, didx, (sample /= 4) * vol_l >> 4);
                        this.StoreSample(dest, didx + 1, sample * vol_r >> 4);
                        didx += 2;
                        ++i;
                    }
                }
                this.ecount = (this.ecount >> 8) + (this.eperiod >> 6) * nsamples;
                if (this.ecount >= 0x400000) {
                    if ((this.reg[13] & 0xB) != 10) {
                        this.ecount |= 0x200000;
                    }
                    this.ecount &= 0x3FFFFF;
                }
                this.ecount <<= 8;
            } else {
                int i = 0;
                while (i < nsamples) {
                    int sample = 0;
                    int j = 0;
                    while (j < 4) {
                        env[0] = this.envelop[this.ecount >> 24];
                        this.ecount += this.eperiod;
                        if (this.ecount >= 0x40000000) {
                            if ((this.reg[13] & 0xB) != 10) {
                                this.ecount |= 0x20000000;
                            }
                            this.ecount &= 0x3FFFFFFF;
                        }
                        int noise = this.noisetable[this.ncount >> 22 & 0x7FF] >> (this.ncount >> 17);
                        this.ncount += this.nperiod;
                        int x = (this.SCOUNT(0) & chenable[0] | nenable[0] & noise) - 1;
                        sample += p1[0] + x ^ x;
                        this.scount[0] = this.scount[0] + this.speriod[0];
                        int y = (this.SCOUNT(1) & chenable[1] | nenable[1] & noise) - 1;
                        sample += p2[0] + y ^ y;
                        this.scount[1] = this.scount[1] + this.speriod[1];
                        int z = (this.SCOUNT(2) & chenable[2] | nenable[2] & noise) - 1;
                        sample += p3[0] + z ^ z;
                        this.scount[2] = this.scount[2] + this.speriod[2];
                        ++j;
                    }
                    this.rcnt = this.rcnt + 1 & 0x1FF;
                    this.rbuf[0][this.rcnt] = p1[0];
                    this.rbuf[1][this.rcnt] = p2[0];
                    this.rbuf[2][this.rcnt] = p3[0];
                    this.StoreSample(dest, didx, (sample /= 4) * vol_l >> 4);
                    this.StoreSample(dest, didx + 1, sample * vol_r >> 4);
                    didx += 2;
                    ++i;
                }
            }
        }
    }

    public int[] rbuf(int ch) {
        return this.rbuf[ch];
    }
}

