/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.Sys_main;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class Sys_lpr {
    public boolean use_os_font;
    public boolean output_kanji;
    private static final int TABSTOP = 8;
    private static final int N_CHAR_FONTS = 256;
    private static final int TWIPS_PER_INCH = 1440;
    private static final double MM_PER_INCH = 25.4;
    private static final int PT_PER_INCH = 72;
    private static final int DEF_LP_UNIT = 72;
    private static final int DEF_IPLPU = 12;
    private static final int DEF_CPI = 10;
    private static final int DEF_LPI = 6;
    private static final int DEF_AREA_WIDTH = 8;
    private static final int DEF_AREA_HEIGHT = 11;
    private static final double DEF_MARGIN_LEFT_MM = 3.4;
    private static final double DEF_MARGIN_TOP_MM = 11.7;
    private static final double DEF_MARGIN_BOTTOM_MM = 5.9;
    private static final int DEF_NUM_COLUMNS = 80;
    private byte[][] CharFontImg;
    private Sys_main sysmain;
    private emu.xm7.vm.System vm;
    private String szFullPathName;
    private RandomAccessFile hFile;

    public static int ROUND(double val) {
        return (int)(val + 0.5);
    }

    public static int TRUNC(double val) {
        return (int)val;
    }

    public static void PRINT_ERROR(String funcname) {
        System.err.println(funcname);
    }

    public static void PRINT_ERROR(Frame frame, String funcname) {
        System.err.println(funcname);
    }

    public static void PRINT_ERROR(Frame frame, String funcname, String msg) {
        System.err.println(String.valueOf(funcname) + ": " + msg);
    }

    private static void errorDialog(Frame frame, String msg1, String msg2) {
        final JDialog dlg = new JDialog(frame, "XM7LP ERROR", true);
        JLabel mes1 = new JLabel(msg1);
        JLabel mes2 = new JLabel(msg2);
        Button close = new Button("CLOSE");
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)mes1, "North");
        dlg.getContentPane().add((Component)mes2, "Center");
        dlg.getContentPane().add((Component)close, "South");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
            }
        });
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                dlg.setVisible(false);
            }
        });
        dlg.pack();
        Dimension d = frame.getSize();
        dlg.setLocation((d.width - dlg.getWidth()) / 2, (d.height - dlg.getHeight()) / 2);
        dlg.setVisible(true);
    }

    private int INCHES2TWIPS(int numer, int denom) {
        return Sys_lpr.ROUND(1440.0 * (double)numer / (double)denom);
    }

    private int POINTS2TWIPS(double pt) {
        return Sys_lpr.ROUND(1440.0 * pt / 72.0);
    }

    Sys_lpr(Sys_main sysmain, emu.xm7.vm.System vm) {
        this.sysmain = sysmain;
        this.vm = vm;
        this.szFullPathName = null;
        this.hFile = null;
    }

    private boolean rewind_file() {
        try {
            this.hFile.seek(0L);
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.rewind_file()", e.getMessage());
            return false;
        }
        return true;
    }

    private boolean trunc_file() {
        try {
            this.hFile.setLength(0L);
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.trunc_file()", e.getMessage());
            return false;
        }
        return true;
    }

    private boolean load_font_image() {
        RandomAccessFile fp;
        try {
            fp = new RandomAccessFile("SUBSYS_C.ROM", "r");
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "load_font_image.new File()", e.getMessage());
            return false;
        }
        int i = 0;
        while (i < 256) {
            int data;
            try {
                data = fp.read(this.CharFontImg[i], 0, 8);
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "load_font_image.read()", e.getMessage());
                try {
                    fp.close();
                }
                catch (Exception e1) {
                    Sys_lpr.PRINT_ERROR(this.sysmain, "load_font_image.close()", e1.getMessage());
                }
                fp = null;
                return false;
            }
            if (data == -1) break;
            ++i;
        }
        try {
            fp.close();
        }
        catch (Exception e1) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "load_font_image.close()", e1.getMessage());
        }
        fp = null;
        return true;
    }

    private boolean init() {
        this.use_os_font = false;
        this.output_kanji = false;
        this.CharFontImg = new byte[256][8];
        return this.load_font_image();
    }

    public boolean printfile() {
        System.out.println("Sys_lpr.printfile() --- begin");
        PrinterJob pj = PrinterJob.getPrinterJob();
        lprRenderer renderer = new lprRenderer(this.sysmain, this.hFile);
        pj.setPrintable(renderer);
        if (!pj.printDialog()) {
            return false;
        }
        if (!this.rewind_file()) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.rewind_file() aborted.");
            return false;
        }
        try {
            pj.print();
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "PrinterJob.print()", e.getMessage());
            return false;
        }
        if (!this.trunc_file()) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.trunc_file() aborted.");
            return false;
        }
        System.out.println("Sys_lpr.printfile() --- end");
        return true;
    }

    public RandomAccessFile openfile(String fname) {
        this.szFullPathName = String.valueOf(fname) + ".tmp";
        try {
            this.hFile = new RandomAccessFile(this.szFullPathName, "rw");
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.openfile()", e.getMessage());
            return null;
        }
        try {
            this.hFile.setLength(0L);
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.openfile()", e.getMessage());
            try {
                this.hFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        if (!this.init()) {
            return null;
        }
        return this.hFile;
    }

    public void closefile() {
        try {
            this.hFile.close();
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.closefile()", e.getMessage());
        }
        this.hFile = null;
    }

    public boolean writefile(int dat) {
        try {
            this.hFile.write(dat);
        }
        catch (Exception e) {
            Sys_lpr.PRINT_ERROR(this.sysmain, "Sys_lpr.writefile()", e.getMessage());
            return false;
        }
        return true;
    }

    public void removefile() {
        File file = new File(this.szFullPathName);
        file.delete();
        this.szFullPathName = null;
    }

    private class LprFonts {
        static final double PT_FONT = 9.0;
        static final double PT_FONT_KANJI = 9.0;
        static final int FONT_ANK_NORMAL = 0;
        static final int N_NUM_ANKFONT = 1;
        static final int FONT_ANK_PREV = 1;
        static final int FONT_KANJI_NORMAL = 0;
        static final int N_NUM_KANJIFONT = 1;
        static final int ATTR_WIDE_CHAR = 1;
        static final int ATTR_KANJI = Integer.MIN_VALUE;
        private Font[] hFontAnk = new Font[2];
        private Font[] hFontKanji = new Font[1];
        private double currentAlpha;

        LprFonts() {
        }

        boolean create(Graphics2D g2d, Dimension sizeChar) {
            Font hf;
            this.hFontAnk[1] = g2d.getFont();
            this.hFontAnk[0] = hf = new Font("Monospaced", 0, Sys_lpr.this.POINTS2TWIPS(9.0));
            sizeChar.setSize(Sys_lpr.this.INCHES2TWIPS(1, 10), Sys_lpr.this.POINTS2TWIPS(9.0));
            this.hFontKanji[0] = hf = new Font("Monospaced", 0, Sys_lpr.this.POINTS2TWIPS(9.0));
            return true;
        }

        boolean select_ank(Graphics2D g2d, int index) {
            g2d.setFont(this.hFontAnk[index]);
            return true;
        }

        boolean select_kanji(Graphics2D g2d, int index) {
            g2d.setFont(this.hFontKanji[index]);
            return true;
        }

        boolean delete_f(Graphics2D g2d) {
            return true;
        }
    }

    private class LprPrintBuffer {
        static final int N_MAX_PRT_BUF_LEN = 256;
        private PrtBuffChar[] prtBuff = new PrtBuffChar[256];
        private int numColumns;
        private int numCurrentChars;
        private int idxNextRead;

        LprPrintBuffer() {
            int i = 0;
            while (i < 256) {
                this.prtBuff[i] = new PrtBuffChar();
                ++i;
            }
        }

        public void Clear(int i) {
            this.prtBuff[i].code = 0;
            this.prtBuff[i].attr = 0;
        }

        void ClearAll() {
            int i = 0;
            while (i < 256) {
                this.Clear(i);
                ++i;
            }
            this.numCurrentChars = 0;
            this.idxNextRead = 0;
        }

        boolean IsEmpty() {
            return this.numCurrentChars == 0;
        }

        boolean IsFull() {
            return this.numCurrentChars >= this.numColumns;
        }

        boolean IsReadable() {
            return this.idxNextRead < this.numCurrentChars;
        }

        void Add(int code, int attr) {
            assert (this.numCurrentChars >= 0 && this.numCurrentChars < 256);
            assert (code >= 32 && code <= 126 || code >= 128 && code <= 255);
            this.prtBuff[this.numCurrentChars].code = code;
            this.prtBuff[this.numCurrentChars].attr = attr;
            ++this.numCurrentChars;
        }

        boolean DeleteLastChar() {
            assert (this.numCurrentChars >= 0 && this.numCurrentChars <= 256);
            if (this.numCurrentChars > 0) {
                --this.numCurrentChars;
                this.Clear(this.numCurrentChars);
                return true;
            }
            return false;
        }

        PrtBuffChar Get() {
            if (this.idxNextRead >= this.numCurrentChars) {
                return null;
            }
            PrtBuffChar buffChar = new PrtBuffChar();
            buffChar.code = this.prtBuff[this.idxNextRead].code;
            buffChar.attr = this.prtBuff[this.idxNextRead].attr;
            ++this.idxNextRead;
            return buffChar;
        }

        void setNumColumns(int num) {
            this.numColumns = num;
        }

        int getNumColumns() {
            return this.numColumns;
        }

        int getNumCurrentChars() {
            return this.numCurrentChars;
        }
    }

    private class PrtBuffChar {
        int code;
        int attr;

        PrtBuffChar() {
        }
    }

    private class lprRenderer
    implements Printable {
        private Sys_main sysmain;
        private static final double FONT_PT = 10.0;
        private static final double PPI = 72.0;
        private static final double DEF_VPLI72 = 12.0;
        private RandomAccessFile hFile;
        private boolean bEofDetected;
        private long lastFilePointer;
        private int lastPageIndex;
        private int x;
        private int y;
        private Dimension sizeArea;
        private Dimension sizePrintable;
        private Dimension sizeChar;
        private Dimension sizeSpacing;
        private int nMarginTop;
        private int nMarginBottom;
        private int lp_unit;
        private int cpi;
        private int lpi;
        private int fKanji;
        private boolean bWideChar;
        private boolean gotoNextPage;
        private LprPrintBuffer prtBuff;
        private LprFonts fonts;

        public lprRenderer(Sys_main sysmain, RandomAccessFile hf) {
            this.sysmain = sysmain;
            this.hFile = hf;
            this.sizeArea = new Dimension();
            this.sizePrintable = new Dimension();
            this.sizeChar = new Dimension();
            this.sizeSpacing = new Dimension();
            this.bEofDetected = false;
            this.lastFilePointer = -1L;
            this.lastPageIndex = -1;
            this.prtBuff = new LprPrintBuffer();
            this.fonts = new LprFonts();
        }

        private boolean contert_to_twips_coordinates(Graphics2D g2d) {
            AffineTransform aft = new AffineTransform();
            aft.scale(0.05, 0.05);
            g2d.transform(aft);
            return true;
        }

        private boolean set_printable_area(Graphics2D g2d, PageFormat pf) {
            Dimension sz_d = new Dimension();
            Dimension sz_dm = new Dimension();
            Dimension sz_dp = new Dimension();
            Dimension sz_lm = new Dimension();
            sz_d.setSize(Sys_lpr.this.POINTS2TWIPS(pf.getWidth()), Sys_lpr.this.POINTS2TWIPS(pf.getHeight()));
            sz_dm.setSize(Sys_lpr.this.POINTS2TWIPS(pf.getImageableX()), Sys_lpr.this.POINTS2TWIPS(pf.getImageableY()));
            sz_dp.setSize(Sys_lpr.this.POINTS2TWIPS(pf.getImageableWidth()), Sys_lpr.this.POINTS2TWIPS(pf.getImageableHeight()));
            this.sizeArea.setSize(11520, 15840);
            sz_lm.setSize(Sys_lpr.TRUNC(192.75590551181102), Sys_lpr.TRUNC(663.3070866141733));
            this.nMarginTop = sz_lm.height;
            g2d.translate(sz_lm.width, sz_lm.height);
            if (this.sizeArea.width > sz_dp.width) {
                this.sizeArea.width = sz_dp.width;
            }
            if (this.sizeArea.height > sz_dp.height) {
                this.sizeArea.height = sz_dp.height;
            }
            this.nMarginBottom = sz_d.height - this.sizeArea.height - this.nMarginTop;
            return true;
        }

        private boolean reset_params(Graphics2D g2d) {
            this.Kanji_Clear();
            this.x = 0;
            this.y = 0;
            this.sizePrintable = this.sizeArea;
            this.lp_unit = 72;
            this.cpi = 10;
            this.lpi = 6;
            this.sizeSpacing.setSize(Sys_lpr.this.INCHES2TWIPS(1, this.cpi), Sys_lpr.this.INCHES2TWIPS(1, this.lpi));
            this.gotoNextPage = false;
            this.prtBuff.setNumColumns(80);
            this.prtBuff.ClearAll();
            if (!this.fonts.select_ank(g2d, 0)) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "lprRenderer.reset_params.select_ank() FAILED!!");
                return false;
            }
            return true;
        }

        private boolean draw_one_dot(Graphics2D g2d, int left, int top) {
            g2d.fillOval(left, top, Sys_lpr.this.INCHES2TWIPS(1, 60), Sys_lpr.this.INCHES2TWIPS(1, 72));
            return true;
        }

        private boolean draw_one_char_image(Graphics2D g2d, int code) {
            int index = code;
            assert (index < 256);
            int i = 0;
            while (i < 8) {
                int j = 0;
                while (j < 8) {
                    int top;
                    int left;
                    if ((Sys_lpr.this.CharFontImg[index][i] & 1 << 7 - j) != 0 && !this.draw_one_dot(g2d, left = this.x + (j * this.sizeChar.width >> 3), top = this.y + (i * this.sizeChar.height >> 3))) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }

        private boolean draw_one_char_text(Graphics2D g2d, int data) {
            char tch = (char)data;
            LineMetrics lm = g2d.getFont().getLineMetrics(Character.toString(tch), g2d.getFontRenderContext());
            int bl = Sys_lpr.ROUND(lm.getHeight() / 2.0f);
            try {
                g2d.drawString(Character.toString(tch), this.x, this.y + bl);
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "lprRenderer.draw_one_char_text.drawString()", e.getMessage());
                return false;
            }
            return true;
        }

        private boolean draw_one_char_katakana_text(Graphics2D g2d, int data) {
            String csName = "SJIS";
            if (!Charset.isSupported(csName)) {
                System.err.println("Charset " + csName + " is not supported.");
                return false;
            }
            Charset cs = Charset.forName(csName);
            ByteBuffer bb = null;
            CharBuffer cb = null;
            byte[] b2 = new byte[]{(byte)data, 0};
            bb = ByteBuffer.wrap(b2, 0, 1);
            cb = cs.decode(bb);
            char tch = cb.get();
            LineMetrics lm = g2d.getFont().getLineMetrics(Character.toString(tch), g2d.getFontRenderContext());
            int bl = Sys_lpr.ROUND(lm.getHeight() / 2.0f);
            try {
                g2d.drawString(Character.toString(tch), this.x, this.y + bl);
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "lprRenderer.draw_one_char_text.drawString()", e.getMessage());
                return false;
            }
            return true;
        }

        private boolean erase_one_char(Graphics2D g2d) {
            return true;
        }

        private boolean draw_printable_char(Graphics2D g2d, int data) {
            if (Sys_lpr.this.use_os_font ? !this.draw_one_char_text(g2d, data) : !this.draw_one_char_image(g2d, data)) {
                return false;
            }
            this.x += this.sizeSpacing.width;
            return true;
        }

        private boolean draw_katakana_char(Graphics2D g2d, int data) {
            if (Sys_lpr.this.use_os_font ? !this.draw_one_char_katakana_text(g2d, data) : !this.draw_one_char_image(g2d, data)) {
                return false;
            }
            this.x += this.sizeSpacing.width;
            return true;
        }

        private boolean draw_graph_char(Graphics2D g2d, int data) {
            if (!this.draw_one_char_image(g2d, data)) {
                return false;
            }
            this.x += this.sizeSpacing.width;
            return true;
        }

        private void jis2sjis(int[] jis) {
            int[] sjis = new int[]{jis[0], jis[1]};
            sjis[1] = (sjis[0] & 1) != 0 ? sjis[1] + 31 : sjis[1] + 125;
            sjis[0] = (byte)((sjis[0] - 33 >> 1) + 129);
            if (sjis[0] >= 160) {
                sjis[0] = sjis[0] + 64;
            }
            if (sjis[1] >= 127) {
                sjis[1] = sjis[1] + 1;
            }
            jis[0] = sjis[0];
            jis[1] = sjis[1];
        }

        private boolean draw_kanji(Graphics2D g2d, int[] d2) {
            String csName = "SJIS";
            if (!Charset.isSupported(csName)) {
                System.err.println("Charset " + csName + " is not supported.");
                return false;
            }
            Charset cs = Charset.forName(csName);
            ByteBuffer bb = null;
            CharBuffer cb = null;
            byte[] b2 = new byte[4];
            this.jis2sjis(d2);
            b2[0] = (byte)d2[0];
            b2[1] = (byte)d2[1];
            b2[2] = 0;
            b2[3] = 0;
            bb = ByteBuffer.wrap(b2);
            cb = cs.decode(bb);
            char tch = cb.get();
            LineMetrics lm = g2d.getFont().getLineMetrics(Character.toString(tch), g2d.getFontRenderContext());
            int bl = Sys_lpr.ROUND(lm.getHeight() / 2.0f);
            try {
                g2d.drawString(Character.toString(tch), this.x, this.y + bl);
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "lprRenderer.draw_one_char_text.drawString()", e.getMessage());
                return false;
            }
            this.x += this.sizeSpacing.width << 1;
            return true;
        }

        private boolean Kanji_Is_ON() {
            return this.fKanji > 0;
        }

        private void Kanji_Clear() {
            this.fKanji = 0;
        }

        private int attribute() {
            int attr = 0;
            if (this.bWideChar) {
                attr |= 1;
            }
            if (this.Kanji_Is_ON()) {
                attr |= Integer.MIN_VALUE;
            }
            return attr;
        }

        private boolean Space(Graphics2D hdc) {
            return this.draw_printable_char(hdc, 32);
        }

        private boolean NewLine(Graphics2D hdc) {
            this.x = 0;
            this.y += this.sizeSpacing.height;
            return this.sizePrintable.height - this.y >= this.sizeSpacing.height || this.NewPage(hdc);
        }

        private boolean NewPage(Graphics2D hdc) {
            this.gotoNextPage = true;
            this.x = 0;
            this.y = 0;
            return true;
        }

        private boolean PrintChar(Graphics2D hdc) {
            PrtBuffChar buffChar = new PrtBuffChar();
            int[] d2 = new int[2];
            buffChar = this.prtBuff.Get();
            int data = buffChar.code;
            int attr = buffChar.attr;
            if (data >= 33 && data <= 126) {
                if (Sys_lpr.this.output_kanji && (attr & Integer.MIN_VALUE) != 0) {
                    d2[0] = data;
                    buffChar = this.prtBuff.Get();
                    d2[1] = buffChar.code;
                    if (!this.draw_kanji(hdc, d2)) {
                        return false;
                    }
                } else if (!this.draw_printable_char(hdc, data)) {
                    return false;
                }
            } else if (data >= 161 && data <= 223 ? !this.draw_katakana_char(hdc, data) : (data >= 128 && data <= 160 || data >= 224 && data <= 254 ? !this.draw_graph_char(hdc, data) : (data == 32 || data == 160 || data == 255) && !this.Space(hdc))) {
                return false;
            }
            return this.sizePrintable.width - this.x >= this.sizeSpacing.width || this.NewLine(hdc);
        }

        private boolean PrintLine(Graphics2D hdc) {
            while (this.prtBuff.IsReadable()) {
                if (!this.PrintChar(hdc)) {
                    return false;
                }
                if (this.gotoNextPage) break;
            }
            this.prtBuff.ClearAll();
            return true;
        }

        private boolean AddCharToPrtBuff(Graphics2D hdc, int code, int attr) {
            this.prtBuff.Add(code, attr);
            return !this.prtBuff.IsFull() || this.PrintLine(hdc);
        }

        private void set_line_spacing(int inch_per_base, int base) {
            this.sizeSpacing.height = Sys_lpr.this.INCHES2TWIPS(inch_per_base, base);
        }

        private boolean draw_bit_image(Graphics2D hdc, int nBitImgLen, int dpi) {
            Dimension sz_sp = new Dimension();
            sz_sp.width = Sys_lpr.this.INCHES2TWIPS(1, dpi) << 3;
            sz_sp.height = Sys_lpr.this.INCHES2TWIPS(1, 72) << 3;
            int j = 0;
            while (j < nBitImgLen) {
                byte data;
                try {
                    int dwRead = this.hFile.read();
                    data = (byte)dwRead;
                }
                catch (Exception e) {
                    Sys_lpr.PRINT_ERROR(this.sysmain, "draw_bit_image.read()", e.getMessage());
                    return false;
                }
                int i = 0;
                while (i < 8) {
                    int top;
                    int left;
                    if ((data & 1 << 7 - i) != 0 && !this.draw_one_dot(hdc, left = this.x + (j * sz_sp.width >> 3), top = this.y + (i * sz_sp.height >> 3))) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
            this.x += sz_sp.width * nBitImgLen >> 3;
            return true;
        }

        private boolean CarriageReturn(Graphics2D hdc) {
            if (!this.PrintLine(hdc)) {
                return false;
            }
            this.x = 0;
            return true;
        }

        private boolean LineFeed(Graphics2D hdc) {
            if (!this.PrintLine(hdc)) {
                return false;
            }
            return this.NewLine(hdc);
        }

        private boolean FormFeed(Graphics2D hdc) {
            if (!this.PrintLine(hdc)) {
                return false;
            }
            return this.NewPage(hdc);
        }

        private boolean VertTab(Graphics2D hdc) {
            return this.LineFeed(hdc);
        }

        private boolean HorzTab(Graphics2D hdc) {
            if (!this.PrintLine(hdc)) {
                return false;
            }
            int col = this.x / this.sizeSpacing.width;
            int tab = 8 - col % 8;
            this.x += this.sizeSpacing.width * tab;
            return true;
        }

        private boolean Delete(Graphics2D hdc) {
            if (!this.PrintLine(hdc)) {
                return false;
            }
            this.x -= this.sizeSpacing.width;
            if (this.x < 0) {
                this.x = 0;
            }
            return this.erase_one_char(hdc);
        }

        private boolean BackSpace(Graphics2D hdc) {
            return this.Delete(hdc);
        }

        private boolean Esc_AtMark(Graphics2D hdc) {
            return this.reset_params(hdc);
        }

        private boolean Esc_0(Graphics2D hdc) {
            this.set_line_spacing(1, 8);
            return true;
        }

        private boolean Esc_1(Graphics2D hdc) {
            this.set_line_spacing(7, this.lp_unit);
            return true;
        }

        private boolean Esc_2(Graphics2D hdc) {
            this.set_line_spacing(1, 6);
            return true;
        }

        private boolean Esc_3(Graphics2D hdc) {
            byte data;
            try {
                int dwRead = this.hFile.read();
                data = (byte)dwRead;
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "Esc_3.read()", e.getMessage());
                return false;
            }
            int n = data & 0xFF;
            this.set_line_spacing(n, this.lp_unit * 3);
            return true;
        }

        private boolean Esc_A(Graphics2D hdc) {
            byte data;
            try {
                int dwRead = this.hFile.read();
                data = (byte)dwRead;
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "Esc_A.read()", e.getMessage());
                return false;
            }
            int n = data & 0xFF;
            this.set_line_spacing(n, this.lp_unit);
            return true;
        }

        private boolean Esc_K(Graphics2D hdc) {
            byte[] data2 = new byte[2];
            if (!this.PrintLine(hdc)) {
                return false;
            }
            try {
                int dwRead = this.hFile.read(data2, 0, 2);
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "Esc_K.read()", e.getMessage());
                return false;
            }
            int nBitImgLen = (data2[1] & 0xFF) << 8 | data2[0] & 0xFF;
            return this.draw_bit_image(hdc, nBitImgLen, 60);
        }

        private boolean Esc_L(Graphics2D hdc) {
            byte[] data2 = new byte[2];
            if (!this.PrintLine(hdc)) {
                return false;
            }
            try {
                int dwRead = this.hFile.read(data2, 0, 2);
            }
            catch (Exception e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "Esc_L.read()", e.getMessage());
                return false;
            }
            int nBitImgLen = (data2[1] & 0xFF) << 8 | data2[0] & 0xFF;
            return this.draw_bit_image(hdc, nBitImgLen, 120);
        }

        private boolean Kanji_ON(Graphics2D hdc) {
            if (!this.Kanji_Is_ON() && !this.fonts.select_kanji(hdc, 0)) {
                return false;
            }
            ++this.fKanji;
            return true;
        }

        private boolean Kanji_OFF(Graphics2D hdc) {
            if (this.Kanji_Is_ON()) {
                --this.fKanji;
            }
            return this.Kanji_Is_ON() || this.fonts.select_ank(hdc, 0);
        }

        private boolean render(Graphics2D hdc, int pageIndex) {
            if (pageIndex == this.lastPageIndex) {
                this.bEofDetected = false;
                try {
                    this.hFile.seek(this.lastFilePointer);
                }
                catch (IOException e) {
                    Sys_lpr.PRINT_ERROR(this.sysmain, "LprRenderer.render.seek()", e.getMessage());
                    return false;
                }
            }
            if (this.bEofDetected) {
                return false;
            }
            this.lastPageIndex = pageIndex;
            try {
                this.lastFilePointer = this.hFile.getFilePointer();
            }
            catch (IOException e) {
                Sys_lpr.PRINT_ERROR(this.sysmain, "LprRenderer.render.getFilePointer()", e.getMessage());
                return false;
            }
            do {
                int data;
                int dwRead;
                try {
                    data = dwRead = this.hFile.read();
                }
                catch (Exception e) {
                    Sys_lpr.PRINT_ERROR(this.sysmain, "LprRenderer.render.read()", e.getMessage());
                    return false;
                }
                if (dwRead == -1) {
                    this.bEofDetected = true;
                    break;
                }
                if (data >= 32 && data <= 126 || data >= 128 && data <= 255) {
                    int attr = this.attribute();
                    if (this.AddCharToPrtBuff(hdc, data, attr)) continue;
                    return false;
                }
                if (data == 13) {
                    if (this.CarriageReturn(hdc)) continue;
                    return false;
                }
                if (data == 10) {
                    if (this.LineFeed(hdc)) continue;
                    return false;
                }
                if (data == 12) {
                    if (this.FormFeed(hdc)) break;
                    return false;
                }
                if (data == 11) {
                    if (this.VertTab(hdc)) continue;
                    return false;
                }
                if (data == 9) {
                    if (this.HorzTab(hdc)) continue;
                    return false;
                }
                if (data == 8) {
                    if (this.BackSpace(hdc)) continue;
                    return false;
                }
                if (data == 127) {
                    if (this.Delete(hdc)) continue;
                    return false;
                }
                if (data == 27) {
                    try {
                        data = dwRead = this.hFile.read();
                    }
                    catch (Exception e) {
                        Sys_lpr.PRINT_ERROR(this.sysmain, "render.read()", e.getMessage());
                        return false;
                    }
                    if (!(data == 64 ? !this.Esc_AtMark(hdc) : (data == 48 ? !this.Esc_0(hdc) : (data == 49 ? !this.Esc_1(hdc) : (data == 50 ? !this.Esc_2(hdc) : (data == 51 ? !this.Esc_3(hdc) : (data == 65 ? !this.Esc_A(hdc) : (data == 75 ? !this.Esc_K(hdc) : data == 76 && !this.Esc_L(hdc))))))))) continue;
                    return false;
                }
                if (data != 28) continue;
                try {
                    data = dwRead = this.hFile.read();
                }
                catch (Exception e) {
                    Sys_lpr.PRINT_ERROR(this.sysmain, "render.read()", e.getMessage());
                    return false;
                }
                if (!(data == 38 ? !this.Kanji_ON(hdc) : data == 46 && !this.Kanji_OFF(hdc))) continue;
                return false;
            } while (!this.gotoNextPage);
            return true;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            System.out.println("pageIndex=" + pageIndex);
            Graphics2D g2d = (Graphics2D)g;
            this.gotoNextPage = false;
            if (!this.contert_to_twips_coordinates(g2d)) {
                return 1;
            }
            this.fonts = new LprFonts();
            if (!this.fonts.create(g2d, this.sizeChar)) {
                return 1;
            }
            if (!this.set_printable_area(g2d, pf)) {
                this.fonts.delete_f(g2d);
                return 1;
            }
            if (!this.reset_params(g2d)) {
                this.fonts.delete_f(g2d);
                return 1;
            }
            if (!this.render(g2d, pageIndex)) {
                return 1;
            }
            System.out.println("lprRenderer.print() exiting.");
            return 0;
        }
    }
}

