/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.Sys_main;
import java.util.concurrent.locks.ReentrantLock;

public class Sys_sch
implements Runnable {
    private final ReentrantLock lock = new ReentrantLock();
    int dwExecTotal;
    boolean bTapeFullSpeed;
    boolean bFullSpeed;
    boolean bAutoSpeedAdjust;
    private long dwNowTime;
    boolean bTapeModeType;
    boolean bCloseReq;
    private boolean bDrawVsync;
    private boolean bPollVsync;
    private long dwExecTime;
    private int nFrameSkip;
    private boolean bRunningBak;
    private int nSpeedCheck;
    private long dwChkTime;
    private int dwSleepCount;
    private int speed_ratio;
    private boolean suspend_flag;
    private boolean tbRun_Flag;
    private boolean tbAutoSpeedAdjust;
    private StringBuffer[] strTitle = new StringBuffer[]{new StringBuffer(), new StringBuffer(), new StringBuffer()};
    private Sys_main sysmain;
    private emu.xm7.vm.System vm;
    Thread VMthread;

    Sys_sch(Sys_main sysmain, emu.xm7.vm.System vm) {
        this.sysmain = sysmain;
        this.vm = vm;
    }

    void InitSch() {
        this.VMthread = null;
        this.bDrawVsync = true;
        this.bPollVsync = true;
        this.bRunningBak = false;
        this.dwExecTotal = 0;
        this.dwNowTime = 0L;
        this.bTapeFullSpeed = false;
        this.bFullSpeed = false;
        this.bAutoSpeedAdjust = false;
        this.bTapeModeType = false;
        this.bCloseReq = false;
    }

    void CleanSch() {
        if (this.VMthread != null) {
            try {
                this.VMthread.join(5000L);
            }
            catch (InterruptedException e) {
                System.err.println("Thread " + this.VMthread.getId() + " interrupted.");
            }
        }
    }

    public void vsync_notify() {
        this.bDrawVsync = true;
        this.bPollVsync = true;
    }

    private void ExecSch() {
        this.sysmain.sys_kbd.PollKbd();
        if (this.bPollVsync) {
            this.sysmain.sys_kbd.PollMos();
            this.bPollVsync = false;
        }
        this.sysmain.sys_snd.ProcessSnd(false);
        int dwCount = 1000;
        while (dwCount > 0) {
            if (this.vm.schedule.stopreq_flag) {
                this.vm.schedule.run_flag = false;
                break;
            }
            int dwExec = this.vm.schedule.exec(dwCount);
            dwCount -= dwExec;
        }
        this.dwExecTotal += 1000 - dwCount;
    }

    private void DrawSch() {
        if (this.sysmain.opd != null && this.sysmain.opd.isVisible()) {
            this.sysmain.opd.resize();
            this.sysmain.opd.repaint();
        }
        this.sysmain.tapeind.updateInd();
        this.sysmain.flpind[0].updateInd();
        this.sysmain.flpind[1].updateInd();
        this.sysmain.keyind.updateInd();
        this.sysmain.sys_dsp.display();
        if (this.tbRun_Flag != this.vm.schedule.run_flag || this.tbAutoSpeedAdjust != this.bAutoSpeedAdjust || this.bAutoSpeedAdjust && this.speed_ratio != this.vm.schedule.speed_ratio) {
            if (this.tbRun_Flag != this.vm.schedule.run_flag) {
                this.tbRun_Flag = this.vm.schedule.run_flag;
                this.strTitle[0].setLength(0);
                this.strTitle[0].append("XM7");
                this.strTitle[0].append(this.tbRun_Flag ? "[\u5b9f\u884c]" : "[\u505c\u6b62]");
            }
            if (this.tbAutoSpeedAdjust != this.bAutoSpeedAdjust) {
                this.tbAutoSpeedAdjust = this.bAutoSpeedAdjust;
                if (!this.tbAutoSpeedAdjust) {
                    this.strTitle[1].setLength(0);
                }
            }
            if (this.bAutoSpeedAdjust && this.speed_ratio != this.vm.schedule.speed_ratio) {
                this.strTitle[1].setLength(0);
                this.strTitle[1].append("(");
                this.strTitle[1].append(this.vm.schedule.speed_ratio / 100);
                this.strTitle[1].append("%)");
                this.speed_ratio = this.vm.schedule.speed_ratio;
            } else if (!this.bAutoSpeedAdjust && this.tbRun_Flag) {
                this.strTitle[1].setLength(0);
            }
            this.strTitle[2].setLength(0);
            this.strTitle[2].append(this.strTitle[0]);
            this.strTitle[2].append(this.strTitle[1]);
            this.sysmain.setTitle(this.strTitle[2].toString());
        }
    }

    private void ResetSch() {
        this.nFrameSkip = 0;
        this.dwExecTime = this.timeGetTime();
    }

    private void ResetSpeedAdjuster() {
        this.nSpeedCheck = 0;
        this.dwSleepCount = 0;
        this.dwChkTime = this.timeGetTime();
    }

    boolean ThreadSch() {
        this.suspend_flag = false;
        this.ResetSch();
        this.ResetSpeedAdjuster();
        block0: while (!this.bCloseReq) {
            int tmp;
            long dwTempTime;
            this.LockVM();
            if (this.bRunningBak != this.vm.schedule.run_flag) {
                this.bRunningBak = this.vm.schedule.run_flag;
            }
            if (!this.vm.schedule.run_flag || this.suspend_flag) {
                this.sysmain.sys_snd.ProcessSnd(true);
                this.UnlockVM();
                this.Sleep(10);
                this.ResetSch();
                this.ResetSpeedAdjuster();
                continue;
            }
            if (this.vm.reset_flag) {
                this.ResetSpeedAdjuster();
                this.vm.reset_flag = false;
            }
            if ((dwTempTime = (this.dwNowTime = this.timeGetTime())) < this.dwExecTime) {
                this.dwExecTime = 0L;
            }
            if (dwTempTime <= this.dwExecTime) {
                if (this.bDrawVsync) {
                    this.DrawSch();
                    this.nFrameSkip = 0;
                    this.bDrawVsync = false;
                }
                if ((dwTempTime = (this.dwNowTime = this.timeGetTime())) < this.dwExecTime) {
                    this.dwExecTime = 0L;
                }
                if (dwTempTime > this.dwExecTime) {
                    this.UnlockVM();
                    continue;
                }
                if (!(this.vm.tapelp.tape_motor && this.bTapeFullSpeed && this.bTapeModeType)) {
                    ++this.dwSleepCount;
                    if (this.bFullSpeed || this.vm.tapelp.tape_motor && this.bTapeFullSpeed && !this.bTapeModeType) {
                        this.UnlockVM();
                        while (!this.vm.schedule.stopreq_flag) {
                            if (dwTempTime != this.timeGetTime()) continue block0;
                            if (this.vm.tapelp.tape_motor && this.bTapeFullSpeed && !this.bFullSpeed) {
                                this.vm.schedule.main_fullspeed();
                                continue;
                            }
                            this.vm.schedule.fullspeed();
                        }
                        continue;
                    }
                    this.UnlockVM();
                    this.Sleep(1);
                    continue;
                }
                this.dwExecTime = dwTempTime - 1L;
                if (this.dwExecTime > dwTempTime) {
                    ++this.dwExecTime;
                }
            }
            this.ExecSch();
            ++this.nFrameSkip;
            ++this.nSpeedCheck;
            ++this.dwExecTime;
            if (this.nSpeedCheck >= 200) {
                if (this.bAutoSpeedAdjust) {
                    dwTempTime = this.timeGetTime();
                    if (dwTempTime < this.dwChkTime) {
                        this.dwChkTime = 0L;
                    }
                    this.vm.schedule.speed_ratio = (this.nSpeedCheck + this.dwSleepCount) * this.vm.schedule.speed_ratio;
                    this.vm.schedule.speed_ratio = (int)((long)this.vm.schedule.speed_ratio / (dwTempTime - this.dwChkTime));
                    if (this.vm.schedule.speed_ratio > 10000) {
                        this.vm.schedule.speed_ratio = 10000;
                    } else if (this.vm.schedule.speed_ratio < 500) {
                        this.vm.schedule.speed_ratio = 500;
                    }
                } else {
                    this.vm.schedule.speed_ratio = 10000;
                }
                this.ResetSpeedAdjuster();
            }
            if (this.bCloseReq) {
                this.UnlockVM();
                break;
            }
            if (!this.vm.schedule.run_flag) {
                this.DrawSch();
                this.bDrawVsync = false;
                this.nFrameSkip = 0;
                this.UnlockVM();
                continue;
            }
            if (this.bAutoSpeedAdjust) {
                tmp = (10000 - this.vm.schedule.speed_ratio) / 10;
                if ((this.vm.display.screen_mode & 1) != 0) {
                    if (tmp < 66) {
                        tmp = 66;
                    }
                } else if (tmp < 33) {
                    tmp = 33;
                }
                if (tmp > 500) {
                    tmp = 500;
                }
            } else {
                tmp = 500;
            }
            if (this.nFrameSkip >= tmp) {
                this.DrawSch();
                this.ResetSch();
                this.bDrawVsync = false;
            }
            this.UnlockVM();
        }
        this.bCloseReq = false;
        return true;
    }

    void LockVM() {
        this.lock.lock();
    }

    void UnlockVM() {
        this.lock.unlock();
    }

    void SuspendVM() {
        this.suspend_flag = true;
        this.Sleep(10);
    }

    void ReleaseVM() {
        this.suspend_flag = false;
        this.Sleep(10);
    }

    private long timeGetTime() {
        return System.currentTimeMillis();
    }

    void Sleep(int t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.ThreadSch();
    }
}

