/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Aluline
extends Base
implements EventHandler {
    int alu_command;
    private int alu_color;
    private int alu_mask;
    private int alu_cmpstat;
    private int[] alu_cmpdat = new int[8];
    private int alu_disable;
    private int[] alu_tiledat = new int[3];
    boolean line_busy;
    private int line_offset;
    private int line_style;
    private int line_x0;
    private int line_y0;
    private int line_x1;
    private int line_y1;
    boolean line_boost;
    private int vrambank;
    private int addr_old;
    private int linemask;
    private int line_count;
    private int line_count_sub;
    private final int aluline_event = 0;
    final int[] mask = new int[]{127, 191, 223, 239, 247, 251, 253, 254};

    Aluline() {
    }

    boolean init() {
        this.line_boost = false;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        this.alu_command = 0;
        this.alu_color = 0;
        this.alu_mask = 0;
        this.alu_cmpstat = 0;
        Util.memset(this.alu_cmpdat, 128, Util.sizeof(this.alu_cmpdat));
        this.alu_disable = 8;
        Util.memset(this.alu_tiledat, 0, Util.sizeof(this.alu_tiledat));
        this.line_busy = false;
        this.line_offset = 0;
        this.line_style = 0;
        this.line_x0 = 0;
        this.line_y0 = 0;
        this.line_x1 = 0;
        this.line_y1 = 0;
        this.vrambank = 0;
        this.addr_old = 65535;
        this.linemask = 255;
        this.line_count = 0;
        this.line_count_sub = 0;
    }

    private int alu_read(int addr) {
        if ((Aluline.multipag.multi_page & 1 << this.vrambank) != 0) {
            return 255;
        }
        if (Aluline.subctrl.mode400l) {
            if (addr >= 32768) {
                return 255;
            }
            return Aluline.display.vram_ablk_v[Aluline.display.vram_ablk_p + this.vrambank * 32768 + addr] & 0xFF;
        }
        return Aluline.display.vram_aptr_v[Aluline.display.vram_aptr_p + this.vrambank * 32768 + addr] & 0xFF;
    }

    private void alu_write(int addr, int dat) {
        if ((Aluline.multipag.multi_page & 1 << this.vrambank) != 0) {
            return;
        }
        if (Aluline.subctrl.mode400l) {
            if (addr < 32768 && Aluline.display.vram_ablk_v[Aluline.display.vram_ablk_p + this.vrambank * 32768 + addr] != (byte)dat) {
                Aluline.display.vram_ablk_v[Aluline.display.vram_ablk_p + this.vrambank * 32768 + addr] = (byte)dat;
                Aluline.sysmain.sys_dsp.vram_notify(addr, dat);
            }
        } else if (Aluline.display.vram_aptr_v[Aluline.display.vram_aptr_p + this.vrambank * 32768 + addr] != (byte)dat) {
            Aluline.display.vram_aptr_v[Aluline.display.vram_aptr_p + this.vrambank * 32768 + addr] = (byte)dat;
            Aluline.sysmain.sys_dsp.vram_notify(addr, dat);
        }
    }

    private void alu_writesub(int addr, int dat) {
        if ((this.alu_command & 0x40) == 0) {
            this.alu_write(addr, dat);
            return;
        }
        if ((this.alu_command & 0x20) != 0) {
            int temp = this.alu_read(addr);
            this.alu_write(addr, (temp &= this.alu_cmpstat) | (dat &= ~this.alu_cmpstat));
        } else {
            int temp = this.alu_read(addr);
            this.alu_write(addr, (temp &= ~this.alu_cmpstat) | (dat &= this.alu_cmpstat));
        }
    }

    private void alu_pset(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        int bit = 1;
        if ((this.alu_command & 0x40) != 0) {
            this.alu_cmp(addr);
        }
        this.vrambank = 0;
        while (this.vrambank < 3) {
            if ((this.alu_disable & bit) != 0) {
                bit <<= 1;
            } else {
                int dat = (this.alu_color & bit) != 0 ? 255 : 0;
                int mask = this.alu_read(addr);
                dat &= ~this.alu_mask;
                this.alu_writesub(addr, dat |= (mask &= this.alu_mask));
                bit <<= 1;
            }
            ++this.vrambank;
        }
    }

    private void alu_preset(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        int bit = 1;
        if ((this.alu_command & 0x40) != 0) {
            this.alu_cmp(addr);
        }
        this.vrambank = 0;
        while (this.vrambank < 3) {
            if ((this.alu_disable & bit) != 0) {
                bit <<= 1;
            } else {
                int dat = (this.alu_color & bit) != 0 ? 0 : 255;
                int mask = this.alu_read(addr);
                dat &= ~this.alu_mask;
                this.alu_writesub(addr, dat |= (mask &= this.alu_mask));
                bit <<= 1;
            }
            ++this.vrambank;
        }
    }

    private void alu_or(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        int bit = 1;
        if ((this.alu_command & 0x40) != 0) {
            this.alu_cmp(addr);
        }
        this.vrambank = 0;
        while (this.vrambank < 3) {
            if ((this.alu_disable & bit) != 0) {
                bit <<= 1;
            } else {
                int dat = (this.alu_color & bit) != 0 ? 255 : 0;
                int mask = this.alu_read(addr);
                dat |= mask;
                dat &= ~this.alu_mask;
                this.alu_writesub(addr, dat |= (mask &= this.alu_mask));
                bit <<= 1;
            }
            ++this.vrambank;
        }
    }

    private void alu_and(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        int bit = 1;
        if ((this.alu_command & 0x40) != 0) {
            this.alu_cmp(addr);
        }
        this.vrambank = 0;
        while (this.vrambank < 3) {
            if ((this.alu_disable & bit) != 0) {
                bit <<= 1;
            } else {
                int dat = (this.alu_color & bit) != 0 ? 255 : 0;
                int mask = this.alu_read(addr);
                dat &= mask;
                dat &= ~this.alu_mask;
                this.alu_writesub(addr, dat |= (mask &= this.alu_mask));
                bit <<= 1;
            }
            ++this.vrambank;
        }
    }

    private void alu_xor(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        int bit = 1;
        if ((this.alu_command & 0x40) != 0) {
            this.alu_cmp(addr);
        }
        this.vrambank = 0;
        while (this.vrambank < 3) {
            if ((this.alu_disable & bit) != 0) {
                bit <<= 1;
            } else {
                int dat = (this.alu_color & bit) != 0 ? 255 : 0;
                int mask = this.alu_read(addr);
                dat ^= mask;
                dat &= ~this.alu_mask;
                this.alu_writesub(addr, dat |= (mask &= this.alu_mask));
                bit <<= 1;
            }
            ++this.vrambank;
        }
    }

    private void alu_not(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        int bit = 1;
        if ((this.alu_command & 0x40) != 0) {
            this.alu_cmp(addr);
        }
        this.vrambank = 0;
        while (this.vrambank < 3) {
            if ((this.alu_disable & bit) != 0) {
                bit <<= 1;
            } else {
                int mask = this.alu_read(addr);
                int dat = ~mask;
                dat &= ~this.alu_mask;
                this.alu_writesub(addr, dat |= (mask &= this.alu_mask));
                bit <<= 1;
            }
            ++this.vrambank;
        }
    }

    private void alu_tile(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        int bit = 1;
        if ((this.alu_command & 0x40) != 0) {
            this.alu_cmp(addr);
        }
        this.vrambank = 0;
        while (this.vrambank < 3) {
            if ((this.alu_disable & bit) != 0) {
                bit <<= 1;
            } else {
                int dat = this.alu_tiledat[this.vrambank];
                dat &= ~this.alu_mask;
                int mask = this.alu_read(addr);
                this.alu_writesub(addr, dat |= (mask &= this.alu_mask));
                bit <<= 1;
            }
            ++this.vrambank;
        }
    }

    private void alu_cmp(int addr) {
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        this.vrambank = 0;
        int b = this.alu_read(addr);
        this.vrambank = 1;
        int r = this.alu_read(addr);
        this.vrambank = 2;
        int g = this.alu_read(addr);
        int disflag = ~this.alu_disable & 7;
        int dat = 0;
        int bit = 128;
        int i = 0;
        while (i < 8) {
            int color = 0;
            if ((b & bit) != 0) {
                color |= 1;
            }
            if ((r & bit) != 0) {
                color |= 2;
            }
            if ((g & bit) != 0) {
                color |= 4;
            }
            boolean flag = false;
            int j = 0;
            while (j < 8) {
                if ((this.alu_cmpdat[j] & 0x80) == 0 && (this.alu_cmpdat[j] & disflag) == (color & disflag)) {
                    flag = true;
                    break;
                }
                ++j;
            }
            if (flag) {
                dat |= bit;
            }
            bit >>= 1;
            ++i;
        }
        this.alu_cmpstat = dat;
    }

    private void exec(int addr) {
        if (addr >= 32768) {
            this.linemask = 255;
            return;
        }
        this.alu_mask = this.linemask;
        this.linemask = 255;
        switch (this.alu_command & 7) {
            case 0: {
                this.alu_pset(addr);
                break;
            }
            case 1: {
                this.alu_preset(addr);
                break;
            }
            case 2: {
                this.alu_or(addr);
                break;
            }
            case 3: {
                this.alu_and(addr);
                break;
            }
            case 4: {
                this.alu_xor(addr);
                break;
            }
            case 5: {
                this.alu_not(addr);
                break;
            }
            case 6: {
                this.alu_tile(addr);
                break;
            }
            case 7: {
                this.alu_cmp(addr);
            }
        }
        ++this.line_count;
    }

    private void pset(int x, int y) {
        if ((this.alu_command & 0x80) == 0) {
            return;
        }
        int addr = (Aluline.display.screen_mode & 1) != 0 ? y * 40 + (x >> 3) : y * 80 + (x >> 3);
        addr += this.line_offset;
        addr = Aluline.subctrl.mode400l ? (addr &= Short.MAX_VALUE) : (addr &= 0x3FFF);
        if (this.addr_old != addr) {
            this.exec(this.addr_old);
            this.addr_old = addr;
        }
        if ((this.line_style & 0x8000) != 0) {
            this.linemask &= this.mask[x & 7];
        }
        this.line_style = (this.line_style << 1 | this.line_style >> 15) & 0xFFFF;
    }

    private void line() {
        int uy;
        int ux;
        int x1 = this.line_x0;
        int x2 = this.line_x1;
        int y1 = this.line_y0;
        int y2 = this.line_y1;
        this.line_count = 0;
        this.addr_old = 65535;
        this.linemask = 255;
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx < 0) {
            ux = -1;
            dx = -dx;
        } else {
            ux = 1;
        }
        if (dy < 0) {
            uy = -1;
            dy = -dy;
        } else {
            uy = 1;
        }
        if (dx == 0 && dy == 0) {
            this.pset(x1, y1);
        } else if (dx == 0) {
            while (true) {
                this.pset(x1, y1);
                if (y1 != y2) {
                    y1 += uy;
                    continue;
                }
                break;
            }
        } else if (dy == 0) {
            while (true) {
                this.pset(x1, y1);
                if (x1 != x2) {
                    x1 += ux;
                    continue;
                }
                break;
            }
        } else if (dx >= dy) {
            int r = dx >> 1;
            while (true) {
                this.pset(x1, y1);
                if (x1 != x2) {
                    x1 += ux;
                    if ((r -= dy) >= 0) continue;
                    r += dx;
                    y1 += uy;
                    continue;
                }
                break;
            }
        } else {
            int r = dy >> 1;
            while (true) {
                this.pset(x1, y1);
                if (y1 == y2) break;
                y1 += uy;
                if ((r -= dx) >= 0) continue;
                r += dy;
                x1 += ux;
            }
        }
        this.exec(this.addr_old);
    }

    @Override
    public boolean event(int callbackid) {
        this.line_busy = false;
        schedule.delevent(8);
        return true;
    }

    boolean readb(int addr, IntHolder dat) {
        if (Aluline.vm.fm7_ver < 2) {
            return false;
        }
        switch (addr) {
            case 54288: {
                dat.value = this.alu_command;
                return true;
            }
            case 54289: {
                dat.value = this.alu_color;
                return true;
            }
            case 54290: {
                dat.value = this.alu_mask;
                return true;
            }
            case 54291: {
                dat.value = this.alu_cmpstat;
                return true;
            }
            case 54299: {
                dat.value = this.alu_disable;
                return true;
            }
        }
        if (addr >= 54291 && addr <= 54298) {
            dat.value = 255;
            return true;
        }
        if (addr >= 54300 && addr <= 54302) {
            dat.value = 255;
            return true;
        }
        if (addr >= 54304 && addr <= 54315) {
            dat.value = 255;
            return true;
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        if (Aluline.vm.fm7_ver < 2) {
            return false;
        }
        switch (addr) {
            case 54288: {
                this.alu_command = dat;
                return true;
            }
            case 54289: {
                this.alu_color = dat;
                return true;
            }
            case 54290: {
                this.alu_mask = dat;
                return true;
            }
            case 54299: {
                this.alu_disable = dat;
                return true;
            }
            case 54304: {
                this.line_offset &= 0x1FE;
                this.line_offset |= dat * 512 & 0x3E00;
                return true;
            }
            case 54305: {
                this.line_offset &= 0x3E00;
                this.line_offset |= dat * 2;
                return true;
            }
            case 54306: {
                this.line_style &= 0xFF;
                this.line_style |= dat * 256;
                return true;
            }
            case 54307: {
                this.line_style &= 0xFF00;
                this.line_style |= dat;
                return true;
            }
            case 54308: {
                this.line_x0 &= 0xFF;
                this.line_x0 |= dat * 256;
                this.line_x0 &= 0x3FF;
                return true;
            }
            case 54309: {
                this.line_x0 &= 0xFF00;
                this.line_x0 |= dat;
                return true;
            }
            case 54310: {
                this.line_y0 &= 0xFF;
                this.line_y0 |= dat * 256;
                this.line_y0 &= 0x1FF;
                return true;
            }
            case 54311: {
                this.line_y0 &= 0xFF00;
                this.line_y0 |= dat;
                return true;
            }
            case 54312: {
                this.line_x1 &= 0xFF;
                this.line_x1 |= dat * 256;
                this.line_x1 &= 0x3FF;
                return true;
            }
            case 54313: {
                this.line_x1 &= 0xFF00;
                this.line_x1 |= dat;
                return true;
            }
            case 54314: {
                this.line_y1 &= 0xFF;
                this.line_y1 |= dat * 256;
                this.line_y1 &= 0x1FF;
                return true;
            }
            case 54315: {
                this.line_y1 &= 0xFF00;
                this.line_y1 |= dat;
                this.line();
                int tmp = this.line_count >> 4;
                this.line_count_sub += this.line_count & 0xF;
                if (this.line_count_sub >= 16) {
                    ++tmp;
                    this.line_count_sub &= 0xF;
                }
                if (tmp > 0) {
                    this.line_busy = true;
                    schedule.setevent(8, tmp, this, 0);
                }
                return true;
            }
        }
        if (addr >= 54291 && addr <= 54298) {
            this.alu_cmpdat[addr - 54291] = dat;
            return true;
        }
        if (addr >= 54300 && addr <= 54302) {
            this.alu_tiledat[addr - 54300] = dat;
            return true;
        }
        return false;
    }

    void extrb(int addr) {
        if ((this.alu_command & 0x80) != 0) {
            switch (this.alu_command & 7) {
                case 0: {
                    this.alu_pset(addr);
                    break;
                }
                case 1: {
                    this.alu_preset(addr);
                    break;
                }
                case 2: {
                    this.alu_or(addr);
                    break;
                }
                case 3: {
                    this.alu_and(addr);
                    break;
                }
                case 4: {
                    this.alu_xor(addr);
                    break;
                }
                case 5: {
                    this.alu_not(addr);
                    break;
                }
                case 6: {
                    this.alu_tile(addr);
                    break;
                }
                case 7: {
                    this.alu_cmp(addr);
                }
            }
        }
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.byte_write(fileh, this.alu_command)) {
            return false;
        }
        if (!File.byte_write(fileh, this.alu_color)) {
            return false;
        }
        if (!File.byte_write(fileh, this.alu_mask)) {
            return false;
        }
        if (!File.byte_write(fileh, this.alu_cmpstat)) {
            return false;
        }
        if (!File.write(fileh, this.alu_cmpdat, this.alu_cmpdat.length)) {
            return false;
        }
        if (!File.byte_write(fileh, this.alu_disable)) {
            return false;
        }
        if (!File.write(fileh, this.alu_tiledat, this.alu_tiledat.length)) {
            return false;
        }
        if (!File.bool_write(fileh, this.line_busy)) {
            return false;
        }
        if (!File.word_write(fileh, this.line_offset)) {
            return false;
        }
        if (!File.word_write(fileh, this.line_style)) {
            return false;
        }
        if (!File.word_write(fileh, this.line_x0)) {
            return false;
        }
        if (!File.word_write(fileh, this.line_y0)) {
            return false;
        }
        if (!File.word_write(fileh, this.line_x1)) {
            return false;
        }
        if (!File.word_write(fileh, this.line_y1)) {
            return false;
        }
        return File.byte_write(fileh, 0);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        block6: {
            block5: {
                if (ver < 200) {
                    return false;
                }
                try {
                    this.alu_command = File.byte_read(fileh);
                    this.alu_color = File.byte_read(fileh);
                    this.alu_mask = File.byte_read(fileh);
                    this.alu_cmpstat = File.byte_read(fileh);
                    if (File.read(fileh, this.alu_cmpdat, this.alu_cmpdat.length)) break block5;
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            this.alu_disable = File.byte_read(fileh);
            if (File.read(fileh, this.alu_tiledat, this.alu_tiledat.length)) break block6;
            return false;
        }
        this.line_busy = File.bool_read(fileh);
        this.line_offset = File.word_read(fileh);
        this.line_style = File.word_read(fileh);
        this.line_x0 = File.word_read(fileh);
        this.line_y0 = File.word_read(fileh);
        this.line_x1 = File.word_read(fileh);
        this.line_y1 = File.word_read(fileh);
        File.byte_read(fileh);
        schedule.handle(8, this, 0);
        return true;
    }
}

