/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.BytePointer;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Memory;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Mainmem
extends Base
implements Memory {
    private byte[] mainram_a;
    private byte[] mainram_b;
    private byte[] basic_rom;
    private byte[] main_io;
    boolean basicrom_en;
    byte[] extram_a;
    byte[] extram_c;
    private byte[] boot_ram;
    byte[] init_rom;
    boolean initrom_en;
    boolean bootram_rw;
    int ioaccess_count;
    boolean ioaccess_flag;
    private IntHolder waddr = new IntHolder();
    private IntHolder wdat = new IntHolder();

    Mainmem() {
    }

    boolean init() {
        BytePointer p;
        this.mainram_a = null;
        this.mainram_b = null;
        this.basic_rom = null;
        this.main_io = null;
        this.extram_a = null;
        this.extram_c = null;
        this.init_rom = null;
        this.boot_ram = null;
        this.mainram_a = Util.malloc(32768);
        if (this.mainram_a == null) {
            return false;
        }
        this.mainram_b = Util.malloc(31872);
        if (this.mainram_b == null) {
            return false;
        }
        this.basic_rom = Util.malloc(31744);
        if (this.basic_rom == null) {
            return false;
        }
        this.main_io = Util.malloc(256);
        if (this.main_io == null) {
            return false;
        }
        this.extram_a = Util.malloc(65536);
        if (this.extram_a == null) {
            return false;
        }
        this.extram_c = Util.malloc(786432);
        if (this.extram_c == null) {
            return false;
        }
        this.init_rom = Util.malloc(8192);
        if (this.init_rom == null) {
            return false;
        }
        this.boot_ram = Util.malloc(512);
        if (this.boot_ram == null) {
            return false;
        }
        if (!File.load("FBASIC30.ROM", this.basic_rom, 31744)) {
            return false;
        }
        if (!File.load("INITIATE.ROM", this.init_rom, 8192)) {
            return false;
        }
        int i = 0;
        while (i < 2) {
            p = new BytePointer(this.init_rom, 6144 + i * 512);
            if (p.v(335) == 38) {
                p.setv(335, 33);
            }
            if (p.v(339) == 38) {
                p.setv(339, 33);
            }
            ++i;
        }
        p = new BytePointer(this.init_rom, 7168);
        if (p.v(143) == 16 && p.v(144) == 35) {
            p.setv(143, 18);
            p.setv(144, 22);
            if (p.v(358) == 39) {
                p.setv(358, 33);
            }
            if (p.v(470) == 38) {
                p.setv(470, 33);
            }
        }
        if (p.v(116) == 16 && p.v(117) == 35) {
            p.setv(116, 18);
            p.setv(117, 22);
            if (p.v(243) == 39) {
                p.setv(243, 33);
            }
            if (p.v(406) == 38) {
                p.setv(406, 33);
            }
        }
        Util.memset(this.boot_ram, (byte)0, 512);
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        if (this.mainram_a != null) {
            Util.free(this.mainram_a);
        }
        if (this.mainram_b != null) {
            Util.free(this.mainram_b);
        }
        if (this.basic_rom != null) {
            Util.free(this.basic_rom);
        }
        if (this.main_io != null) {
            Util.free(this.main_io);
        }
        if (this.extram_a != null) {
            Util.free(this.extram_a);
        }
        if (this.extram_c != null) {
            Util.free(this.extram_c);
        }
        if (this.init_rom != null) {
            Util.free(this.init_rom);
        }
        if (this.boot_ram != null) {
            Util.free(this.boot_ram);
        }
    }

    void reset() {
        Util.memset(this.main_io, (byte)-1, 256);
        this.ioaccess_count = 0;
        this.ioaccess_flag = false;
        this.basicrom_en = Mainmem.vm.boot_mode == 0;
        if (Mainmem.vm.fm7_ver >= 2) {
            this.initrom_en = true;
            this.bootram_rw = true;
        } else {
            this.initrom_en = false;
            this.bootram_rw = false;
        }
        Util.memset(this.boot_ram, (byte)0, 496);
        this.transfer_boot();
        switch (Mainmem.vm.fm7_ver) {
            case 1: {
                break;
            }
            case 2: {
                Util.memset(this.init_rom, 2830, (byte)-1, 3);
                break;
            }
            case 3: {
                this.init_rom[2830] = 52;
                this.init_rom[2831] = 48;
                this.init_rom[2832] = 49;
            }
        }
    }

    private void transfer_boot() {
        if (Mainmem.vm.fm7_ver < 2) {
            if (Mainmem.vm.boot_mode == 0) {
                Util.memcpy(this.boot_ram, 0, this.init_rom, 6144, 480);
            } else {
                Util.memcpy(this.boot_ram, 0, this.init_rom, 6656, 480);
            }
            this.boot_ram[510] = -2;
            this.boot_ram[511] = 0;
        }
    }

    private void iowait() {
        int tmp = !this.ioaccess_flag ? 2 : 3;
        if (++this.ioaccess_count >= tmp) {
            Mainmem.maincpu.total = Mainmem.maincpu.total + 1;
            this.ioaccess_count = 0;
            this.ioaccess_flag = (Mainmem.mmr.mmr_flag || Mainmem.mmr.twr_flag) && !Mainmem.mmr.mmr_fastmode ? !this.ioaccess_flag : false;
        }
    }

    @Override
    public int readb(int addr) {
        addr &= 0xFFFF;
        if (Mainmem.mmr.mmr_flag || Mainmem.mmr.twr_flag) {
            IntHolder _addr = this.waddr;
            _addr.value = addr;
            if (mmr.extrb(_addr, this.wdat)) {
                return this.wdat.value;
            }
            addr = _addr.value;
        }
        if (addr < 24576) {
            return this.mainram_a[addr] & 0xFF;
        }
        if (addr < 32768) {
            if (this.initrom_en) {
                return this.init_rom[addr - 24576] & 0xFF;
            }
            return this.mainram_a[addr] & 0xFF;
        }
        if (addr < 64512) {
            if (this.basicrom_en) {
                return this.basic_rom[addr - 32768] & 0xFF;
            }
            return this.mainram_b[addr - 32768] & 0xFF;
        }
        if (addr < 64640) {
            return this.mainram_b[addr - 32768] & 0xFF;
        }
        if (addr < 64768) {
            if (Mainmem.subctrl.subhalt_flag) {
                return Mainmem.subctrl.shared_ram[addr - 64640] & 0xFF;
            }
            return 255;
        }
        if (addr >= 65534 && this.initrom_en) {
            this.iowait();
            return this.init_rom[addr - 57344] & 0xFF;
        }
        if (addr >= 65024) {
            if (addr <= 65503) {
                this.iowait();
            }
            return this.boot_ram[addr - 65024] & 0xFF;
        }
        this.iowait();
        if (mainetc.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (ttlpalet.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (subctrl.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (multipag.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (fdc.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (kanji.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (tapelp.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (opn.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (whg.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (thg.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (mmr.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (apalet.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (dmac.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        return 255;
    }

    @Override
    public int readbnio(int addr) {
        addr &= 0xFFFF;
        if (Mainmem.mmr.mmr_flag || Mainmem.mmr.twr_flag) {
            IntHolder _addr = this.waddr;
            this.waddr.value = addr;
            if (mmr.extrb(_addr, this.wdat)) {
                return this.wdat.value;
            }
            addr = _addr.value;
        }
        if (addr < 24576) {
            return this.mainram_a[addr] & 0xFF;
        }
        if (addr < 32768) {
            if (this.initrom_en) {
                return this.init_rom[addr - 24576] & 0xFF;
            }
            return this.mainram_a[addr] & 0xFF;
        }
        if (addr < 64512) {
            if (this.basicrom_en) {
                return this.basic_rom[addr - 32768] & 0xFF;
            }
            return this.mainram_b[addr - 32768] & 0xFF;
        }
        if (addr < 64640) {
            return this.mainram_b[addr - 32768] & 0xFF;
        }
        if (addr < 64768) {
            if (Mainmem.subctrl.subhalt_flag) {
                return Mainmem.subctrl.shared_ram[addr - 64640] & 0xFF;
            }
            return 255;
        }
        if (addr >= 65534 && this.initrom_en) {
            return this.init_rom[addr - 57344] & 0xFF;
        }
        if (addr >= 65024) {
            return this.boot_ram[addr - 65024] & 0xFF;
        }
        return this.main_io[addr - 64768] & 0xFF;
    }

    @Override
    public void writeb(int addr, int dat) {
        addr &= 0xFFFF;
        dat &= 0xFF;
        if (Mainmem.mmr.mmr_flag || Mainmem.mmr.twr_flag) {
            IntHolder _addr = this.waddr;
            this.waddr.value = addr;
            if (mmr.extwb(_addr, dat)) {
                return;
            }
            addr = _addr.value;
        }
        if (addr < 24576) {
            this.mainram_a[addr] = (byte)dat;
            return;
        }
        if (addr < 32768) {
            if (!this.initrom_en) {
                this.mainram_a[addr] = (byte)dat;
            }
            return;
        }
        if (addr < 64512) {
            if (this.basicrom_en) {
                return;
            }
            this.mainram_b[addr - 32768] = (byte)dat;
            return;
        }
        if (addr < 64640) {
            this.mainram_b[addr - 32768] = (byte)dat;
            return;
        }
        if (addr < 64768) {
            if (Mainmem.subctrl.subhalt_flag) {
                Mainmem.subctrl.shared_ram[addr - 64640] = (byte)dat;
                return;
            }
            return;
        }
        if (addr >= 65024) {
            if (this.bootram_rw && Mainmem.vm.fm7_ver >= 2) {
                this.boot_ram[addr - 65024] = (byte)dat;
                if (addr <= 65503 || addr >= 65534) {
                    this.iowait();
                }
                return;
            }
            if (addr >= 65504 && addr < 65534) {
                this.boot_ram[addr - 65024] = (byte)dat;
            }
            return;
        }
        this.main_io[addr - 64768] = (byte)dat;
        this.iowait();
        if (mainetc.writeb(addr, dat)) {
            return;
        }
        if (ttlpalet.writeb(addr, dat)) {
            return;
        }
        if (subctrl.writeb(addr, dat)) {
            return;
        }
        if (multipag.writeb(addr, dat)) {
            return;
        }
        if (fdc.writeb(addr, dat)) {
            return;
        }
        if (kanji.writeb(addr, dat)) {
            return;
        }
        if (tapelp.writeb(addr, dat)) {
            return;
        }
        if (opn.writeb(addr, dat)) {
            return;
        }
        if (whg.writeb(addr, dat)) {
            return;
        }
        if (thg.writeb(addr, dat)) {
            return;
        }
        if (mmr.writeb(addr, dat)) {
            return;
        }
        if (apalet.writeb(addr, dat)) {
            return;
        }
        if (dmac.writeb(addr, dat)) {
            return;
        }
    }

    int basic_rom(int addr) {
        return this.basic_rom[addr];
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.write(fileh, this.mainram_a, 32768)) {
            return false;
        }
        if (!File.write(fileh, this.mainram_b, 31872)) {
            return false;
        }
        if (!File.write(fileh, this.main_io, 256)) {
            return false;
        }
        if (!File.write(fileh, this.extram_a, 32768)) {
            return false;
        }
        if (!File.write(fileh, this.extram_a, 32768, 32768)) {
            return false;
        }
        if (!File.write(fileh, this.boot_ram, 512)) {
            return false;
        }
        if (!File.bool_write(fileh, this.basicrom_en)) {
            return false;
        }
        if (!File.bool_write(fileh, this.initrom_en)) {
            return false;
        }
        if (!File.bool_write(fileh, this.bootram_rw)) {
            return false;
        }
        return File.write(fileh, this.init_rom, 2830, 3);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                if (ver < 200) {
                                    return false;
                                }
                                try {
                                    if (File.read(fileh, this.mainram_a, 32768)) break block9;
                                    return false;
                                }
                                catch (IOException e) {
                                    return false;
                                }
                            }
                            if (File.read(fileh, this.mainram_b, 31872)) break block10;
                            return false;
                        }
                        if (File.read(fileh, this.main_io, 256)) break block11;
                        return false;
                    }
                    if (File.read(fileh, this.extram_a, 32768)) break block12;
                    return false;
                }
                if (File.read(fileh, this.extram_a, 32768, 32768)) break block13;
                return false;
            }
            if (File.read(fileh, this.boot_ram, 512)) break block14;
            return false;
        }
        this.basicrom_en = File.bool_read(fileh);
        this.initrom_en = File.bool_read(fileh);
        this.bootram_rw = File.bool_read(fileh);
        return ver < 800 || File.read(fileh, this.init_rom, 2830, 3);
    }
}

