/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Mmr
extends Base {
    boolean mmr_flag;
    int mmr_seg;
    boolean mmr_modify;
    private int[] mmr_reg = new int[128];
    boolean twr_flag;
    private int twr_reg;
    private boolean mmr_ext;
    boolean mmr_fastmode;
    public boolean mmr_extram;
    boolean mmr_fast_refresh;
    private int mr2_nowcnt;
    private int mr2_secreg;
    private IntHolder waddr = new IntHolder();

    Mmr() {
    }

    boolean init() {
        this.mmr_extram = false;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        this.mmr_flag = false;
        this.twr_flag = false;
        Util.memset(this.mmr_reg, 0, this.mmr_reg.length);
        this.mmr_seg = 0;
        this.twr_reg = 0;
        this.mmr_modify = false;
        this.mmr_ext = false;
        this.mmr_fastmode = false;
        this.mmr_fast_refresh = false;
        this.mr2_nowcnt = 0;
        this.mr2_secreg = 0;
    }

    private boolean trans_twr(int addr, IntHolder taddr) {
        if (!this.twr_flag) {
            return false;
        }
        if (addr < 31744 || addr > Short.MAX_VALUE) {
            return false;
        }
        taddr.value = this.twr_reg;
        taddr.value *= 256;
        taddr.value += addr;
        taddr.value &= 0xFFFF;
        return true;
    }

    private int trans_mmr(IntHolder addr) {
        if (!this.mmr_flag) {
            return 0x30000 | addr.value;
        }
        int offset = addr.value;
        offset >>= 12;
        offset = this.mmr_ext ? (offset |= this.mmr_seg * 16) : (offset |= (this.mmr_seg & 3) * 16);
        int maddr = this.mmr_reg[offset];
        if (!this.mmr_ext) {
            maddr &= 0x3F;
        }
        maddr <<= 12;
        addr.value &= 0xFFF;
        return maddr |= addr.value;
    }

    boolean extrb(IntHolder addr, IntHolder dat) {
        int rsegment;
        if (addr.value >= 64512) {
            return false;
        }
        IntHolder raddr = this.waddr;
        if (!this.trans_twr(addr.value, raddr)) {
            raddr.value = this.trans_mmr(addr);
        }
        if ((rsegment = raddr.value & 0xF0000) == 196608) {
            if (raddr.value >= 261504 && raddr.value <= 261527) {
                dat.value = 255;
                return true;
            }
            addr.value = raddr.value & 0xFFFF;
            return false;
        }
        if (rsegment == 0) {
            dat.value = Mmr.mainmem.extram_a[raddr.value & 0xFFFF] & 0xFF;
            return true;
        }
        if (rsegment == 65536) {
            dat.value = Mmr.subctrl.subhalt_flag ? submem.readb(raddr.value & 0xFFFF) : 255;
            return true;
        }
        if (rsegment == 131072) {
            dat.value = jcard.readb(raddr.value & 0xFFFF);
            return true;
        }
        if (rsegment >= 262144) {
            dat.value = this.mmr_extram ? Mmr.mainmem.extram_c[raddr.value - 262144] & 0xFF : 255;
            return true;
        }
        return false;
    }

    boolean extbnio(IntHolder addr, IntHolder dat) {
        int rsegment;
        if (addr.value >= 64512) {
            return false;
        }
        IntHolder raddr = this.waddr;
        if (!this.trans_twr(addr.value, raddr)) {
            raddr.value = this.trans_mmr(addr);
        }
        if ((rsegment = raddr.value & 0xF0000) == 196608) {
            if (raddr.value >= 261504 && raddr.value <= 261525) {
                dat.value = 255;
                return true;
            }
            addr.value = raddr.value & 0xFFFF;
            return false;
        }
        if (rsegment == 0) {
            dat.value = Mmr.mainmem.extram_a[raddr.value & 0xFFFF] & 0xFF;
            return true;
        }
        if (rsegment == 65536) {
            dat.value = Mmr.subctrl.subhalt_flag ? submem.readbnio(raddr.value & 0xFFFF) : 255;
            return true;
        }
        if (rsegment == 131072) {
            dat.value = jcard.readb(raddr.value & 0xFFFF);
            return true;
        }
        if (rsegment >= 262144) {
            dat.value = this.mmr_extram ? Mmr.mainmem.extram_c[raddr.value - 262144] & 0xFF : 255;
            return true;
        }
        return false;
    }

    boolean extwb(IntHolder addr, int dat) {
        int rsegment;
        if (addr.value >= 64512) {
            return false;
        }
        IntHolder raddr = this.waddr;
        if (!this.trans_twr(addr.value, raddr)) {
            raddr.value = this.trans_mmr(addr);
        }
        if ((rsegment = raddr.value & 0xF0000) == 196608) {
            if (raddr.value >= 261504 && raddr.value <= 261525) {
                return true;
            }
            addr.value = raddr.value & 0xFFFF;
            return false;
        }
        if (rsegment == 0) {
            Mmr.mainmem.extram_a[raddr.value & 0xFFFF] = (byte)dat;
            return true;
        }
        if (rsegment == 65536) {
            if (Mmr.subctrl.subhalt_flag) {
                submem.writeb(raddr.value & 0xFFFF, dat);
            }
            return true;
        }
        if (rsegment == 131072) {
            jcard.writeb(raddr.value & 0xFFFF, dat);
            return true;
        }
        if (rsegment >= 262144) {
            if (this.mmr_extram) {
                Mmr.mainmem.extram_c[raddr.value - 262144] = (byte)dat;
            }
            return true;
        }
        return false;
    }

    private int mr2_address() {
        int tmp;
        if (this.mr2_secreg <= 3071) {
            tmp = 3071 - this.mr2_secreg << 8;
            tmp |= this.mr2_nowcnt;
        } else {
            tmp = 0;
        }
        return tmp;
    }

    private int mr2_read_data() {
        int dat;
        if (this.mr2_secreg <= 3071) {
            dat = Mmr.mainmem.extram_c[this.mr2_address()] & 0xFF;
            ++this.mr2_nowcnt;
        } else {
            dat = 255;
        }
        return dat;
    }

    private void mr2_write_data(int dat) {
        if (this.mr2_secreg <= 3071) {
            Mmr.mainmem.extram_c[this.mr2_address()] = (byte)dat;
            ++this.mr2_nowcnt;
        }
    }

    private void mr2_update_sector(int addr, int dat) {
        if (addr == 64926) {
            this.mr2_secreg &= 0xFF;
            this.mr2_secreg |= (dat & 0xF) << 8;
        } else {
            this.mr2_secreg &= 0xF00;
            this.mr2_secreg |= dat;
        }
        if (this.mr2_secreg >= 3072) {
            this.mr2_secreg = 3072;
        }
        this.mr2_nowcnt = 0;
    }

    boolean readb(int addr, IntHolder dat) {
        if (Mmr.vm.fm7_ver < 2) {
            return false;
        }
        switch (addr) {
            case 64779: {
                dat.value = Mmr.vm.boot_mode == 0 ? 254 : 255;
                return true;
            }
            case 64784: {
                dat.value = 255;
                return true;
            }
            case 64912: {
                dat.value = 255;
                return true;
            }
            case 64914: {
                dat.value = 255;
                return true;
            }
            case 64915: {
                int tmp = 255;
                if (!this.mmr_flag) {
                    tmp &= 0xFFFFFF7F;
                }
                if (!this.twr_flag) {
                    tmp &= 0xFFFFFFBF;
                }
                if (!Mmr.mainmem.bootram_rw) {
                    tmp &= 0xFFFFFFFE;
                }
                dat.value = tmp;
                return true;
            }
            case 64916: {
                dat.value = 255;
                return true;
            }
            case 64917: {
                int tmp = 255;
                if (Mmr.vm.fm7_ver >= 3) {
                    if (Mmr.jcard.extrom_sel) {
                        tmp &= 0xFFFFFF7F;
                    }
                    if (!this.mmr_fastmode) {
                        tmp &= 0xFFFFFFF7;
                    }
                }
                dat.value = tmp;
                return true;
            }
            case 64924: {
                dat.value = this.mmr_extram ? this.mr2_read_data() : 255;
                return true;
            }
            case 64926: 
            case 64927: {
                dat.value = 255;
                return true;
            }
        }
        if (addr >= 64896 && addr <= 64911) {
            int tmp;
            if (this.mmr_ext) {
                tmp = this.mmr_reg[this.mmr_seg * 16 + (addr - 64896)];
            } else {
                tmp = this.mmr_reg[(this.mmr_seg & 3) * 16 + (addr - 64896)];
                tmp &= 0x3F;
            }
            dat.value = tmp;
            return true;
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        if (Mmr.vm.fm7_ver < 2) {
            return false;
        }
        switch (addr) {
            case 64779: {
                return true;
            }
            case 64784: {
                Mmr.mainmem.initrom_en = (dat & 2) == 0;
                return true;
            }
            case 64912: {
                this.mmr_seg = dat & 7;
                return true;
            }
            case 64914: {
                this.twr_reg = dat;
                return true;
            }
            case 64915: {
                if ((dat & 0x80) != 0) {
                    if (!this.mmr_flag) {
                        this.mmr_flag = true;
                        if (!this.mmr_fastmode) {
                            this.mmr_modify = true;
                        }
                    }
                } else if (this.mmr_flag) {
                    this.mmr_flag = false;
                    if (!this.mmr_fastmode) {
                        this.mmr_modify = true;
                    }
                }
                if ((dat & 0x40) != 0) {
                    if (!this.twr_flag) {
                        this.twr_flag = true;
                        if (!this.mmr_fastmode) {
                            this.mmr_modify = true;
                        }
                    }
                } else if (this.twr_flag) {
                    this.twr_flag = false;
                    if (!this.mmr_fastmode) {
                        this.mmr_modify = true;
                    }
                }
                Mmr.mainmem.bootram_rw = (dat & 1) != 0;
                return true;
            }
            case 64916: {
                if (Mmr.vm.fm7_ver >= 3) {
                    this.mmr_ext = (dat & 0x80) != 0;
                    if ((dat & 4) != 0) {
                        if (!this.mmr_fast_refresh) {
                            this.mmr_fast_refresh = true;
                            if (!this.mmr_fastmode) {
                                this.mmr_modify = true;
                            }
                        }
                    } else if (this.mmr_fast_refresh) {
                        this.mmr_fast_refresh = false;
                        if (!this.mmr_fastmode) {
                            this.mmr_modify = true;
                        }
                    }
                }
                return true;
            }
            case 64917: {
                if (Mmr.vm.fm7_ver >= 3) {
                    Mmr.jcard.extrom_sel = (dat & 0x80) != 0;
                    if ((dat & 8) != 0) {
                        if (!this.mmr_fastmode) {
                            this.mmr_fastmode = true;
                            this.mmr_modify = true;
                        }
                    } else if (this.mmr_fastmode) {
                        this.mmr_fastmode = false;
                        this.mmr_modify = true;
                    }
                }
                return true;
            }
            case 64924: {
                if (this.mmr_extram) {
                    this.mr2_write_data(dat);
                }
                return true;
            }
            case 64926: 
            case 64927: {
                this.mr2_update_sector(addr, dat);
                return true;
            }
        }
        if (addr >= 64896 && addr <= 64911) {
            if (this.mmr_ext) {
                this.mmr_reg[this.mmr_seg * 16 + (addr - 64896)] = dat;
            } else {
                this.mmr_reg[(this.mmr_seg & 3) * 16 + (addr - 64896)] = dat;
            }
            return true;
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.mmr_flag)) {
            return false;
        }
        if (!File.byte_write(fileh, this.mmr_seg)) {
            return false;
        }
        if (!File.write(fileh, this.mmr_reg, 128)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mmr_ext)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mmr_fastmode)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mmr_extram)) {
            return false;
        }
        if (this.mmr_extram && !File.write(fileh, Mmr.mainmem.extram_c, 786432)) {
            return false;
        }
        if (!File.byte_write(fileh, this.mr2_nowcnt)) {
            return false;
        }
        if (!File.word_write(fileh, this.mr2_secreg)) {
            return false;
        }
        if (!File.bool_write(fileh, this.twr_flag)) {
            return false;
        }
        return File.byte_write(fileh, this.twr_reg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.mmr_flag = File.bool_read(fileh);
            this.mmr_seg = File.byte_read(fileh);
            if (ver >= 800) {
                File.read(fileh, this.mmr_reg, 128);
                this.mmr_ext = File.bool_read(fileh);
                this.mmr_fastmode = File.bool_read(fileh);
                this.mmr_extram = File.bool_read(fileh);
                if (this.mmr_extram) {
                    File.read(fileh, Mmr.mainmem.extram_c, 786432);
                }
                if (ver >= 902) {
                    this.mr2_nowcnt = File.byte_read(fileh);
                    this.mr2_secreg = File.word_read(fileh);
                } else {
                    this.mr2_nowcnt = 0;
                    this.mr2_secreg = 0;
                }
            } else {
                if (!File.read(fileh, this.mmr_reg, 64)) {
                    return false;
                }
                this.mmr_ext = false;
                this.mmr_fastmode = false;
                this.mmr_extram = false;
                this.mr2_nowcnt = 0;
                this.mr2_secreg = 0;
            }
            this.twr_flag = File.bool_read(fileh);
            this.twr_reg = File.byte_read(fileh);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

