/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Schedule
extends Base {
    private boolean break_flag;
    public boolean run_flag;
    public boolean stopreq_flag;
    private event_t[] event = new event_t[20];
    private breakp_t[] breakp = new breakp_t[16];
    private int main_runadr;
    private int sub_runadr;
    public int main_speed;
    public int mmr_speed;
    public int fmmr_speed;
    public int sub_speed;
    private int main_overcycles;
    private int sub_overcycles;
    public boolean cycle_steal;
    public int speed_ratio;
    public int vmtime;

    Schedule() {
    }

    boolean init() {
        this.run_flag = false;
        this.stopreq_flag = false;
        this.break_flag = false;
        int i = 0;
        while (i < this.breakp.length) {
            this.breakp[i] = new breakp_t();
            this.breakp[i].init();
            ++i;
        }
        i = 0;
        while (i < this.event.length) {
            this.event[i] = new event_t();
            this.event[i].init();
            ++i;
        }
        this.main_runadr = 65535;
        this.sub_runadr = 65535;
        this.main_speed = 17990;
        this.mmr_speed = 15650;
        this.fmmr_speed = 20160;
        this.sub_speed = 19980;
        this.cycle_steal = true;
        this.main_overcycles = 0;
        this.sub_overcycles = 0;
        this.vmtime = 0;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        int i = 0;
        while (i < 20) {
            if (i != 9) {
                this.event[i].init();
            }
            ++i;
        }
        Schedule.maincpu.total = 0;
        Schedule.subcpu.total = 0;
        this.main_overcycles = 0;
        this.sub_overcycles = 0;
        this.vmtime = 0;
        this.speed_ratio = 10000;
    }

    private int get_cycle() {
        int tmp = Schedule.mmr.mmr_fastmode ? this.fmmr_speed : (Schedule.mmr.mmr_flag || Schedule.mmr.twr_flag ? this.mmr_speed : this.main_speed);
        if (!Schedule.mmr.mmr_fastmode && Schedule.mmr.mmr_fast_refresh) {
            tmp = Schedule.mmr.mmr_flag || Schedule.mmr.twr_flag ? tmp * 4461 >> 12 : tmp * 4447 >> 12;
        }
        if (this.speed_ratio != 10000 && (tmp = tmp * this.speed_ratio / 10000) < 1) {
            tmp = 1;
        }
        return tmp;
    }

    boolean setevent(int id, int microsec, EventHandler callback, int callbackid) {
        if (id < 0 || id >= 20) {
            return false;
        }
        event_t e = this.event[id];
        if (microsec == 0) {
            e.flag = 0;
            return false;
        }
        e.current = microsec;
        e.reload = microsec;
        e.callback = callback;
        e.callbackid = callbackid;
        e.flag = 1;
        if (this.run_flag) {
            int exec = Schedule.maincpu.total;
            exec *= 10000;
            e.current += (exec /= this.get_cycle());
        }
        return true;
    }

    boolean delevent(int id) {
        if (id < 0 || id >= 20) {
            return false;
        }
        this.event[id].flag = 0;
        return true;
    }

    void handle(int id, EventHandler callback, int callbackid) {
        event_t e = this.event[id];
        e.callback = callback;
        e.callbackid = callbackid;
    }

    private int chkevent(int microsec) {
        int exectime = microsec;
        int i = 0;
        while (i < 20) {
            event_t e = this.event[i];
            if (e.flag != 0 && e.current < exectime) {
                exectime = e.current;
            }
            ++i;
        }
        return exectime;
    }

    private void doevent(int microsec) {
        int i = 0;
        while (i < 20) {
            event_t e = this.event[i];
            if (e.flag != 0) {
                e.current = e.current < microsec ? 0 : (e.current -= microsec);
                if (e.current == 0) {
                    e.current = e.reload;
                    if (e.flag == 1 && !e.callback.event(e.callbackid)) {
                        e.flag = 2;
                    }
                }
            }
            ++i;
        }
    }

    int get_reload(int id) {
        return this.event[id].reload;
    }

    void set_flag(int id, int flag) {
        this.event[id].flag = flag;
    }

    public boolean setbreak(int cpu, int addr) {
        int i = 0;
        while (i < 16) {
            if (this.breakp[i].flag != 0 && this.breakp[i].cpu == cpu && this.breakp[i].addr == addr) break;
            ++i;
        }
        if (i != 16) {
            this.breakp[i].flag = 0;
            this.break_flag = false;
            i = 0;
            while (i < 16) {
                if (this.breakp[i].flag != 0) {
                    this.break_flag = true;
                }
                ++i;
            }
            return true;
        }
        i = 0;
        while (i < 16) {
            if (this.breakp[i].flag == 0) break;
            ++i;
        }
        if (i == 16) {
            return false;
        }
        this.breakp[i].flag = 1;
        this.breakp[i].cpu = cpu;
        this.breakp[i].addr = addr;
        this.break_flag = true;
        return true;
    }

    public boolean setbreak2(int num, int cpu, int addr) {
        if (this.breakp[num].flag != 2) {
            this.breakp[num].flag = 1;
        }
        this.breakp[num].cpu = cpu;
        this.breakp[num].addr = addr;
        this.break_flag = true;
        return true;
    }

    private boolean chkbreak() {
        int main_prevrunadr = this.main_runadr;
        int sub_prevrunadr = this.sub_runadr;
        this.main_runadr = maincpu.getPc();
        this.sub_runadr = subcpu.getPc();
        int i = 0;
        while (i < 16) {
            if (this.breakp[i].flag == 1 && (this.breakp[i].cpu == 0 ? this.breakp[i].addr == maincpu.getPc() && maincpu.getPc() != main_prevrunadr : this.breakp[i].addr == subcpu.getPc() && subcpu.getPc() != sub_prevrunadr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void trace() {
        maincpu.execline();
        if (Schedule.tapelp.tape_motor) {
            Schedule.tapelp.tape_subcnt += Schedule.maincpu.cycle;
            if (Schedule.tapelp.tape_subcnt >= 16) {
                Schedule.tapelp.tape_subcnt -= 16;
                ++Schedule.tapelp.tape_count;
                if (Schedule.tapelp.tape_count == 0) {
                    Schedule.tapelp.tape_count = 65535;
                }
            }
        }
        if (!Schedule.subctrl.subhalt_flag && (this.cycle_steal || !Schedule.display.vrama_flag || Schedule.display.blank_flag)) {
            subcpu.execline();
        }
        subctrl.halt_ack();
        if (Schedule.dmac.dma_flag) {
            dmac.exec();
        }
        this.main_overcycles = 0;
        this.sub_overcycles = 0;
    }

    public void main_fullspeed() {
        if (this.break_flag) {
            if (this.chkbreak()) {
                this.stopreq_flag = true;
            }
            if (this.stopreq_flag) {
                return;
            }
        }
        if (!Schedule.fdc.fdc_waitmode || (Schedule.fdc.fdc_status & 1) == 0) {
            maincpu.exec();
            if (Schedule.tapelp.tape_motor) {
                Schedule.tapelp.tape_subcnt += Schedule.maincpu.cycle;
                if (Schedule.tapelp.tape_subcnt >= 16) {
                    Schedule.tapelp.tape_subcnt -= 16;
                    ++Schedule.tapelp.tape_count;
                    if (Schedule.tapelp.tape_count == 0) {
                        Schedule.tapelp.tape_count = 65535;
                    }
                }
            }
        }
        subctrl.halt_ack();
        this.main_overcycles = 0;
    }

    public void fullspeed() {
        if (this.break_flag) {
            if (this.chkbreak()) {
                this.stopreq_flag = true;
            }
            if (this.stopreq_flag) {
                return;
            }
        }
        if (!Schedule.fdc.fdc_waitmode || (Schedule.fdc.fdc_status & 1) == 0) {
            maincpu.exec();
            if (Schedule.tapelp.tape_motor) {
                Schedule.tapelp.tape_subcnt += Schedule.maincpu.cycle;
                if (Schedule.tapelp.tape_subcnt >= 16) {
                    Schedule.tapelp.tape_subcnt -= 16;
                    ++Schedule.tapelp.tape_count;
                    if (Schedule.tapelp.tape_count == 0) {
                        Schedule.tapelp.tape_count = 65535;
                    }
                }
            }
        }
        if (!Schedule.subctrl.subhalt_flag && (this.cycle_steal || !Schedule.display.vrama_flag || Schedule.display.blank_flag)) {
            subcpu.exec();
        }
        subctrl.halt_ack();
        this.main_overcycles = 0;
        this.sub_overcycles = 0;
    }

    /*
     * Unable to fully structure code
     */
    public int exec(int microsec) {
        exec = this.chkevent(microsec);
        exec2 = 0;
        do {
            block28: {
                block26: {
                    cycle = this.get_cycle();
                    tmp = this.sub_speed * this.speed_ratio / 100000;
                    if (tmp < 1) {
                        tmp = 1;
                    }
                    ratio = tmp << 12;
                    count = cycle;
                    count *= exec - exec2;
                    main = count /= 10000;
                    sub = main * (ratio /= cycle / 10) >> 12;
                    Schedule.maincpu.total = this.main_overcycles;
                    Schedule.subcpu.total = this.sub_overcycles;
                    Schedule.mmr.mmr_modify = false;
                    if (!this.cycle_steal) break block26;
                    if (!this.break_flag) ** GOTO lbl65
                    while (Schedule.maincpu.total < main && !Schedule.mmr.mmr_modify) {
                        block27: {
                            if (this.chkbreak()) {
                                this.stopreq_flag = true;
                            }
                            if (this.stopreq_flag) break;
                            Schedule.maincpu.exec();
                            if (Schedule.tapelp.tape_motor) {
                                Schedule.tapelp.tape_subcnt += Schedule.maincpu.cycle;
                                if (Schedule.tapelp.tape_subcnt >= 16) {
                                    Schedule.tapelp.tape_subcnt -= 16;
                                    ++Schedule.tapelp.tape_count;
                                    if (Schedule.tapelp.tape_count == 0) {
                                        Schedule.tapelp.tape_count = 65535;
                                    }
                                }
                            }
                            limit = Schedule.maincpu.total * ratio;
                            if (!Schedule.subctrl.subhalt_flag) ** GOTO lbl38
                            Schedule.subcpu.total = limit >> 12;
                            break block27;
lbl-1000:
                            // 1 sources

                            {
                                if (this.chkbreak()) {
                                    this.stopreq_flag = true;
                                }
                                if (this.stopreq_flag) break;
                                Schedule.subcpu.exec();
lbl38:
                                // 2 sources

                                ** while (Schedule.subcpu.total << 12 < limit)
                            }
                        }
                        Schedule.subctrl.halt_ack();
                        if (!Schedule.dmac.dma_flag) continue;
                        Schedule.dmac.exec();
                    }
                    if (!this.stopreq_flag) break block28;
                    this.run_flag = false;
                    break block28;
lbl-1000:
                    // 1 sources

                    {
                        block29: {
                            Schedule.maincpu.exec();
                            if (Schedule.tapelp.tape_motor) {
                                Schedule.tapelp.tape_subcnt += Schedule.maincpu.cycle;
                                if (Schedule.tapelp.tape_subcnt >= 16) {
                                    Schedule.tapelp.tape_subcnt -= 16;
                                    ++Schedule.tapelp.tape_count;
                                    if (Schedule.tapelp.tape_count == 0) {
                                        Schedule.tapelp.tape_count = 65535;
                                    }
                                }
                            }
                            limit = Schedule.maincpu.total * ratio;
                            if (!Schedule.subctrl.subhalt_flag) ** GOTO lbl60
                            Schedule.subcpu.total = limit >> 12;
                            break block29;
lbl-1000:
                            // 1 sources

                            {
                                Schedule.subcpu.exec();
lbl60:
                                // 2 sources

                                ** while (Schedule.subcpu.total << 12 < limit)
                            }
                        }
                        Schedule.subctrl.halt_ack();
                        if (!Schedule.dmac.dma_flag) continue;
                        Schedule.dmac.exec();
lbl65:
                        // 3 sources

                        ** while (Schedule.maincpu.total < main && !Schedule.mmr.mmr_modify)
                    }
lbl66:
                    // 1 sources

                    break block28;
                }
                if (!this.break_flag) ** GOTO lbl116
                while (Schedule.maincpu.total < main && !Schedule.mmr.mmr_modify) {
                    block30: {
                        if (this.chkbreak()) {
                            this.stopreq_flag = true;
                        }
                        if (this.stopreq_flag) break;
                        Schedule.maincpu.exec();
                        if (Schedule.tapelp.tape_motor) {
                            Schedule.tapelp.tape_subcnt += Schedule.maincpu.cycle;
                            if (Schedule.tapelp.tape_subcnt >= 16) {
                                Schedule.tapelp.tape_subcnt -= 16;
                                ++Schedule.tapelp.tape_count;
                                if (Schedule.tapelp.tape_count == 0) {
                                    Schedule.tapelp.tape_count = 65535;
                                }
                            }
                        }
                        limit = Schedule.maincpu.total * ratio;
                        if (!Schedule.subctrl.subhalt_flag && (!Schedule.display.vrama_flag || !Schedule.display.blank_flag)) ** GOTO lbl89
                        Schedule.subcpu.total = limit >> 12;
                        break block30;
lbl-1000:
                        // 1 sources

                        {
                            if (this.chkbreak()) {
                                this.stopreq_flag = true;
                            }
                            if (this.stopreq_flag) break;
                            Schedule.subcpu.exec();
lbl89:
                            // 2 sources

                            ** while (Schedule.subcpu.total << 12 < limit)
                        }
                    }
                    Schedule.subctrl.halt_ack();
                    if (!Schedule.dmac.dma_flag) continue;
                    Schedule.dmac.exec();
                }
                if (!this.stopreq_flag) break block28;
                this.run_flag = false;
                break block28;
lbl-1000:
                // 1 sources

                {
                    block31: {
                        Schedule.maincpu.exec();
                        if (Schedule.tapelp.tape_motor) {
                            Schedule.tapelp.tape_subcnt += Schedule.maincpu.cycle;
                            if (Schedule.tapelp.tape_subcnt >= 16) {
                                Schedule.tapelp.tape_subcnt -= 16;
                                ++Schedule.tapelp.tape_count;
                                if (Schedule.tapelp.tape_count == 0) {
                                    Schedule.tapelp.tape_count = 65535;
                                }
                            }
                        }
                        limit = Schedule.maincpu.total * ratio;
                        if (!Schedule.subctrl.subhalt_flag && (!Schedule.display.vrama_flag || !Schedule.display.blank_flag)) ** GOTO lbl111
                        Schedule.subcpu.total = limit >> 12;
                        break block31;
lbl-1000:
                        // 1 sources

                        {
                            Schedule.subcpu.exec();
lbl111:
                            // 2 sources

                            ** while (Schedule.subcpu.total << 12 < limit)
                        }
                    }
                    Schedule.subctrl.halt_ack();
                    if (!Schedule.dmac.dma_flag) continue;
                    Schedule.dmac.exec();
lbl116:
                    // 3 sources

                    ** while (Schedule.maincpu.total < main && !Schedule.mmr.mmr_modify)
                }
            }
            if (!Schedule.mmr.mmr_modify) continue;
            exec2 += Schedule.maincpu.total * 10000 / cycle;
            this.main_overcycles = 0;
            this.sub_overcycles = 0;
        } while (Schedule.mmr.mmr_modify && this.run_flag && exec > exec2);
        this.main_overcycles = Schedule.maincpu.total > main ? Schedule.maincpu.total - main : 0;
        this.sub_overcycles = Schedule.subcpu.total > sub ? Schedule.subcpu.total - sub : 0;
        Schedule.maincpu.total = 0;
        Schedule.subcpu.total = 0;
        this.doevent(exec);
        this.vmtime += exec;
        return exec;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.run_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.stopreq_flag)) {
            return false;
        }
        if (!File.byte_write(fileh, 16)) {
            return false;
        }
        int i = 0;
        while (i < 16) {
            if (!File.byte_write(fileh, this.breakp[i].flag)) {
                return false;
            }
            if (!File.byte_write(fileh, this.breakp[i].cpu)) {
                return false;
            }
            if (!File.word_write(fileh, this.breakp[i].addr)) {
                return false;
            }
            ++i;
        }
        if (!File.byte_write(fileh, 20)) {
            return false;
        }
        i = 0;
        while (i < 20) {
            if (!File.byte_write(fileh, this.event[i].flag)) {
                return false;
            }
            if (!File.dword_write(fileh, this.event[i].current)) {
                return false;
            }
            if (!File.dword_write(fileh, this.event[i].reload)) {
                return false;
            }
            ++i;
        }
        if (!File.word_write(fileh, this.main_overcycles)) {
            return false;
        }
        return File.word_write(fileh, this.sub_overcycles);
    }

    boolean load(RandomAccessFile fileh, int ver, boolean old) {
        int tmp = 0;
        int MAXNUM = 0;
        if (ver < 200) {
            return false;
        }
        try {
            this.run_flag = File.bool_read(fileh);
            this.stopreq_flag = File.bool_read(fileh);
            MAXNUM = ver >= 901 || ver >= 701 && ver <= 799 ? File.byte_read(fileh) : 8;
            int j = 0;
            while (j < this.breakp.length) {
                this.breakp[j].init();
                ++j;
            }
            int i = 0;
            while (i < MAXNUM) {
                this.breakp[i].flag = tmp = File.byte_read(fileh);
                this.breakp[i].cpu = tmp = File.byte_read(fileh);
                this.breakp[i].addr = File.word_read(fileh);
                ++i;
            }
            this.break_flag = false;
            i = 0;
            while (i < MAXNUM) {
                if (this.breakp[i].flag != 0) {
                    this.break_flag = true;
                }
                ++i;
            }
            MAXNUM = ver >= 900 || ver >= 700 && ver <= 799 ? File.byte_read(fileh) : (old ? 16 : 18);
            i = 0;
            while (i < MAXNUM) {
                this.event[i].flag = tmp = File.byte_read(fileh);
                this.event[i].current = File.dword_read(fileh);
                this.event[i].reload = File.dword_read(fileh);
                ++i;
            }
            if (ver >= 905 || ver >= 705 && ver <= 799) {
                this.main_overcycles = File.word_read(fileh);
                this.sub_overcycles = File.word_read(fileh);
            } else {
                this.main_overcycles = 0;
                this.sub_overcycles = 0;
            }
            this.speed_ratio = 10000;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private final class breakp_t {
        int flag;
        int cpu;
        int addr;

        private breakp_t() {
        }

        void init() {
            this.flag = 0;
            this.cpu = 0;
            this.addr = 0;
        }
    }

    private final class event_t {
        int flag;
        int current;
        int reload;
        EventHandler callback;
        int callbackid;

        private event_t() {
        }

        void init() {
            this.flag = 0;
            this.current = 0;
            this.reload = 0;
        }
    }
}

