/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Memory;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Submem
extends Base
implements Memory {
    public byte[] vram_c;
    public byte[] subrom_c;
    private byte[] sub_ram;
    private byte[] sub_io;
    private byte[] subramde;
    private byte[] subramcg;
    private byte[] subramcn;
    private byte[] subrom_a;
    private byte[] subrom_b;
    private byte[] subromcg;
    int subrom_bank;
    int cgrom_bank;
    int cgram_bank;
    int consram_bank;
    private IntHolder wdat = new IntHolder();

    Submem() {
    }

    boolean init() {
        this.vram_c = null;
        this.subrom_c = null;
        this.subrom_a = null;
        this.subrom_b = null;
        this.subromcg = null;
        this.sub_ram = null;
        this.sub_io = null;
        this.subramde = null;
        this.subramcg = null;
        this.subramcn = null;
        this.vram_c = Util.malloc(196608);
        if (this.vram_c == null) {
            return false;
        }
        this.subrom_c = Util.malloc(10240);
        if (this.subrom_c == null) {
            return false;
        }
        this.subrom_a = Util.malloc(8192);
        if (this.subrom_a == null) {
            return false;
        }
        this.subrom_b = Util.malloc(8192);
        if (this.subrom_b == null) {
            return false;
        }
        this.subromcg = Util.malloc(8192);
        if (this.subromcg == null) {
            return false;
        }
        this.subramcn = Util.malloc(8192);
        if (this.subramcn == null) {
            return false;
        }
        this.subramcg = Util.malloc(16384);
        if (this.subramcg == null) {
            return false;
        }
        this.subramde = Util.malloc(8192);
        if (this.subramde == null) {
            return false;
        }
        this.sub_ram = Util.malloc(5760);
        if (this.sub_ram == null) {
            return false;
        }
        this.sub_io = Util.malloc(256);
        if (this.sub_io == null) {
            return false;
        }
        if (!File.load("SUBSYS_C.ROM", this.subrom_c, 10240)) {
            return false;
        }
        if (!File.load("SUBSYS_A.ROM", this.subrom_a, 8192)) {
            return false;
        }
        if (!File.load("SUBSYS_B.ROM", this.subrom_b, 8192)) {
            return false;
        }
        return File.load("SUBSYSCG.ROM", this.subromcg, 8192);
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        if (this.vram_c != null) {
            Util.free(this.vram_c);
        }
        if (this.subrom_c != null) {
            Util.free(this.subrom_c);
        }
        if (this.subrom_a != null) {
            Util.free(this.subrom_a);
        }
        if (this.subrom_b != null) {
            Util.free(this.subrom_b);
        }
        if (this.subromcg != null) {
            Util.free(this.subromcg);
        }
        if (this.subramcn != null) {
            Util.free(this.subramcn);
        }
        if (this.subramcg != null) {
            Util.free(this.subramcg);
        }
        if (this.subramde != null) {
            Util.free(this.subramde);
        }
        if (this.sub_ram != null) {
            Util.free(this.sub_ram);
        }
        if (this.sub_io != null) {
            Util.free(this.sub_io);
        }
    }

    void reset() {
        Submem.display.vram_aptr_v = this.vram_c;
        Submem.display.vram_aptr_p = 0;
        Submem.display.vram_active = 0;
        this.subrom_bank = 0;
        this.cgrom_bank = 0;
        this.cgram_bank = 0;
        this.consram_bank = 0;
        Util.memset(this.sub_io, (byte)-1, Util.sizeof(this.sub_io));
    }

    @Override
    public int readb(int addr) {
        if ((addr &= 0xFFFF) < 49152) {
            if (Submem.subctrl.mode400l) {
                if (addr >= 32768) {
                    return 255;
                }
                aluline.extrb(addr);
                if ((Submem.multipag.multi_page & 1 << Submem.display.subram_vrambank) != 0) {
                    return 255;
                }
                return Submem.display.vram_aptr_v[Submem.display.vram_aptr_p] & 0xFF;
            }
            aluline.extrb(addr);
            if ((Submem.multipag.multi_page & 1 << (addr >> 14)) != 0) {
                return 255;
            }
            return Submem.display.vram_aptr_v[Submem.display.vram_aptr_p + ((addr & 0xC000) << 1) | addr & 0x3FFF] & 0xFF;
        }
        if (addr < 53248 && this.subrom_bank == 4 && this.consram_bank >= 1) {
            return this.subramcn[(this.consram_bank - 1) * 4096 + (addr - 49152)] & 0xFF;
        }
        if (addr < 54144) {
            return this.sub_ram[addr - 49152] & 0xFF;
        }
        if (addr < 54272) {
            return Submem.subctrl.shared_ram[addr - 54144] & 0xFF;
        }
        if (addr >= 57344) {
            switch (this.subrom_bank) {
                case 0: {
                    return this.subrom_c[addr - 55296] & 0xFF;
                }
                case 1: {
                    return this.subrom_a[addr - 57344] & 0xFF;
                }
                case 2: {
                    return this.subrom_b[addr - 57344] & 0xFF;
                }
                case 3: {
                    return this.subromcg[addr - 57344] & 0xFF;
                }
                case 4: {
                    return this.subramde[addr - 57344] & 0xFF;
                }
            }
        }
        if (addr >= 55296) {
            if (this.subrom_bank == 4) {
                return this.subramcg[this.cgram_bank * 2048 + (addr - 55296)] & 0xFF;
            }
            return this.subromcg[this.cgrom_bank * 2048 + (addr - 55296)] & 0xFF;
        }
        if (addr >= 54528) {
            return this.sub_ram[addr - 54528 + 4992] & 0xFF;
        }
        if (display.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (keyboard.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        if (aluline.readb(addr, this.wdat)) {
            return this.wdat.value;
        }
        return 255;
    }

    @Override
    public int readbnio(int addr) {
        if ((addr &= 0xFFFF) < 49152) {
            if (Submem.subctrl.mode400l) {
                if (addr < 32768) {
                    return Submem.display.vram_aptr_v[Submem.display.vram_aptr_p + addr] & 0xFF;
                }
                return 255;
            }
            return Submem.display.vram_aptr_v[Submem.display.vram_aptr_p + ((addr & 0xC000) << 1) | addr & 0x3FFF] & 0xFF;
        }
        if (addr < 53248 && this.subrom_bank == 4 && this.consram_bank >= 1) {
            return this.subramcn[(this.consram_bank - 1) * 4096 + (addr - 49152)] & 0xFF;
        }
        if (addr < 54144) {
            return this.sub_ram[addr - 49152] & 0xFF;
        }
        if (addr < 54272) {
            return Submem.subctrl.shared_ram[addr - 54144] & 0xFF;
        }
        if (addr < 54528) {
            return this.sub_io[addr - 54272] & 0xFF;
        }
        if (addr < 55296) {
            return this.sub_ram[addr - 54528 + 4992] & 0xFF;
        }
        if (addr >= 57344) {
            switch (this.subrom_bank) {
                case 0: {
                    return this.subrom_c[addr - 55296] & 0xFF;
                }
                case 1: {
                    return this.subrom_a[addr - 57344] & 0xFF;
                }
                case 2: {
                    return this.subrom_b[addr - 57344] & 0xFF;
                }
                case 3: {
                    return this.subromcg[addr - 57344] & 0xFF;
                }
                case 4: {
                    return this.subramde[addr - 57344] & 0xFF;
                }
            }
        }
        if (addr >= 55296) {
            if (this.subrom_bank == 4) {
                return this.subramcg[this.cgram_bank * 2048 + (addr - 55296)] & 0xFF;
            }
            return this.subromcg[this.cgrom_bank * 2048 + (addr - 55296)] & 0xFF;
        }
        return 0;
    }

    @Override
    public void writeb(int addr, int dat) {
        dat &= 0xFF;
        if ((addr &= 0xFFFF) < 49152) {
            if (Submem.subctrl.mode400l) {
                if (addr >= 32768) {
                    return;
                }
                if ((Submem.aluline.alu_command & 0x80) != 0) {
                    aluline.extrb(addr);
                    return;
                }
                if ((Submem.multipag.multi_page & 1 << Submem.display.subram_vrambank) == 0 && Submem.display.vram_aptr_v[Submem.display.vram_aptr_p + addr] != (byte)dat) {
                    Submem.display.vram_aptr_v[Submem.display.vram_aptr_p + addr] = (byte)dat;
                    Submem.sysmain.sys_dsp.vram_notify(addr, dat);
                }
            } else {
                if ((Submem.aluline.alu_command & 0x80) != 0) {
                    aluline.extrb(addr);
                    return;
                }
                if ((Submem.multipag.multi_page & 1 << (addr >> 14)) == 0 && Submem.display.vram_aptr_v[Submem.display.vram_aptr_p + ((addr & 0xC000) << 1) | addr & 0x3FFF] != (byte)dat) {
                    Submem.display.vram_aptr_v[Submem.display.vram_aptr_p + ((addr & 0xC000) << 1) | addr & 0x3FFF] = (byte)dat;
                    Submem.sysmain.sys_dsp.vram_notify(addr, dat);
                }
            }
            return;
        }
        if (addr < 53248 && this.subrom_bank == 4 && this.consram_bank >= 1) {
            this.subramcn[(this.consram_bank - 1) * 4096 + (addr - 49152)] = (byte)dat;
            return;
        }
        if (addr < 54144) {
            this.sub_ram[addr - 49152] = (byte)dat;
            return;
        }
        if (addr < 54272) {
            Submem.subctrl.shared_ram[addr - 54144] = (byte)dat;
            return;
        }
        if (addr >= 54528 && addr < 55296) {
            this.sub_ram[addr - 54528 + 4992] = (byte)dat;
            return;
        }
        if (addr >= 55296) {
            if (this.subrom_bank != 4 || Submem.subctrl.subram_protect) {
                return;
            }
            if (addr < 57344) {
                this.subramcg[this.cgram_bank * 2048 + (addr - 55296)] = (byte)dat;
                return;
            }
            this.subramde[addr - 57344] = (byte)dat;
            return;
        }
        this.sub_io[addr - 54272] = (byte)dat;
        if (display.writeb(addr, dat)) {
            return;
        }
        if (keyboard.writeb(addr, dat)) {
            return;
        }
        if (aluline.writeb(addr, dat)) {
            return;
        }
    }

    boolean save(RandomAccessFile fileh) {
        if (Submem.subctrl.mode400l) {
            if (!File.write(fileh, this.vram_c, 98304)) {
                return false;
            }
        } else {
            if (!File.write(fileh, this.vram_c, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 32768, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 65536, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 16384, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 49152, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 81920, 16384)) {
                return false;
            }
        }
        if (!File.write(fileh, this.sub_ram, 5760)) {
            return false;
        }
        if (!File.write(fileh, this.sub_io, 256)) {
            return false;
        }
        if (!File.byte_write(fileh, this.subrom_bank)) {
            return false;
        }
        if (!File.byte_write(fileh, this.cgrom_bank)) {
            return false;
        }
        if (Submem.subctrl.mode400l) {
            if (!File.write(fileh, this.vram_c, 98304, 98304)) {
                return false;
            }
        } else {
            if (!File.write(fileh, this.vram_c, 98304, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 131072, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 163840, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 114688, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 147456, 16384)) {
                return false;
            }
            if (!File.write(fileh, this.vram_c, 180224, 16384)) {
                return false;
            }
        }
        if (!File.write(fileh, this.subramde, 8192)) {
            return false;
        }
        if (!File.write(fileh, this.subramcg, 16384)) {
            return false;
        }
        if (!File.write(fileh, this.subramcn, 8192)) {
            return false;
        }
        if (!File.byte_write(fileh, this.cgram_bank)) {
            return false;
        }
        return File.byte_write(fileh, this.consram_bank);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        block38: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block28: {
                                                    block27: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block21: {
                                                                                if (ver < 200) {
                                                                                    return false;
                                                                                }
                                                                                try {
                                                                                    if (File.read(fileh, this.vram_c, 16384)) break block21;
                                                                                    return false;
                                                                                }
                                                                                catch (IOException e) {
                                                                                    return false;
                                                                                }
                                                                            }
                                                                            if (File.read(fileh, this.vram_c, 32768, 16384)) break block22;
                                                                            return false;
                                                                        }
                                                                        if (File.read(fileh, this.vram_c, 65536, 16384)) break block23;
                                                                        return false;
                                                                    }
                                                                    if (File.read(fileh, this.vram_c, 16384, 16384)) break block24;
                                                                    return false;
                                                                }
                                                                if (File.read(fileh, this.vram_c, 49152, 16384)) break block25;
                                                                return false;
                                                            }
                                                            if (File.read(fileh, this.vram_c, 81920, 16384)) break block26;
                                                            return false;
                                                        }
                                                        if (File.read(fileh, this.sub_ram, 5760)) break block27;
                                                        return false;
                                                    }
                                                    if (File.read(fileh, this.sub_io, 256)) break block28;
                                                    return false;
                                                }
                                                this.subrom_bank = File.byte_read(fileh);
                                                this.cgrom_bank = File.byte_read(fileh);
                                                if (ver >= 800) break block29;
                                                this.consram_bank = 0;
                                                this.cgram_bank = 0;
                                                return true;
                                            }
                                            if (File.read(fileh, this.vram_c, 98304, 16384)) break block30;
                                            return false;
                                        }
                                        if (File.read(fileh, this.vram_c, 131072, 16384)) break block31;
                                        return false;
                                    }
                                    if (File.read(fileh, this.vram_c, 163840, 16384)) break block32;
                                    return false;
                                }
                                if (File.read(fileh, this.vram_c, 114688, 16384)) break block33;
                                return false;
                            }
                            if (File.read(fileh, this.vram_c, 147456, 16384)) break block34;
                            return false;
                        }
                        if (File.read(fileh, this.vram_c, 180224, 16384)) break block35;
                        return false;
                    }
                    if (File.read(fileh, this.subramde, 8192)) break block36;
                    return false;
                }
                if (File.read(fileh, this.subramcg, 16384)) break block37;
                return false;
            }
            if (File.read(fileh, this.subramcn, 8192)) break block38;
            return false;
        }
        this.cgram_bank = File.byte_read(fileh);
        this.consram_bank = File.byte_read(fileh);
        return true;
    }
}

