/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Thg
extends Base
implements EventHandler {
    public boolean thg_enable;
    public boolean thg_use;
    public int[] thg_reg = new int[256];
    public boolean[] thg_key = new boolean[4];
    private boolean thg_timera;
    private boolean thg_timerb;
    private int thg_timera_tick;
    private int thg_timerb_tick;
    public int thg_scale;
    private int thg_pstate;
    private int thg_selreg;
    private int thg_seldat;
    private boolean thg_timera_int;
    private boolean thg_timerb_int;
    private boolean thg_timera_en;
    private boolean thg_timerb_en;
    private final int thg_timera_event = 1;
    private final int thg_timerb_event = 2;

    Thg() {
    }

    boolean init() {
        Util.memset(this.thg_reg, 0, Util.sizeof(this.thg_reg));
        this.thg_enable = false;
        this.thg_use = false;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        int i = 0;
        while (i < 6) {
            Thg.sysmain.sys_snd.thg_notify(i, 0);
            ++i;
        }
        Thg.sysmain.sys_snd.thg_notify(7, 255);
        i = 64;
        while (i < 80) {
            if ((i & 3) != 3) {
                Thg.sysmain.sys_snd.thg_notify(i, 127);
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Thg.sysmain.sys_snd.thg_notify(40, i);
            this.thg_key[i] = false;
            ++i;
        }
    }

    void reset() {
        Util.memset(this.thg_reg, 0, Util.sizeof(this.thg_reg));
        this.thg_timera = false;
        this.thg_timerb = false;
        this.thg_pstate = 0;
        this.thg_selreg = 0;
        this.thg_seldat = 0;
        this.thg_timera_int = false;
        this.thg_timerb_int = false;
        this.thg_timera_tick = 0;
        this.thg_timerb_tick = 0;
        this.thg_timera_en = false;
        this.thg_timerb_en = false;
        this.thg_scale = 3;
        int i = 0;
        while (i < 14) {
            if (i == 7) {
                Thg.sysmain.sys_snd.thg_notify(i, 255);
                this.thg_reg[i] = 255;
            } else {
                Thg.sysmain.sys_snd.thg_notify(i, 0);
            }
            ++i;
        }
        i = 48;
        while (i < 64) {
            if ((i & 3) != 3) {
                Thg.sysmain.sys_snd.thg_notify(i, 0);
            }
            ++i;
        }
        i = 64;
        while (i < 80) {
            if ((i & 3) != 3) {
                Thg.sysmain.sys_snd.thg_notify(i, 127);
                this.thg_reg[i] = 127;
            }
            ++i;
        }
        i = 80;
        while (i < 96) {
            if ((i & 3) != 3) {
                Thg.sysmain.sys_snd.thg_notify(i, 31);
                this.thg_reg[i] = 31;
            }
            ++i;
        }
        i = 96;
        while (i < 180) {
            if ((i & 3) != 3) {
                Thg.sysmain.sys_snd.thg_notify(i, 0);
            }
            ++i;
        }
        i = 128;
        while (i < 144) {
            if ((i & 3) != 3) {
                Thg.sysmain.sys_snd.thg_notify(i, 255);
                this.thg_reg[i] = 255;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Thg.sysmain.sys_snd.thg_notify(40, i);
            this.thg_key[i] = false;
            ++i;
        }
        Thg.sysmain.sys_snd.thg_notify(39, 0);
        this.thg_use = false;
    }

    @Override
    public boolean event(int callbackid) {
        switch (callbackid) {
            case 1: {
                return this.timera_event();
            }
            case 2: {
                return this.timerb_event();
            }
        }
        return true;
    }

    private boolean timera_event() {
        if (this.thg_enable && this.thg_timera_en && this.thg_timera) {
            this.thg_timera = false;
            this.thg_timera_int = true;
            Thg.mainetc.thg_irq_flag = true;
            maincpu.irq();
        }
        if (this.thg_enable) {
            Thg.sysmain.sys_snd.thg_notify(255, 0);
        }
        this.timera_calc();
        return true;
    }

    private void timera_calc() {
        int t = this.thg_reg[36];
        t *= 4;
        int temp = this.thg_reg[37] & 3;
        t |= temp;
        t &= 0x3FF;
        t = 1024 - t;
        t *= this.thg_scale;
        t *= 12;
        t *= 10000;
        if (this.thg_timera_tick != (t /= 12288)) {
            this.thg_timera_tick = t;
            schedule.setevent(12, this.thg_timera_tick, this, 1);
        }
    }

    private boolean timerb_event() {
        if (this.thg_enable && this.thg_timerb_en && this.thg_timerb) {
            this.thg_timerb = false;
            this.thg_timerb_int = true;
            Thg.mainetc.thg_irq_flag = true;
            maincpu.irq();
        }
        this.timerb_calc();
        return true;
    }

    private void timerb_calc() {
        int t = this.thg_reg[38];
        t = 256 - t;
        t *= 192;
        t *= this.thg_scale;
        t *= 10000;
        if ((t /= 12288) != this.thg_timerb_tick) {
            this.thg_timerb_tick = t;
            schedule.setevent(13, this.thg_timerb_tick, this, 2);
        }
    }

    private int readreg(int reg) {
        if (reg >= 16) {
            return 255;
        }
        return this.thg_reg[reg];
    }

    private void writereg(int reg, int dat) {
        if (reg == 39) {
            if ((dat & 0x10) != 0) {
                this.thg_timera_int = false;
            }
            if ((dat & 0x20) != 0) {
                this.thg_timerb_int = false;
            }
            if (!this.thg_timera_int && !this.thg_timerb_int) {
                Thg.mainetc.thg_irq_flag = false;
                maincpu.irq();
            }
            if ((dat & 1) != 0) {
                if ((this.thg_reg[39] & 1) == 0) {
                    this.timera_calc();
                }
                this.thg_timera_en = true;
            } else {
                this.thg_timera_en = false;
            }
            this.thg_timera = (dat & 4) != 0;
            if ((dat & 2) != 0) {
                if ((this.thg_reg[39] & 2) == 0) {
                    this.timerb_calc();
                }
                this.thg_timerb_en = true;
            } else {
                this.thg_timerb_en = false;
            }
            this.thg_timerb = (dat & 8) != 0;
            this.thg_reg[reg] = dat;
            Thg.sysmain.sys_snd.thg_notify(39, dat & 0xC0);
            return;
        }
        this.thg_reg[reg] = dat;
        switch (reg) {
            case 45: {
                if (this.thg_scale != 3) {
                    this.thg_scale = 6;
                    this.timera_calc();
                    this.timerb_calc();
                }
                return;
            }
            case 46: {
                this.thg_scale = 3;
                this.timera_calc();
                this.timerb_calc();
                return;
            }
            case 47: {
                this.thg_scale = 2;
                this.timera_calc();
                this.timerb_calc();
                return;
            }
            case 36: 
            case 37: {
                this.thg_timera_tick = 0;
                return;
            }
            case 38: {
                this.thg_timerb_tick = 0;
                return;
            }
        }
        if (reg >= 14 && reg <= 38) {
            return;
        }
        if (reg >= 41 && reg <= 44) {
            return;
        }
        if (reg == 40) {
            this.thg_key[dat & 3] = dat >= 16;
        }
        Thg.sysmain.sys_snd.thg_notify(reg, dat);
    }

    boolean readb(int addr, IntHolder dat) {
        switch (addr) {
            case 64781: {
                if (Thg.vm.fm7_ver != 1) {
                    return false;
                }
            }
            case 64849: {
                if (!this.thg_enable && addr == 64849) {
                    return false;
                }
                dat.value = 255;
                return true;
            }
            case 64782: {
                if (Thg.vm.fm7_ver != 1) {
                    return false;
                }
            }
            case 64850: {
                if (!this.thg_enable && addr == 64850) {
                    return false;
                }
                switch (this.thg_pstate) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        dat.value = this.thg_seldat;
                        break;
                    }
                    case 4: {
                        dat.value = 0;
                        if (this.thg_timera_int) {
                            dat.value = 1;
                        }
                        if (!this.thg_timerb_int) break;
                        dat.value = 2;
                        break;
                    }
                    case 9: {
                        dat.value = this.thg_selreg == 14 ? 255 : 0;
                    }
                }
                return true;
            }
            case 64851: {
                dat.value = this.thg_timera_int || this.thg_timerb_int ? 247 : 255;
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        switch (addr) {
            case 64781: {
                if (Thg.vm.fm7_ver != 1) {
                    return false;
                }
                dat &= 3;
            }
            case 64849: {
                if (!this.thg_enable && addr == 64849) {
                    return false;
                }
                switch (dat & 0xF) {
                    case 0: {
                        this.thg_pstate = 0;
                        break;
                    }
                    case 1: {
                        this.thg_pstate = 1;
                        this.thg_seldat = this.readreg(this.thg_selreg);
                        break;
                    }
                    case 2: {
                        this.thg_pstate = 2;
                        if (addr == 64849 || this.thg_selreg < 16) {
                            this.writereg(this.thg_selreg, this.thg_seldat);
                        }
                        if (addr != 64849) break;
                        this.thg_use = true;
                        break;
                    }
                    case 3: {
                        this.thg_pstate = 3;
                        this.thg_selreg = this.thg_seldat;
                        if (addr != 64849 || this.thg_selreg < 45 || this.thg_selreg > 47) break;
                        this.thg_seldat = 0;
                        this.writereg(this.thg_selreg, this.thg_seldat);
                        break;
                    }
                    case 4: {
                        this.thg_pstate = 4;
                        break;
                    }
                    case 9: {
                        this.thg_pstate = 9;
                    }
                }
                return true;
            }
            case 64782: {
                if (Thg.vm.fm7_ver != 1) {
                    return false;
                }
            }
            case 64850: {
                if (!this.thg_enable && addr == 64850) {
                    return false;
                }
                this.thg_seldat = dat;
                switch (this.thg_pstate) {
                    case 2: {
                        if (addr == 64850 || this.thg_selreg < 16) {
                            this.writereg(this.thg_selreg, this.thg_seldat);
                        }
                        if (addr != 64850) break;
                        this.thg_use = true;
                        break;
                    }
                    case 3: {
                        this.thg_selreg = this.thg_seldat;
                        if (addr != 64850 || this.thg_selreg < 45 || this.thg_selreg > 47) break;
                        this.thg_seldat = 0;
                        this.writereg(this.thg_selreg, this.thg_seldat);
                    }
                }
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.thg_enable)) {
            return false;
        }
        if (!File.bool_write(fileh, this.thg_use)) {
            return false;
        }
        if (!File.write(fileh, this.thg_reg, 256)) {
            return false;
        }
        if (!File.bool_write(fileh, this.thg_timera)) {
            return false;
        }
        if (!File.bool_write(fileh, this.thg_timerb)) {
            return false;
        }
        if (!File.dword_write(fileh, this.thg_timera_tick)) {
            return false;
        }
        if (!File.dword_write(fileh, this.thg_timerb_tick)) {
            return false;
        }
        if (!File.byte_write(fileh, this.thg_scale)) {
            return false;
        }
        if (!File.byte_write(fileh, this.thg_pstate)) {
            return false;
        }
        if (!File.byte_write(fileh, this.thg_selreg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.thg_seldat)) {
            return false;
        }
        if (!File.bool_write(fileh, this.thg_timera_int)) {
            return false;
        }
        if (!File.bool_write(fileh, this.thg_timerb_int)) {
            return false;
        }
        if (!File.bool_write(fileh, this.thg_timera_en)) {
            return false;
        }
        return File.bool_write(fileh, this.thg_timerb_en);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        block8: {
            if (ver < 600) {
                this.thg_use = false;
                return true;
            }
            this.thg_enable = File.bool_read(fileh);
            this.thg_use = File.bool_read(fileh);
            if (File.read(fileh, this.thg_reg, 256)) break block8;
            return false;
        }
        try {
            this.thg_timera = File.bool_read(fileh);
            this.thg_timerb = File.bool_read(fileh);
            this.thg_timera_tick = File.dword_read(fileh);
            this.thg_timerb_tick = File.dword_read(fileh);
            this.thg_scale = File.byte_read(fileh);
            this.thg_pstate = File.byte_read(fileh);
            this.thg_selreg = File.byte_read(fileh);
            this.thg_seldat = File.byte_read(fileh);
            this.thg_timera_int = File.bool_read(fileh);
            this.thg_timerb_int = File.bool_read(fileh);
            this.thg_timera_en = File.bool_read(fileh);
            this.thg_timerb_en = File.bool_read(fileh);
            Thg.sysmain.sys_snd.thg_notify(39, this.thg_reg[39] & 0xC0);
            int i = 0;
            while (i < 3) {
                Thg.sysmain.sys_snd.thg_notify(40, i);
                this.thg_key[i] = false;
                ++i;
            }
            Thg.sysmain.sys_snd.thg_notify(8, 0);
            Thg.sysmain.sys_snd.thg_notify(9, 0);
            Thg.sysmain.sys_snd.thg_notify(10, 0);
            i = 0;
            while (i < 13) {
                if (i < 8 || i > 10) {
                    Thg.sysmain.sys_snd.thg_notify(i, this.thg_reg[i]);
                }
                ++i;
            }
            i = 48;
            while (i < 180) {
                Thg.sysmain.sys_snd.thg_notify(i, this.thg_reg[i]);
                ++i;
            }
            schedule.handle(12, this, 1);
            schedule.handle(13, this, 2);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

