/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.BytePointer;
import emu.xm7.vm.Util;
import java.io.RandomAccessFile;

public class Tools
extends Base {
    private static final int[] bmp_palet_table;
    private static final double GAMMA200L = 1.483239697419133;
    private static final double GAMMA400L = 1.217883285630907;
    private static final int[] color_bit_mask;
    private static final int[] color_add_data;

    static {
        int[] nArray = new int[32];
        nArray[4] = 255;
        nArray[10] = 255;
        nArray[12] = 255;
        nArray[14] = 255;
        nArray[17] = 255;
        nArray[20] = 255;
        nArray[21] = 255;
        nArray[25] = 255;
        nArray[26] = 255;
        nArray[28] = 255;
        nArray[29] = 255;
        nArray[30] = 255;
        bmp_palet_table = nArray;
        color_bit_mask = new int[]{1, 4, 2};
        color_add_data = new int[5];
    }

    public static boolean make_d77_sub(RandomAccessFile fileh, int dat) {
        int[] buf = new int[]{dat & 0xFF, dat >> 8 & 0xFF, dat >> 16 & 0xFF, dat >> 24 & 0xFF};
        return File.write(fileh, buf, 4);
    }

    public static boolean make_new_d77(String fname, String name, boolean mode2dd) {
        int j;
        int[] header = new int[688];
        RandomAccessFile fileh = File.open(fname, 2, true);
        if (fileh == null) {
            return false;
        }
        Util.memset(header, 0, Util.sizeof(header));
        byte[] tmp = name != null ? name.getBytes() : "Default".getBytes();
        int i = 0;
        while (i < tmp.length) {
            header[i] = tmp[i] & 0xFF;
            ++i;
        }
        if (mode2dd) {
            header[27] = 16;
        }
        if (!File.write(fileh, header, 28)) {
            File.close(fileh);
            return false;
        }
        int offset = mode2dd ? 924336 : 473776;
        if (!Tools.make_d77_sub(fileh, offset)) {
            File.close(fileh);
            return false;
        }
        offset = 688;
        i = 0;
        while (i < 84) {
            if (!Tools.make_d77_sub(fileh, offset)) {
                File.close(fileh);
                return false;
            }
            offset += 5632;
            ++i;
        }
        if (mode2dd) {
            i = 0;
            while (i < 80) {
                if (!Tools.make_d77_sub(fileh, offset)) {
                    File.close(fileh);
                    return false;
                }
                offset += 5632;
                ++i;
            }
        } else if (!File.write(fileh, header, 368, 320)) {
            File.close(fileh);
            return false;
        }
        Util.memset(header, 0, Util.sizeof(header));
        i = 0;
        while (i < 84) {
            j = 0;
            while (j < 11) {
                if (!File.write(fileh, header, 512)) {
                    File.close(fileh);
                    return false;
                }
                ++j;
            }
            ++i;
        }
        if (mode2dd) {
            i = 0;
            while (i < 80) {
                j = 0;
                while (j < 11) {
                    if (!File.write(fileh, header, 512)) {
                        File.close(fileh);
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        File.close(fileh);
        return true;
    }

    public static boolean make_new_userdisk(String fname, String name, boolean mode2dd) {
        int[] dummyipl = new int[]{26, 80, 134, 65, 183, 253, 3, 32, 254};
        int[] header = new int[688];
        RandomAccessFile fileh = File.open(fname, 2, true);
        if (fileh == null) {
            return false;
        }
        Util.memset(header, 0, Util.sizeof(header));
        byte[] tmp = name != null ? name.getBytes() : "Default".getBytes();
        int i = 0;
        while (i < tmp.length) {
            header[i] = tmp[i] & 0xFF;
            ++i;
        }
        if (mode2dd) {
            header[27] = 16;
        }
        if (!File.write(fileh, header, 28)) {
            File.close(fileh);
            return false;
        }
        int offset = mode2dd ? 697008 : 348848;
        if (!Tools.make_d77_sub(fileh, offset)) {
            File.close(fileh);
            return false;
        }
        offset = 688;
        int k = mode2dd ? 160 : 80;
        i = 0;
        while (i < 164) {
            if (i >= k) {
                offset = 0;
            }
            if (!Tools.make_d77_sub(fileh, offset)) {
                File.close(fileh);
                return false;
            }
            if (offset != 0) {
                offset += 4352;
            }
            ++i;
        }
        Util.memset(header, 0, Util.sizeof(header));
        i = 0;
        while (i < k) {
            int j = 1;
            while (j <= 16) {
                Util.memset(header, 0, 16);
                header[0] = i >> 1;
                header[1] = i & 1;
                header[2] = j;
                header[3] = 1;
                header[4] = 16;
                header[14] = 0;
                header[15] = 1;
                if (!File.write(fileh, header, 16)) {
                    File.close(fileh);
                    return false;
                }
                if (i == 0 && j == 1) {
                    Util.memset(header, 0, 256);
                    Util.memcpy(header, dummyipl, Util.sizeof(dummyipl));
                } else if (i == 0 && j == 3) {
                    Util.memset(header, 0, 256);
                    header[0] = mode2dd ? 69 : 83;
                    header[1] = 32;
                    header[2] = 32;
                } else if (i == 2 || i == 3) {
                    Util.memset(header, 255, 256);
                    if (i == 2 && j == 1) {
                        header[0] = 0;
                    }
                } else {
                    Util.memset(header, 229, 256);
                }
                if (!File.write(fileh, header, 256)) {
                    File.close(fileh);
                    return false;
                }
                ++j;
            }
            ++i;
        }
        File.close(fileh);
        return true;
    }

    public static boolean make_new_t77(String fname) {
        RandomAccessFile fileh = File.open(fname, 2, true);
        if (fileh == null) {
            return false;
        }
        if (!File.write(fileh, "XM7 TAPE IMAGE 0".getBytes(), 16)) {
            File.close(fileh);
            return false;
        }
        File.close(fileh);
        return true;
    }

    public static boolean conv_vfd_to_d77(String src, String dst, String name) {
        int[] vfd_h = new int[480];
        int[] d77_h = new int[688];
        int trklen = 0;
        byte[] buffer = Util.malloc(8192);
        if (buffer == null) {
            return false;
        }
        RandomAccessFile files = File.open(src, 1);
        if (files == null) {
            Util.free(buffer);
            return false;
        }
        int srclen = File.getsize(files);
        if (!File.read(files, vfd_h, Util.sizeof(vfd_h))) {
            Util.free(buffer);
            File.close(files);
            return false;
        }
        RandomAccessFile filed = File.open(dst, 2, true);
        if (filed == null) {
            Util.free(buffer);
            File.close(files);
            return false;
        }
        Util.memset(d77_h, 0, Util.sizeof(d77_h));
        Util.memcpy(d77_h, name.getBytes(), 16);
        if (!File.write(filed, d77_h, Util.sizeof(d77_h))) {
            Util.free(buffer);
            File.close(files);
            File.close(filed);
            return false;
        }
        int wrlen = Util.sizeof(d77_h);
        int header = 0;
        int trk = 0;
        while (trk < 80) {
            int secs;
            int offset = vfd_h[header + 3];
            offset *= 256;
            offset |= vfd_h[header + 2];
            offset *= 256;
            offset |= vfd_h[header + 1];
            offset *= 256;
            offset |= vfd_h[header + 0];
            int n = header += 4;
            int n2 = vfd_h[n];
            vfd_h[n] = n2 + 1;
            int len = n2;
            if ((len &= 7) >= 4) {
                len = 3;
            }
            int n3 = header;
            vfd_h[n3] = vfd_h[n3] + 1;
            if (secs != 0) {
                d77_h[trk * 4 + 32 + 3] = wrlen >> 24;
                d77_h[trk * 4 + 32 + 2] = wrlen >> 16 & 0xFF;
                d77_h[trk * 4 + 32 + 1] = wrlen >> 8 & 0xFF;
                d77_h[trk * 4 + 32 + 0] = wrlen & 0xFF;
                switch (len) {
                    case 0: {
                        trklen = secs * 144;
                        break;
                    }
                    case 1: {
                        trklen = secs * 272;
                        break;
                    }
                    case 2: {
                        trklen = secs * 528;
                        break;
                    }
                    case 3: {
                        trklen = secs * 1040;
                    }
                }
                if (offset > srclen | trklen > 8192) {
                    Util.free(buffer);
                    File.close(files);
                    File.close(filed);
                    return false;
                }
                if (!File.seek(files, offset)) {
                    Util.free(buffer);
                    File.close(files);
                    File.close(filed);
                    return false;
                }
                int ptr = 0;
                int sec = 1;
                while (sec <= secs) {
                    Util.memset(buffer, ptr, (byte)0, 16);
                    buffer[ptr + 0] = (byte)(trk >> 1);
                    buffer[ptr + 1] = (byte)(trk & 1);
                    buffer[ptr + 2] = (byte)sec;
                    buffer[ptr + 3] = (byte)len;
                    buffer[ptr + 4] = (byte)secs;
                    switch (len) {
                        case 0: {
                            buffer[ptr + 14] = -128;
                            File.read(files, buffer, ptr += 16, 128);
                            ptr += 128;
                            break;
                        }
                        case 1: {
                            buffer[ptr + 15] = 1;
                            File.read(files, buffer, ptr += 16, 256);
                            ptr += 256;
                            break;
                        }
                        case 2: {
                            buffer[ptr + 15] = 2;
                            File.read(files, buffer, ptr += 16, 512);
                            ptr += 512;
                            break;
                        }
                        case 3: {
                            buffer[ptr + 15] = 4;
                            File.read(files, buffer, ptr += 16, 1024);
                            ptr += 1024;
                        }
                    }
                    ++sec;
                }
                if (!File.write(filed, buffer, trklen)) {
                    Util.free(buffer);
                    File.close(files);
                    File.close(filed);
                    return false;
                }
                wrlen += trklen;
            }
            ++trk;
        }
        d77_h[31] = wrlen >> 24 & 0xFF;
        d77_h[30] = wrlen >> 16 & 0xFF;
        d77_h[29] = wrlen >> 8 & 0xFF;
        d77_h[28] = wrlen & 0xFF;
        if (!File.seek(filed, 0)) {
            Util.free(buffer);
            File.close(files);
            File.close(filed);
            return false;
        }
        if (!File.write(filed, d77_h, Util.sizeof(d77_h))) {
            Util.free(buffer);
            File.close(files);
            File.close(filed);
            return false;
        }
        Util.free(buffer);
        File.close(files);
        File.close(filed);
        return true;
    }

    public static boolean conv_2d_to_d77(String src, String dst, String name) {
        int[] d77_h = new int[688];
        byte[] buffer = Util.malloc(4352);
        if (buffer == null) {
            return false;
        }
        RandomAccessFile files = File.open(src, 1);
        if (files == null) {
            Util.free(buffer);
            return false;
        }
        if (File.getsize(files) != 327680) {
            File.close(files);
            Util.free(buffer);
            return false;
        }
        RandomAccessFile filed = File.open(dst, 2, true);
        if (filed == null) {
            Util.free(buffer);
            File.close(files);
            return false;
        }
        Util.memset(d77_h, 0, Util.sizeof(d77_h));
        Util.memcpy(d77_h, name.getBytes(), 16);
        d77_h[28] = 176;
        d77_h[29] = 82;
        d77_h[30] = 5;
        int offset = 688;
        int trk = 0;
        while (trk < 80) {
            d77_h[32 + trk * 4 + 0] = offset & 0xFF;
            d77_h[32 + trk * 4 + 1] = offset >> 8 & 0xFF;
            d77_h[32 + trk * 4 + 2] = offset >> 16 & 0xFF;
            d77_h[32 + trk * 4 + 3] = offset >> 24 & 0xFF;
            offset += 4352;
            ++trk;
        }
        if (!File.write(filed, d77_h, Util.sizeof(d77_h))) {
            Util.free(buffer);
            File.close(files);
            File.close(filed);
            return false;
        }
        trk = 0;
        while (trk < 80) {
            int ptr = 0;
            int sec = 1;
            while (sec <= 16) {
                Util.memset(buffer, ptr, (byte)0, 16);
                buffer[ptr + 0] = (byte)(trk >> 1);
                buffer[ptr + 1] = (byte)(trk & 1);
                buffer[ptr + 2] = (byte)sec;
                buffer[ptr + 3] = 1;
                buffer[ptr + 4] = 16;
                buffer[ptr + 15] = 1;
                File.read(files, buffer, ptr += 16, 256);
                ptr += 256;
                ++sec;
            }
            if (!File.write(filed, buffer, 4352)) {
                Util.free(buffer);
                File.close(files);
                File.close(filed);
                return false;
            }
            ++trk;
        }
        Util.free(buffer);
        File.close(files);
        File.close(filed);
        return true;
    }

    public static boolean vtp_conv_write(RandomAccessFile handle, int dat) {
        int[] buf = new int[44];
        buf[0] = 0;
        buf[1] = 52;
        buf[2] = 128;
        buf[3] = 26;
        buf[4] = 0;
        buf[5] = 26;
        buf[38] = 128;
        buf[39] = 47;
        buf[40] = 0;
        buf[41] = 55;
        buf[42] = 128;
        buf[43] = 47;
        int i = 0;
        while (i < 8) {
            if ((dat & 1) != 0) {
                buf[i * 4 + 6 + 0] = 128;
                buf[i * 4 + 6 + 1] = 48;
                buf[i * 4 + 6 + 2] = 0;
                buf[i * 4 + 6 + 3] = 48;
            } else {
                buf[i * 4 + 6 + 0] = 128;
                buf[i * 4 + 6 + 1] = 24;
                buf[i * 4 + 6 + 2] = 0;
                buf[i * 4 + 6 + 3] = 26;
            }
            dat >>= 1;
            ++i;
        }
        return File.write(handle, buf, 44);
    }

    public static boolean conv_vtp_to_t77(String src, String dst) {
        int[] buf = new int[44];
        int[] hdr = new int[4];
        String header = "XM7 TAPE IMAGE 0";
        int[] dat = new int[1];
        RandomAccessFile files = File.open(src, 1);
        if (files == null) {
            return false;
        }
        RandomAccessFile filed = File.open(dst, 2, true);
        if (filed == null) {
            File.close(files);
            return false;
        }
        if (!File.write(filed, header.getBytes(), 16)) {
            File.close(filed);
            File.close(files);
            return false;
        }
        while (true) {
            int count = 0;
            do {
                if (!File.read(files, dat, 1)) {
                    File.close(filed);
                    File.close(files);
                    return true;
                }
                if (dat[0] == 255) {
                    ++count;
                    continue;
                }
                count = 0;
            } while (count < 32);
            while (true) {
                if (!File.read(files, hdr, 0, 1)) {
                    File.close(filed);
                    File.close(files);
                    return true;
                }
                ++count;
                if (hdr[0] != 1) continue;
                if (!File.read(files, hdr, 1, 1)) {
                    File.close(filed);
                    File.close(files);
                    return true;
                }
                if (hdr[0] != 1 || hdr[1] != 60) continue;
                int i = 2;
                while (i < 4) {
                    if (!File.read(files, hdr, i, 1)) {
                        File.close(filed);
                        File.close(files);
                        return false;
                    }
                    ++i;
                }
                if (hdr[2] == 0) {
                    buf[0] = 0;
                    buf[1] = 0;
                    buf[2] = 127;
                    buf[3] = 255;
                    if (!File.write(filed, buf, 4)) {
                        File.close(filed);
                        File.close(files);
                        return false;
                    }
                }
                i = 0;
                while (i < count) {
                    if (!Tools.vtp_conv_write(filed, 255)) {
                        File.close(filed);
                        File.close(files);
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    if (!Tools.vtp_conv_write(filed, hdr[i])) {
                        File.close(filed);
                        File.close(files);
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i <= hdr[3]) {
                    if (!File.read(files, dat, 1)) {
                        File.close(filed);
                        File.close(files);
                        return false;
                    }
                    if (!Tools.vtp_conv_write(filed, dat[0])) {
                        File.close(filed);
                        File.close(files);
                        return false;
                    }
                    ++i;
                }
                count = 0;
                if (hdr[2] == 255) break;
            }
        }
    }

    public static boolean bmp_header_sub(RandomAccessFile fileh) {
        int[] filehdr = new int[14];
        int[] infohdr = new int[40];
        Util.memset(filehdr, 0, Util.sizeof(filehdr));
        Util.memset(infohdr, 0, Util.sizeof(infohdr));
        filehdr[0] = 66;
        filehdr[1] = 77;
        switch (Tools.display.screen_mode) {
            case 3: {
                filehdr[2] = 54;
                filehdr[3] = 184;
                filehdr[4] = 11;
                break;
            }
            case 1: {
                filehdr[2] = 54;
                filehdr[3] = 208;
                filehdr[4] = 7;
                break;
            }
            default: {
                filehdr[2] = 118;
                filehdr[3] = 244;
                filehdr[4] = 1;
            }
        }
        filehdr[10] = (Tools.display.screen_mode & 1) != 0 ? 54 : 118;
        if (!File.write(fileh, filehdr, Util.sizeof(filehdr))) {
            return false;
        }
        infohdr[0] = 40;
        infohdr[4] = 128;
        infohdr[5] = 2;
        infohdr[8] = 144;
        infohdr[9] = 1;
        infohdr[12] = 1;
        switch (Tools.display.screen_mode) {
            case 3: {
                infohdr[14] = 24;
                break;
            }
            case 1: {
                infohdr[14] = 16;
                break;
            }
            default: {
                infohdr[14] = 4;
            }
        }
        return File.write(fileh, infohdr, Util.sizeof(infohdr));
    }

    public static void mix_color_init(double gamma) {
        double maxbrg = Math.pow(255.0, 1.0 / gamma);
        int i = 0;
        while (i <= 4) {
            double brg = Math.pow(i << 6, 1.0 / gamma);
            Tools.color_add_data[i] = (int)(brg / maxbrg * 31.0) << 15;
            ++i;
        }
    }

    public static int mix_color(int[] palet_table, int palet_count) {
        int col = 0;
        int i = 0;
        while (i < 3) {
            int colcount = 0;
            int j = 0;
            while (j < palet_count) {
                if ((palet_table[j] & color_bit_mask[i]) != 0) {
                    colcount += 4 / palet_count;
                }
                ++j;
            }
            col = (col | color_add_data[colcount]) >> 5;
            ++i;
        }
        return col & Short.MAX_VALUE;
    }

    public static boolean bmp_header_sub2(RandomAccessFile fileh) {
        int[] filehdr = new int[14];
        int[] infohdr = new int[40];
        Util.memset(filehdr, 0, Util.sizeof(filehdr));
        Util.memset(infohdr, 0, Util.sizeof(infohdr));
        filehdr[0] = 66;
        filehdr[1] = 77;
        if (Tools.display.screen_mode == 3) {
            filehdr[2] = 54;
            filehdr[3] = 238;
            filehdr[4] = 2;
        } else {
            filehdr[2] = 54;
            filehdr[3] = 244;
            filehdr[4] = 1;
        }
        filehdr[10] = 54;
        if (!File.write(fileh, filehdr, Util.sizeof(filehdr))) {
            return false;
        }
        infohdr[0] = 40;
        infohdr[4] = 64;
        infohdr[5] = 1;
        infohdr[8] = 200;
        infohdr[9] = 0;
        infohdr[12] = 1;
        infohdr[14] = Tools.display.screen_mode == 3 ? 24 : 16;
        return File.write(fileh, infohdr, Util.sizeof(infohdr));
    }

    public static boolean bmp_palette_sub(RandomAccessFile fileh) {
        int p;
        int vpage = ~(Tools.multipag.multi_page >> 4) & 7;
        int i = 0;
        while (i < 8) {
            p = Tools.display.crt_flag ? (Tools.ttlpalet.ttl_palet[i & vpage] & 7) * 4 : 0;
            if (!File.write(fileh, bmp_palet_table, p, 4)) {
                return false;
            }
            ++i;
        }
        p = 0;
        i = 0;
        while (i < 8) {
            if (!File.write(fileh, bmp_palet_table, p, 4)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean bmp_320_sub(RandomAccessFile fileh, boolean fullscan) {
        int[][] buffer = new int[2][1280];
        int offset = 7960;
        display.window_clip(1);
        int dx1 = Tools.display.window_dx1 >> 3;
        int dx2 = Tools.display.window_dx2 >> 3;
        int mask = 0;
        if ((Tools.multipag.multi_page & 0x10) == 0) {
            mask |= 0xF;
        }
        if ((Tools.multipag.multi_page & 0x20) == 0) {
            mask |= 0xF0;
        }
        if ((Tools.multipag.multi_page & 0x40) == 0) {
            mask |= 0xF00;
        }
        Util.memset(buffer[0], 0, Util.sizeof(buffer[0]));
        int y = 0;
        while (y < 200) {
            boolean winy = 199 - y >= Tools.display.window_dy1 && 199 - y <= Tools.display.window_dy2;
            int x = 0;
            while (x < 40) {
                int bit = 128;
                BytePointer vramptr = winy && x >= dx1 && x < dx2 ? new BytePointer(Tools.display.vram_bdptr_v, Tools.display.vram_bdptr_p) : new BytePointer(Tools.display.vram_dptr_v, Tools.display.vram_dptr_p);
                int i = 0;
                while (i < 8) {
                    int dat = 0;
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        dat |= 0x800;
                    }
                    if ((vramptr.v(offset + 73728) & bit) != 0) {
                        dat |= 0x400;
                    }
                    if ((vramptr.v(offset + 81920) & bit) != 0) {
                        dat |= 0x200;
                    }
                    if ((vramptr.v(offset + 90112) & bit) != 0) {
                        dat |= 0x100;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        dat |= 0x80;
                    }
                    if ((vramptr.v(offset + 40960) & bit) != 0) {
                        dat |= 0x40;
                    }
                    if ((vramptr.v(offset + 49152) & bit) != 0) {
                        dat |= 0x20;
                    }
                    if ((vramptr.v(offset + 57344) & bit) != 0) {
                        dat |= 0x10;
                    }
                    if ((vramptr.v(offset + 0) & bit) != 0) {
                        dat |= 8;
                    }
                    if ((vramptr.v(offset + 8192) & bit) != 0) {
                        dat |= 4;
                    }
                    if ((vramptr.v(offset + 16384) & bit) != 0) {
                        dat |= 2;
                    }
                    if ((vramptr.v(offset + 24576) & bit) != 0) {
                        dat |= 1;
                    }
                    int color = Tools.apalet.apalet_r[dat &= mask];
                    color <<= 1;
                    if (Tools.apalet.apalet_r[dat] > 0) {
                        color |= 1;
                    }
                    color <<= 4;
                    color |= Tools.apalet.apalet_g[dat];
                    color <<= 1;
                    if (Tools.apalet.apalet_g[dat] > 0) {
                        color |= 1;
                    }
                    color <<= 4;
                    color |= Tools.apalet.apalet_b[dat];
                    color <<= 1;
                    if (Tools.apalet.apalet_b[dat] > 0) {
                        color |= 1;
                    }
                    if (!Tools.display.crt_flag) {
                        color = 0;
                    }
                    buffer[1][x * 32 + i * 4 + 0] = color & 0xFF;
                    buffer[1][x * 32 + i * 4 + 1] = color >> 8;
                    buffer[1][x * 32 + i * 4 + 2] = color & 0xFF;
                    buffer[1][x * 32 + i * 4 + 3] = color >> 8;
                    bit >>= 1;
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (fullscan) {
                Util.memcpy(buffer[0], buffer[1], Util.sizeof(buffer[1]));
            }
            if (!File.write(fileh, buffer[0], 1280)) {
                return false;
            }
            if (!File.write(fileh, buffer[1], 1280)) {
                return false;
            }
            offset -= 80;
            ++y;
        }
        return true;
    }

    public static boolean bmp_256k_sub(RandomAccessFile fileh, boolean fullscan) {
        int[][] buffer = new int[2][1920];
        int offset = 7960;
        Util.memset(buffer[0], 0, Util.sizeof(buffer[0]));
        int y = 0;
        while (y < 200) {
            int x = 0;
            while (x < 40) {
                int bit = 128;
                int i = 0;
                while (i < 8) {
                    int dat = 0;
                    if ((Tools.multipag.multi_page & 0x40) == 0) {
                        if ((Tools.submem.vram_c[offset + 65536] & bit) != 0) {
                            dat |= 0x8300;
                        }
                        if ((Tools.submem.vram_c[offset + 73728] & bit) != 0) {
                            dat |= 0x4300;
                        }
                        if ((Tools.submem.vram_c[offset + 81920] & bit) != 0) {
                            dat |= 0x2300;
                        }
                        if ((Tools.submem.vram_c[offset + 90112] & bit) != 0) {
                            dat |= 0x1300;
                        }
                        if ((Tools.submem.vram_c[offset + 163840] & bit) != 0) {
                            dat |= 0xB00;
                        }
                        if ((Tools.submem.vram_c[offset + 172032] & bit) != 0) {
                            dat |= 0x700;
                        }
                    }
                    if ((Tools.multipag.multi_page & 0x20) == 0) {
                        if ((Tools.submem.vram_c[offset + 32768] & bit) != 0) {
                            dat |= 0x830000;
                        }
                        if ((Tools.submem.vram_c[offset + 40960] & bit) != 0) {
                            dat |= 0x430000;
                        }
                        if ((Tools.submem.vram_c[offset + 49152] & bit) != 0) {
                            dat |= 0x230000;
                        }
                        if ((Tools.submem.vram_c[offset + 57344] & bit) != 0) {
                            dat |= 0x130000;
                        }
                        if ((Tools.submem.vram_c[offset + 131072] & bit) != 0) {
                            dat |= 0xB0000;
                        }
                        if ((Tools.submem.vram_c[offset + 139264] & bit) != 0) {
                            dat |= 0x70000;
                        }
                    }
                    if ((Tools.multipag.multi_page & 0x10) == 0) {
                        if ((Tools.submem.vram_c[offset + 0] & bit) != 0) {
                            dat |= 0x83;
                        }
                        if ((Tools.submem.vram_c[offset + 8192] & bit) != 0) {
                            dat |= 0x43;
                        }
                        if ((Tools.submem.vram_c[offset + 16384] & bit) != 0) {
                            dat |= 0x23;
                        }
                        if ((Tools.submem.vram_c[offset + 24576] & bit) != 0) {
                            dat |= 0x13;
                        }
                        if ((Tools.submem.vram_c[offset + 98304] & bit) != 0) {
                            dat |= 0xB;
                        }
                        if ((Tools.submem.vram_c[offset + 106496] & bit) != 0) {
                            dat |= 7;
                        }
                    }
                    if (!Tools.display.crt_flag) {
                        dat = 0;
                    }
                    buffer[1][x * 48 + i * 6 + 0] = dat & 0xFF;
                    buffer[1][x * 48 + i * 6 + 1] = dat >> 8 & 0xFF;
                    buffer[1][x * 48 + i * 6 + 2] = dat >> 16 & 0xFF;
                    buffer[1][x * 48 + i * 6 + 3] = dat & 0xFF;
                    buffer[1][x * 48 + i * 6 + 4] = dat >> 8 & 0xFF;
                    buffer[1][x * 48 + i * 6 + 5] = dat >> 16 & 0xFF;
                    bit >>= 1;
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (fullscan) {
                Util.memcpy(buffer[0], buffer[1], Util.sizeof(buffer[1]));
            }
            if (!File.write(fileh, buffer[0], Util.sizeof(buffer[0]))) {
                return false;
            }
            if (!File.write(fileh, buffer[1], Util.sizeof(buffer[1]))) {
                return false;
            }
            offset -= 80;
            ++y;
        }
        return true;
    }

    public static boolean bmp_640_sub(RandomAccessFile fileh, boolean fullscan) {
        int[][] buffer = new int[2][320];
        int offset = 15920;
        display.window_clip(0);
        int dx1 = Tools.display.window_dx1 >> 3;
        int dx2 = Tools.display.window_dx2 >> 3;
        Util.memset(buffer[0], 153, Util.sizeof(buffer[0]));
        int y = 0;
        while (y < 200) {
            boolean winy = 199 - y >= Tools.display.window_dy1 && 199 - y <= Tools.display.window_dy2;
            Util.memset(buffer[1], 0, Util.sizeof(buffer[1]));
            int x = 0;
            while (x < 80) {
                int bit = 128;
                BytePointer vramptr = winy && x >= dx1 && x < dx2 ? new BytePointer(Tools.display.vram_bdptr_v, Tools.display.vram_bdptr_p) : new BytePointer(Tools.display.vram_dptr_v, Tools.display.vram_dptr_p);
                int i = 0;
                while (i < 4) {
                    if ((vramptr.v(offset + 0) & bit) != 0) {
                        int[] nArray = buffer[1];
                        int n = x * 4 + i;
                        nArray[n] = nArray[n] | 0x10;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        int[] nArray = buffer[1];
                        int n = x * 4 + i;
                        nArray[n] = nArray[n] | 0x20;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        int[] nArray = buffer[1];
                        int n = x * 4 + i;
                        nArray[n] = nArray[n] | 0x40;
                    }
                    if ((vramptr.v(offset + 0) & (bit >>= 1)) != 0) {
                        int[] nArray = buffer[1];
                        int n = x * 4 + i;
                        nArray[n] = nArray[n] | 1;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        int[] nArray = buffer[1];
                        int n = x * 4 + i;
                        nArray[n] = nArray[n] | 2;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        int[] nArray = buffer[1];
                        int n = x * 4 + i;
                        nArray[n] = nArray[n] | 4;
                    }
                    bit >>= 1;
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (fullscan) {
                Util.memcpy(buffer[0], buffer[1], Util.sizeof(buffer[1]));
            }
            if (!File.write(fileh, buffer[0], Util.sizeof(buffer[0]))) {
                return false;
            }
            if (!File.write(fileh, buffer[1], Util.sizeof(buffer[1]))) {
                return false;
            }
            offset -= 160;
            ++y;
        }
        return true;
    }

    public static boolean bmp_400l_sub(RandomAccessFile fileh) {
        int[] buffer = new int[320];
        int offset = 31920;
        display.window_clip(2);
        int dx1 = Tools.display.window_dx1 >> 3;
        int dx2 = Tools.display.window_dx2 >> 3;
        int y = 0;
        while (y < 400) {
            boolean winy = 399 - y >= Tools.display.window_dy1 && 399 - y <= Tools.display.window_dy2;
            Util.memset(buffer, 0, Util.sizeof(buffer));
            int x = 0;
            while (x < 80) {
                int bit = 128;
                BytePointer vramptr = winy && x >= dx1 && x < dx2 ? new BytePointer(Tools.display.vram_bdptr_v, Tools.display.vram_bdptr_p) : new BytePointer(Tools.display.vram_dptr_v, Tools.display.vram_dptr_p);
                int i = 0;
                while (i < 4) {
                    if ((vramptr.v(offset + 0) & bit) != 0) {
                        int n = x * 4 + i;
                        buffer[n] = buffer[n] | 0x10;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        int n = x * 4 + i;
                        buffer[n] = buffer[n] | 0x20;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        int n = x * 4 + i;
                        buffer[n] = buffer[n] | 0x40;
                    }
                    if ((vramptr.v(offset + 0) & (bit >>= 1)) != 0) {
                        int n = x * 4 + i;
                        buffer[n] = buffer[n] | 1;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        int n = x * 4 + i;
                        buffer[n] = buffer[n] | 2;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        int n = x * 4 + i;
                        buffer[n] = buffer[n] | 4;
                    }
                    bit >>= 1;
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (!File.write(fileh, buffer, Util.sizeof(buffer))) {
                return false;
            }
            offset -= 160;
            ++y;
        }
        return true;
    }

    public static boolean bmp_320_sub2(RandomAccessFile fileh) {
        int[] buffer = new int[640];
        int offset = 7960;
        display.window_clip(1);
        int dx1 = Tools.display.window_dx1 >> 3;
        int dx2 = Tools.display.window_dx2 >> 3;
        int mask = 0;
        if ((Tools.multipag.multi_page & 0x10) == 0) {
            mask |= 0xF;
        }
        if ((Tools.multipag.multi_page & 0x20) == 0) {
            mask |= 0xF0;
        }
        if ((Tools.multipag.multi_page & 0x40) == 0) {
            mask |= 0xF00;
        }
        int y = 0;
        while (y < 200) {
            boolean winy = 199 - y >= Tools.display.window_dy1 && 199 - y <= Tools.display.window_dy2;
            int x = 0;
            while (x < 40) {
                int bit = 128;
                BytePointer vramptr = winy && x >= dx1 && x < dx2 ? new BytePointer(Tools.display.vram_bdptr_v, Tools.display.vram_bdptr_p) : new BytePointer(Tools.display.vram_dptr_v, Tools.display.vram_dptr_p);
                int i = 0;
                while (i < 8) {
                    int dat = 0;
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        dat |= 0x800;
                    }
                    if ((vramptr.v(offset + 73728) & bit) != 0) {
                        dat |= 0x400;
                    }
                    if ((vramptr.v(offset + 81920) & bit) != 0) {
                        dat |= 0x200;
                    }
                    if ((vramptr.v(offset + 90112) & bit) != 0) {
                        dat |= 0x100;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        dat |= 0x80;
                    }
                    if ((vramptr.v(offset + 40960) & bit) != 0) {
                        dat |= 0x40;
                    }
                    if ((vramptr.v(offset + 49152) & bit) != 0) {
                        dat |= 0x20;
                    }
                    if ((vramptr.v(offset + 57344) & bit) != 0) {
                        dat |= 0x10;
                    }
                    if ((vramptr.v(offset + 0) & bit) != 0) {
                        dat |= 8;
                    }
                    if ((vramptr.v(offset + 8192) & bit) != 0) {
                        dat |= 4;
                    }
                    if ((vramptr.v(offset + 16384) & bit) != 0) {
                        dat |= 2;
                    }
                    if ((vramptr.v(offset + 24576) & bit) != 0) {
                        dat |= 1;
                    }
                    int color = Tools.apalet.apalet_r[dat &= mask];
                    color <<= 1;
                    if (Tools.apalet.apalet_r[dat] > 0) {
                        color |= 1;
                    }
                    color <<= 4;
                    color |= Tools.apalet.apalet_g[dat];
                    color <<= 1;
                    if (Tools.apalet.apalet_g[dat] > 0) {
                        color |= 1;
                    }
                    color <<= 4;
                    color |= Tools.apalet.apalet_b[dat];
                    color <<= 1;
                    if (Tools.apalet.apalet_b[dat] > 0) {
                        color |= 1;
                    }
                    if (!Tools.display.crt_flag) {
                        color = 0;
                    }
                    buffer[x * 16 + i * 2 + 0] = color & 0xFF;
                    buffer[x * 16 + i * 2 + 1] = color >> 8;
                    bit >>= 1;
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (!File.write(fileh, buffer, Util.sizeof(buffer))) {
                return false;
            }
            offset -= 80;
            ++y;
        }
        return true;
    }

    public static boolean bmp_256k_sub2(RandomAccessFile fileh) {
        int[] buffer = new int[960];
        int offset = 7960;
        int y = 0;
        while (y < 200) {
            int x = 0;
            while (x < 40) {
                int bit = 128;
                int i = 0;
                while (i < 8) {
                    int dat = 0;
                    if ((Tools.multipag.multi_page & 0x40) == 0) {
                        if ((Tools.submem.vram_c[offset + 65536] & bit) != 0) {
                            dat |= 0x8300;
                        }
                        if ((Tools.submem.vram_c[offset + 73728] & bit) != 0) {
                            dat |= 0x4300;
                        }
                        if ((Tools.submem.vram_c[offset + 81920] & bit) != 0) {
                            dat |= 0x2300;
                        }
                        if ((Tools.submem.vram_c[offset + 90112] & bit) != 0) {
                            dat |= 0x1300;
                        }
                        if ((Tools.submem.vram_c[offset + 163840] & bit) != 0) {
                            dat |= 0xB00;
                        }
                        if ((Tools.submem.vram_c[offset + 172032] & bit) != 0) {
                            dat |= 0x700;
                        }
                    }
                    if ((Tools.multipag.multi_page & 0x20) == 0) {
                        if ((Tools.submem.vram_c[offset + 32768] & bit) != 0) {
                            dat |= 0x830000;
                        }
                        if ((Tools.submem.vram_c[offset + 40960] & bit) != 0) {
                            dat |= 0x430000;
                        }
                        if ((Tools.submem.vram_c[offset + 49152] & bit) != 0) {
                            dat |= 0x230000;
                        }
                        if ((Tools.submem.vram_c[offset + 57344] & bit) != 0) {
                            dat |= 0x130000;
                        }
                        if ((Tools.submem.vram_c[offset + 131072] & bit) != 0) {
                            dat |= 0xB0000;
                        }
                        if ((Tools.submem.vram_c[offset + 139264] & bit) != 0) {
                            dat |= 0x70000;
                        }
                    }
                    if ((Tools.multipag.multi_page & 0x10) == 0) {
                        if ((Tools.submem.vram_c[offset + 0] & bit) != 0) {
                            dat |= 0x83;
                        }
                        if ((Tools.submem.vram_c[offset + 8192] & bit) != 0) {
                            dat |= 0x43;
                        }
                        if ((Tools.submem.vram_c[offset + 16384] & bit) != 0) {
                            dat |= 0x23;
                        }
                        if ((Tools.submem.vram_c[offset + 24576] & bit) != 0) {
                            dat |= 0x13;
                        }
                        if ((Tools.submem.vram_c[offset + 98304] & bit) != 0) {
                            dat |= 0xB;
                        }
                        if ((Tools.submem.vram_c[offset + 106496] & bit) != 0) {
                            dat |= 7;
                        }
                    }
                    if (!Tools.display.crt_flag) {
                        dat = 0;
                    }
                    buffer[x * 24 + i * 3 + 0] = dat & 0xFF;
                    buffer[x * 24 + i * 3 + 1] = dat >> 8 & 0xFF;
                    buffer[x * 24 + i * 3 + 2] = dat >> 16 & 0xFF;
                    bit >>= 1;
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (!File.write(fileh, buffer, Util.sizeof(buffer))) {
                return false;
            }
            offset -= 80;
            ++y;
        }
        return true;
    }

    public static boolean bmp_640_sub2(RandomAccessFile fileh) {
        int[] buffer = new int[640];
        int[] pal = new int[8];
        int[] col = new int[2];
        Tools.mix_color_init(1.483239697419133);
        int i = 0;
        while (i < 8) {
            pal[i] = Tools.display.crt_flag ? Tools.ttlpalet.ttl_palet[i & (~(Tools.multipag.multi_page >> 4) & 7)] & 7 : 0;
            ++i;
        }
        int offset = 15920;
        display.window_clip(0);
        int dx1 = Tools.display.window_dx1 >> 3;
        int dx2 = Tools.display.window_dx2 >> 3;
        int y = 0;
        while (y < 200) {
            boolean winy = 199 - y >= Tools.display.window_dy1 && 199 - y <= Tools.display.window_dy2;
            int x = 0;
            while (x < 80) {
                int bit = 128;
                BytePointer vramptr = winy && x >= dx1 && x < dx2 ? new BytePointer(Tools.display.vram_bdptr_v, Tools.display.vram_bdptr_p) : new BytePointer(Tools.display.vram_dptr_v, Tools.display.vram_dptr_p);
                i = 0;
                while (i < 4) {
                    col[0] = 0;
                    col[1] = 0;
                    if ((vramptr.v(offset + 0) & bit) != 0) {
                        col[0] = col[0] | 1;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        col[0] = col[0] | 2;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        col[0] = col[0] | 4;
                    }
                    if ((vramptr.v(offset + 0) & (bit >>= 1)) != 0) {
                        col[1] = col[1] | 1;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        col[1] = col[1] | 2;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        col[1] = col[1] | 4;
                    }
                    bit >>= 1;
                    col[0] = pal[col[0]];
                    col[1] = pal[col[1]];
                    int color = Tools.mix_color(col, 2);
                    buffer[x * 8 + i * 2 + 0] = color & 0xFF;
                    buffer[x * 8 + i * 2 + 1] = color >> 8;
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (!File.write(fileh, buffer, Util.sizeof(buffer))) {
                return false;
            }
            offset -= 160;
            ++y;
        }
        return true;
    }

    public static boolean bmp_400l_sub2(RandomAccessFile fileh) {
        int[] buffer = new int[640];
        int[] pal = new int[8];
        int[] lbuf = new int[640];
        int[] pbuf = new int[4];
        Tools.mix_color_init(1.217883285630907);
        int i = 0;
        while (i < 8) {
            pal[i] = Tools.display.crt_flag ? Tools.ttlpalet.ttl_palet[i & (~(Tools.multipag.multi_page >> 4) & 7)] & 7 : 0;
            ++i;
        }
        int offset = 31920;
        display.window_clip(2);
        int dx1 = Tools.display.window_dx1 >> 3;
        int dx2 = Tools.display.window_dx2 >> 3;
        int y = 0;
        while (y < 400) {
            boolean winy;
            boolean bl = winy = 399 - y >= Tools.display.window_dy1 && 399 - y <= Tools.display.window_dy2;
            if (y % 2 == 0) {
                Util.memset(lbuf, 0, Util.sizeof(pbuf));
            }
            int x = 0;
            while (x < 80) {
                int bit = 128;
                BytePointer vramptr = winy && x >= dx1 && x < dx2 ? new BytePointer(Tools.display.vram_bdptr_v, Tools.display.vram_bdptr_p) : new BytePointer(Tools.display.vram_dptr_v, Tools.display.vram_dptr_p);
                i = 0;
                while (i < 4) {
                    int col1 = 0;
                    int col2 = 0;
                    if ((vramptr.v(offset + 0) & bit) != 0) {
                        col1 |= 1;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        col1 |= 2;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        col1 |= 4;
                    }
                    if ((vramptr.v(offset + 0) & (bit >>= 1)) != 0) {
                        col2 |= 1;
                    }
                    if ((vramptr.v(offset + 32768) & bit) != 0) {
                        col2 |= 2;
                    }
                    if ((vramptr.v(offset + 65536) & bit) != 0) {
                        col2 |= 4;
                    }
                    bit >>= 1;
                    if (y % 2 == 0) {
                        lbuf[(x * 4 + i) * 2 + 0] = col1;
                        lbuf[(x * 4 + i) * 2 + 1] = col2;
                    } else {
                        pbuf[0] = pal[lbuf[(x * 4 + i) * 2 + 0]];
                        pbuf[1] = pal[lbuf[(x * 4 + i) * 2 + 1]];
                        pbuf[2] = pal[col1];
                        pbuf[3] = pal[col2];
                        int color = Tools.mix_color(pbuf, 4);
                        buffer[x * 8 + i * 2 + 0] = color & 0xFF;
                        buffer[x * 8 + i * 2 + 1] = color >> 8;
                    }
                    ++i;
                }
                ++offset;
                ++x;
            }
            if (y % 2 == 1 && !File.write(fileh, buffer, Util.sizeof(buffer))) {
                return false;
            }
            offset -= 160;
            ++y;
        }
        return true;
    }

    public static boolean capture_to_bmp(String fname, boolean fullscan) {
        RandomAccessFile fileh = File.open(fname, 2, true);
        if (fileh == null) {
            return false;
        }
        if (!Tools.bmp_header_sub(fileh)) {
            File.close(fileh);
            return false;
        }
        if ((Tools.display.screen_mode & 1) == 0 && !Tools.bmp_palette_sub(fileh)) {
            File.close(fileh);
            return false;
        }
        switch (Tools.display.screen_mode) {
            case 2: {
                if (Tools.bmp_400l_sub(fileh)) break;
                File.close(fileh);
                return false;
            }
            case 3: {
                if (Tools.bmp_256k_sub(fileh, fullscan)) break;
                File.close(fileh);
                return false;
            }
            case 1: {
                if (Tools.bmp_320_sub(fileh, fullscan)) break;
                File.close(fileh);
                return false;
            }
            case 0: {
                if (Tools.bmp_640_sub(fileh, fullscan)) break;
                File.close(fileh);
                return false;
            }
        }
        File.close(fileh);
        return true;
    }

    public static boolean capture_to_bmp2(String fname) {
        RandomAccessFile fileh = File.open(fname, 2, true);
        if (fileh == null) {
            return false;
        }
        if (!Tools.bmp_header_sub2(fileh)) {
            File.close(fileh);
            return false;
        }
        switch (Tools.display.screen_mode) {
            case 2: {
                if (Tools.bmp_400l_sub2(fileh)) break;
                File.close(fileh);
                return false;
            }
            case 3: {
                if (Tools.bmp_256k_sub2(fileh)) break;
                File.close(fileh);
                return false;
            }
            case 1: {
                if (Tools.bmp_320_sub2(fileh)) break;
                File.close(fileh);
                return false;
            }
            case 0: {
                if (Tools.bmp_640_sub2(fileh)) break;
                File.close(fileh);
                return false;
            }
        }
        File.close(fileh);
        return true;
    }
}

