/*
 * Decompiled with CFR 0.152.
 */
package emu.fmgen;

import emu.fmgen.Chip;

class Operator {
    static final String LOGNAME = "fmgen";
    static final int FM_EG_BOTTOM = 955;
    private final int[] notetable;
    private final int[] dttable;
    private final int[][] decaytable1;
    private final int[] decaytable2;
    private final int[][] attacktable;
    private final int[][][][] ssgenvtable;
    private int[][][] pmtable;
    private int[][][] amtable;
    private boolean tablemade;
    static final int next = 0;
    static final int attack = 1;
    static final int decay = 2;
    static final int sustain = 3;
    static final int release = 4;
    static final int off = 5;
    private Chip chip_;
    int out_;
    int out2_;
    private int in2_;
    private int dp_;
    private int detune_;
    private int detune2_;
    private int multiple_;
    private int pg_count_;
    private int pg_diff_;
    private int pg_diff_lfo_;
    int type_;
    private int bn_;
    private int eg_level_;
    private int eg_level_on_next_phase_;
    private int eg_count_;
    private int eg_count_diff_;
    private int eg_out_;
    private int tl_out_;
    private int eg_rate_;
    private int eg_curve_count_;
    private int ssg_offset_;
    private int ssg_vector_;
    private int ssg_phase_;
    private int key_scale_rate_;
    private int eg_phase_;
    private int[] ams_;
    int ms_;
    private int tl_;
    private int tl_latch_;
    private int ar_;
    private int dr_;
    private int sr_;
    private int sl_;
    private int rr_;
    private int ks_;
    private int ssg_type_;
    private boolean keyon_;
    boolean amon_;
    boolean param_changed_;
    private boolean mute_;
    private boolean tablehasmade;
    private int[] sinetable;
    private int[] cltable;
    private final double[][] pms;
    private final int[][] amt;
    private final int IS2EC_SHIFT = 16;

    Operator() {
        int[] nArray = new int[128];
        nArray[7] = 1;
        nArray[8] = 2;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 5;
        nArray[24] = 6;
        nArray[25] = 7;
        nArray[26] = 7;
        nArray[27] = 7;
        nArray[28] = 7;
        nArray[29] = 7;
        nArray[30] = 7;
        nArray[31] = 7;
        nArray[32] = 8;
        nArray[33] = 8;
        nArray[34] = 8;
        nArray[35] = 8;
        nArray[36] = 8;
        nArray[37] = 8;
        nArray[38] = 8;
        nArray[39] = 9;
        nArray[40] = 10;
        nArray[41] = 11;
        nArray[42] = 11;
        nArray[43] = 11;
        nArray[44] = 11;
        nArray[45] = 11;
        nArray[46] = 11;
        nArray[47] = 11;
        nArray[48] = 12;
        nArray[49] = 12;
        nArray[50] = 12;
        nArray[51] = 12;
        nArray[52] = 12;
        nArray[53] = 12;
        nArray[54] = 12;
        nArray[55] = 13;
        nArray[56] = 14;
        nArray[57] = 15;
        nArray[58] = 15;
        nArray[59] = 15;
        nArray[60] = 15;
        nArray[61] = 15;
        nArray[62] = 15;
        nArray[63] = 15;
        nArray[64] = 16;
        nArray[65] = 16;
        nArray[66] = 16;
        nArray[67] = 16;
        nArray[68] = 16;
        nArray[69] = 16;
        nArray[70] = 16;
        nArray[71] = 17;
        nArray[72] = 18;
        nArray[73] = 19;
        nArray[74] = 19;
        nArray[75] = 19;
        nArray[76] = 19;
        nArray[77] = 19;
        nArray[78] = 19;
        nArray[79] = 19;
        nArray[80] = 20;
        nArray[81] = 20;
        nArray[82] = 20;
        nArray[83] = 20;
        nArray[84] = 20;
        nArray[85] = 20;
        nArray[86] = 20;
        nArray[87] = 21;
        nArray[88] = 22;
        nArray[89] = 23;
        nArray[90] = 23;
        nArray[91] = 23;
        nArray[92] = 23;
        nArray[93] = 23;
        nArray[94] = 23;
        nArray[95] = 23;
        nArray[96] = 24;
        nArray[97] = 24;
        nArray[98] = 24;
        nArray[99] = 24;
        nArray[100] = 24;
        nArray[101] = 24;
        nArray[102] = 24;
        nArray[103] = 25;
        nArray[104] = 26;
        nArray[105] = 27;
        nArray[106] = 27;
        nArray[107] = 27;
        nArray[108] = 27;
        nArray[109] = 27;
        nArray[110] = 27;
        nArray[111] = 27;
        nArray[112] = 28;
        nArray[113] = 28;
        nArray[114] = 28;
        nArray[115] = 28;
        nArray[116] = 28;
        nArray[117] = 28;
        nArray[118] = 28;
        nArray[119] = 29;
        nArray[120] = 30;
        nArray[121] = 31;
        nArray[122] = 31;
        nArray[123] = 31;
        nArray[124] = 31;
        nArray[125] = 31;
        nArray[126] = 31;
        nArray[127] = 31;
        this.notetable = nArray;
        int[] nArray2 = new int[256];
        nArray2[36] = 2;
        nArray2[37] = 2;
        nArray2[38] = 2;
        nArray2[39] = 2;
        nArray2[40] = 2;
        nArray2[41] = 2;
        nArray2[42] = 2;
        nArray2[43] = 2;
        nArray2[44] = 4;
        nArray2[45] = 4;
        nArray2[46] = 4;
        nArray2[47] = 4;
        nArray2[48] = 4;
        nArray2[49] = 6;
        nArray2[50] = 6;
        nArray2[51] = 6;
        nArray2[52] = 8;
        nArray2[53] = 8;
        nArray2[54] = 8;
        nArray2[55] = 10;
        nArray2[56] = 10;
        nArray2[57] = 12;
        nArray2[58] = 12;
        nArray2[59] = 14;
        nArray2[60] = 16;
        nArray2[61] = 16;
        nArray2[62] = 16;
        nArray2[63] = 16;
        nArray2[64] = 2;
        nArray2[65] = 2;
        nArray2[66] = 2;
        nArray2[67] = 2;
        nArray2[68] = 4;
        nArray2[69] = 4;
        nArray2[70] = 4;
        nArray2[71] = 4;
        nArray2[72] = 4;
        nArray2[73] = 6;
        nArray2[74] = 6;
        nArray2[75] = 6;
        nArray2[76] = 8;
        nArray2[77] = 8;
        nArray2[78] = 8;
        nArray2[79] = 10;
        nArray2[80] = 10;
        nArray2[81] = 12;
        nArray2[82] = 12;
        nArray2[83] = 14;
        nArray2[84] = 16;
        nArray2[85] = 16;
        nArray2[86] = 18;
        nArray2[87] = 20;
        nArray2[88] = 22;
        nArray2[89] = 24;
        nArray2[90] = 26;
        nArray2[91] = 28;
        nArray2[92] = 32;
        nArray2[93] = 32;
        nArray2[94] = 32;
        nArray2[95] = 32;
        nArray2[96] = 4;
        nArray2[97] = 4;
        nArray2[98] = 4;
        nArray2[99] = 4;
        nArray2[100] = 4;
        nArray2[101] = 6;
        nArray2[102] = 6;
        nArray2[103] = 6;
        nArray2[104] = 8;
        nArray2[105] = 8;
        nArray2[106] = 8;
        nArray2[107] = 10;
        nArray2[108] = 10;
        nArray2[109] = 12;
        nArray2[110] = 12;
        nArray2[111] = 14;
        nArray2[112] = 16;
        nArray2[113] = 16;
        nArray2[114] = 18;
        nArray2[115] = 20;
        nArray2[116] = 22;
        nArray2[117] = 24;
        nArray2[118] = 26;
        nArray2[119] = 28;
        nArray2[120] = 32;
        nArray2[121] = 34;
        nArray2[122] = 38;
        nArray2[123] = 40;
        nArray2[124] = 44;
        nArray2[125] = 44;
        nArray2[126] = 44;
        nArray2[127] = 44;
        nArray2[164] = -2;
        nArray2[165] = -2;
        nArray2[166] = -2;
        nArray2[167] = -2;
        nArray2[168] = -2;
        nArray2[169] = -2;
        nArray2[170] = -2;
        nArray2[171] = -2;
        nArray2[172] = -4;
        nArray2[173] = -4;
        nArray2[174] = -4;
        nArray2[175] = -4;
        nArray2[176] = -4;
        nArray2[177] = -6;
        nArray2[178] = -6;
        nArray2[179] = -6;
        nArray2[180] = -8;
        nArray2[181] = -8;
        nArray2[182] = -8;
        nArray2[183] = -10;
        nArray2[184] = -10;
        nArray2[185] = -12;
        nArray2[186] = -12;
        nArray2[187] = -14;
        nArray2[188] = -16;
        nArray2[189] = -16;
        nArray2[190] = -16;
        nArray2[191] = -16;
        nArray2[192] = -2;
        nArray2[193] = -2;
        nArray2[194] = -2;
        nArray2[195] = -2;
        nArray2[196] = -4;
        nArray2[197] = -4;
        nArray2[198] = -4;
        nArray2[199] = -4;
        nArray2[200] = -4;
        nArray2[201] = -6;
        nArray2[202] = -6;
        nArray2[203] = -6;
        nArray2[204] = -8;
        nArray2[205] = -8;
        nArray2[206] = -8;
        nArray2[207] = -10;
        nArray2[208] = -10;
        nArray2[209] = -12;
        nArray2[210] = -12;
        nArray2[211] = -14;
        nArray2[212] = -16;
        nArray2[213] = -16;
        nArray2[214] = -18;
        nArray2[215] = -20;
        nArray2[216] = -22;
        nArray2[217] = -24;
        nArray2[218] = -26;
        nArray2[219] = -28;
        nArray2[220] = -32;
        nArray2[221] = -32;
        nArray2[222] = -32;
        nArray2[223] = -32;
        nArray2[224] = -4;
        nArray2[225] = -4;
        nArray2[226] = -4;
        nArray2[227] = -4;
        nArray2[228] = -4;
        nArray2[229] = -6;
        nArray2[230] = -6;
        nArray2[231] = -6;
        nArray2[232] = -8;
        nArray2[233] = -8;
        nArray2[234] = -8;
        nArray2[235] = -10;
        nArray2[236] = -10;
        nArray2[237] = -12;
        nArray2[238] = -12;
        nArray2[239] = -14;
        nArray2[240] = -16;
        nArray2[241] = -16;
        nArray2[242] = -18;
        nArray2[243] = -20;
        nArray2[244] = -22;
        nArray2[245] = -24;
        nArray2[246] = -26;
        nArray2[247] = -28;
        nArray2[248] = -32;
        nArray2[249] = -34;
        nArray2[250] = -38;
        nArray2[251] = -40;
        nArray2[252] = -44;
        nArray2[253] = -44;
        nArray2[254] = -44;
        nArray2[255] = -44;
        this.dttable = nArray2;
        int[][] nArrayArray = new int[64][];
        nArrayArray[0] = new int[8];
        nArrayArray[1] = new int[8];
        nArrayArray[2] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        nArrayArray[3] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        nArrayArray[4] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        nArrayArray[5] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray3 = new int[8];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArrayArray[6] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArrayArray[7] = nArray4;
        int[] nArray5 = new int[8];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArray5[4] = 1;
        nArray5[6] = 1;
        nArrayArray[8] = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArray6[4] = 1;
        nArray6[6] = 1;
        nArrayArray[9] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[4] = 1;
        nArray7[5] = 1;
        nArray7[6] = 1;
        nArrayArray[10] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[0] = 1;
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 1;
        nArray8[5] = 1;
        nArray8[6] = 1;
        nArrayArray[11] = nArray8;
        int[] nArray9 = new int[8];
        nArray9[0] = 1;
        nArray9[2] = 1;
        nArray9[4] = 1;
        nArray9[6] = 1;
        nArrayArray[12] = nArray9;
        int[] nArray10 = new int[8];
        nArray10[0] = 1;
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[4] = 1;
        nArray10[6] = 1;
        nArrayArray[13] = nArray10;
        int[] nArray11 = new int[8];
        nArray11[0] = 1;
        nArray11[1] = 1;
        nArray11[2] = 1;
        nArray11[4] = 1;
        nArray11[5] = 1;
        nArray11[6] = 1;
        nArrayArray[14] = nArray11;
        int[] nArray12 = new int[8];
        nArray12[0] = 1;
        nArray12[1] = 1;
        nArray12[2] = 1;
        nArray12[3] = 1;
        nArray12[4] = 1;
        nArray12[5] = 1;
        nArray12[6] = 1;
        nArrayArray[15] = nArray12;
        int[] nArray13 = new int[8];
        nArray13[0] = 1;
        nArray13[2] = 1;
        nArray13[4] = 1;
        nArray13[6] = 1;
        nArrayArray[16] = nArray13;
        int[] nArray14 = new int[8];
        nArray14[0] = 1;
        nArray14[1] = 1;
        nArray14[2] = 1;
        nArray14[4] = 1;
        nArray14[6] = 1;
        nArrayArray[17] = nArray14;
        int[] nArray15 = new int[8];
        nArray15[0] = 1;
        nArray15[1] = 1;
        nArray15[2] = 1;
        nArray15[4] = 1;
        nArray15[5] = 1;
        nArray15[6] = 1;
        nArrayArray[18] = nArray15;
        int[] nArray16 = new int[8];
        nArray16[0] = 1;
        nArray16[1] = 1;
        nArray16[2] = 1;
        nArray16[3] = 1;
        nArray16[4] = 1;
        nArray16[5] = 1;
        nArray16[6] = 1;
        nArrayArray[19] = nArray16;
        int[] nArray17 = new int[8];
        nArray17[0] = 1;
        nArray17[2] = 1;
        nArray17[4] = 1;
        nArray17[6] = 1;
        nArrayArray[20] = nArray17;
        int[] nArray18 = new int[8];
        nArray18[0] = 1;
        nArray18[1] = 1;
        nArray18[2] = 1;
        nArray18[4] = 1;
        nArray18[6] = 1;
        nArrayArray[21] = nArray18;
        int[] nArray19 = new int[8];
        nArray19[0] = 1;
        nArray19[1] = 1;
        nArray19[2] = 1;
        nArray19[4] = 1;
        nArray19[5] = 1;
        nArray19[6] = 1;
        nArrayArray[22] = nArray19;
        int[] nArray20 = new int[8];
        nArray20[0] = 1;
        nArray20[1] = 1;
        nArray20[2] = 1;
        nArray20[3] = 1;
        nArray20[4] = 1;
        nArray20[5] = 1;
        nArray20[6] = 1;
        nArrayArray[23] = nArray20;
        int[] nArray21 = new int[8];
        nArray21[0] = 1;
        nArray21[2] = 1;
        nArray21[4] = 1;
        nArray21[6] = 1;
        nArrayArray[24] = nArray21;
        int[] nArray22 = new int[8];
        nArray22[0] = 1;
        nArray22[1] = 1;
        nArray22[2] = 1;
        nArray22[4] = 1;
        nArray22[6] = 1;
        nArrayArray[25] = nArray22;
        int[] nArray23 = new int[8];
        nArray23[0] = 1;
        nArray23[1] = 1;
        nArray23[2] = 1;
        nArray23[4] = 1;
        nArray23[5] = 1;
        nArray23[6] = 1;
        nArrayArray[26] = nArray23;
        int[] nArray24 = new int[8];
        nArray24[0] = 1;
        nArray24[1] = 1;
        nArray24[2] = 1;
        nArray24[3] = 1;
        nArray24[4] = 1;
        nArray24[5] = 1;
        nArray24[6] = 1;
        nArrayArray[27] = nArray24;
        int[] nArray25 = new int[8];
        nArray25[0] = 1;
        nArray25[2] = 1;
        nArray25[4] = 1;
        nArray25[6] = 1;
        nArrayArray[28] = nArray25;
        int[] nArray26 = new int[8];
        nArray26[0] = 1;
        nArray26[1] = 1;
        nArray26[2] = 1;
        nArray26[4] = 1;
        nArray26[6] = 1;
        nArrayArray[29] = nArray26;
        int[] nArray27 = new int[8];
        nArray27[0] = 1;
        nArray27[1] = 1;
        nArray27[2] = 1;
        nArray27[4] = 1;
        nArray27[5] = 1;
        nArray27[6] = 1;
        nArrayArray[30] = nArray27;
        int[] nArray28 = new int[8];
        nArray28[0] = 1;
        nArray28[1] = 1;
        nArray28[2] = 1;
        nArray28[3] = 1;
        nArray28[4] = 1;
        nArray28[5] = 1;
        nArray28[6] = 1;
        nArrayArray[31] = nArray28;
        int[] nArray29 = new int[8];
        nArray29[0] = 1;
        nArray29[2] = 1;
        nArray29[4] = 1;
        nArray29[6] = 1;
        nArrayArray[32] = nArray29;
        int[] nArray30 = new int[8];
        nArray30[0] = 1;
        nArray30[1] = 1;
        nArray30[2] = 1;
        nArray30[4] = 1;
        nArray30[6] = 1;
        nArrayArray[33] = nArray30;
        int[] nArray31 = new int[8];
        nArray31[0] = 1;
        nArray31[1] = 1;
        nArray31[2] = 1;
        nArray31[4] = 1;
        nArray31[5] = 1;
        nArray31[6] = 1;
        nArrayArray[34] = nArray31;
        int[] nArray32 = new int[8];
        nArray32[0] = 1;
        nArray32[1] = 1;
        nArray32[2] = 1;
        nArray32[3] = 1;
        nArray32[4] = 1;
        nArray32[5] = 1;
        nArray32[6] = 1;
        nArrayArray[35] = nArray32;
        int[] nArray33 = new int[8];
        nArray33[0] = 1;
        nArray33[2] = 1;
        nArray33[4] = 1;
        nArray33[6] = 1;
        nArrayArray[36] = nArray33;
        int[] nArray34 = new int[8];
        nArray34[0] = 1;
        nArray34[1] = 1;
        nArray34[2] = 1;
        nArray34[4] = 1;
        nArray34[6] = 1;
        nArrayArray[37] = nArray34;
        int[] nArray35 = new int[8];
        nArray35[0] = 1;
        nArray35[1] = 1;
        nArray35[2] = 1;
        nArray35[4] = 1;
        nArray35[5] = 1;
        nArray35[6] = 1;
        nArrayArray[38] = nArray35;
        int[] nArray36 = new int[8];
        nArray36[0] = 1;
        nArray36[1] = 1;
        nArray36[2] = 1;
        nArray36[3] = 1;
        nArray36[4] = 1;
        nArray36[5] = 1;
        nArray36[6] = 1;
        nArrayArray[39] = nArray36;
        int[] nArray37 = new int[8];
        nArray37[0] = 1;
        nArray37[2] = 1;
        nArray37[4] = 1;
        nArray37[6] = 1;
        nArrayArray[40] = nArray37;
        int[] nArray38 = new int[8];
        nArray38[0] = 1;
        nArray38[1] = 1;
        nArray38[2] = 1;
        nArray38[4] = 1;
        nArray38[6] = 1;
        nArrayArray[41] = nArray38;
        int[] nArray39 = new int[8];
        nArray39[0] = 1;
        nArray39[1] = 1;
        nArray39[2] = 1;
        nArray39[4] = 1;
        nArray39[5] = 1;
        nArray39[6] = 1;
        nArrayArray[42] = nArray39;
        int[] nArray40 = new int[8];
        nArray40[0] = 1;
        nArray40[1] = 1;
        nArray40[2] = 1;
        nArray40[3] = 1;
        nArray40[4] = 1;
        nArray40[5] = 1;
        nArray40[6] = 1;
        nArrayArray[43] = nArray40;
        int[] nArray41 = new int[8];
        nArray41[0] = 1;
        nArray41[2] = 1;
        nArray41[4] = 1;
        nArray41[6] = 1;
        nArrayArray[44] = nArray41;
        int[] nArray42 = new int[8];
        nArray42[0] = 1;
        nArray42[1] = 1;
        nArray42[2] = 1;
        nArray42[4] = 1;
        nArray42[6] = 1;
        nArrayArray[45] = nArray42;
        int[] nArray43 = new int[8];
        nArray43[0] = 1;
        nArray43[1] = 1;
        nArray43[2] = 1;
        nArray43[4] = 1;
        nArray43[5] = 1;
        nArray43[6] = 1;
        nArrayArray[46] = nArray43;
        int[] nArray44 = new int[8];
        nArray44[0] = 1;
        nArray44[1] = 1;
        nArray44[2] = 1;
        nArray44[3] = 1;
        nArray44[4] = 1;
        nArray44[5] = 1;
        nArray44[6] = 1;
        nArrayArray[47] = nArray44;
        nArrayArray[48] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        nArrayArray[49] = new int[]{2, 1, 1, 1, 2, 1, 1, 1};
        nArrayArray[50] = new int[]{2, 1, 2, 1, 2, 1, 2, 1};
        nArrayArray[51] = new int[]{2, 2, 2, 1, 2, 2, 2, 1};
        nArrayArray[52] = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
        nArrayArray[53] = new int[]{4, 2, 2, 2, 4, 2, 2, 2};
        nArrayArray[54] = new int[]{4, 2, 4, 2, 4, 2, 4, 2};
        nArrayArray[55] = new int[]{4, 4, 4, 2, 4, 4, 4, 2};
        nArrayArray[56] = new int[]{4, 4, 4, 4, 4, 4, 4, 4};
        nArrayArray[57] = new int[]{8, 4, 4, 4, 8, 4, 4, 4};
        nArrayArray[58] = new int[]{8, 4, 8, 4, 8, 4, 8, 4};
        nArrayArray[59] = new int[]{8, 8, 8, 4, 8, 8, 8, 4};
        nArrayArray[60] = new int[]{16, 16, 16, 16, 16, 16, 16, 16};
        nArrayArray[61] = new int[]{16, 16, 16, 16, 16, 16, 16, 16};
        nArrayArray[62] = new int[]{16, 16, 16, 16, 16, 16, 16, 16};
        nArrayArray[63] = new int[]{16, 16, 16, 16, 16, 16, 16, 16};
        this.decaytable1 = nArrayArray;
        this.decaytable2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2047, 2047, 2047, 2047, 2047};
        this.attacktable = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1}, {4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, -1, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, -1, 4, -1}, {4, 4, 4, -1, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, -1}, {4, 4, 4, 4, 4, 4, 4, 4}, {3, 4, 4, 4, 3, 4, 4, 4}, {3, 4, 3, 4, 3, 4, 3, 4}, {3, 3, 3, 4, 3, 3, 3, 4}, {3, 3, 3, 3, 3, 3, 3, 3}, {2, 3, 3, 3, 2, 3, 3, 3}, {2, 3, 2, 3, 2, 3, 2, 3}, {2, 2, 2, 3, 2, 2, 2, 3}, {2, 2, 2, 2, 2, 2, 2, 2}, {1, 2, 2, 2, 1, 2, 2, 2}, {1, 2, 1, 2, 1, 2, 1, 2}, {1, 1, 1, 2, 1, 1, 1, 2}, new int[8], new int[8], new int[8], new int[8]};
        int[][][][] nArrayArray2 = new int[8][][][];
        int[][][] nArrayArray3 = new int[2][][];
        nArrayArray3[0] = new int[][]{{1, 1}, {1, 1}, {1, 1}};
        int[][] nArrayArray4 = new int[3][];
        int[] nArray45 = new int[2];
        nArray45[1] = 1;
        nArrayArray4[0] = nArray45;
        nArrayArray4[1] = new int[]{1, 1};
        nArrayArray4[2] = new int[]{1, 1};
        nArrayArray3[1] = nArrayArray4;
        nArrayArray2[0] = nArrayArray3;
        int[][][] nArrayArray5 = new int[2][][];
        int[][] nArrayArray6 = new int[3][];
        int[] nArray46 = new int[2];
        nArray46[1] = 1;
        nArrayArray6[0] = nArray46;
        int[] nArray47 = new int[2];
        nArray47[0] = 2;
        nArrayArray6[1] = nArray47;
        int[] nArray48 = new int[2];
        nArray48[0] = 2;
        nArrayArray6[2] = nArray48;
        nArrayArray5[0] = nArrayArray6;
        int[][] nArrayArray7 = new int[3][];
        int[] nArray49 = new int[2];
        nArray49[1] = 1;
        nArrayArray7[0] = nArray49;
        int[] nArray50 = new int[2];
        nArray50[0] = 2;
        nArrayArray7[1] = nArray50;
        int[] nArray51 = new int[2];
        nArray51[0] = 2;
        nArrayArray7[2] = nArray51;
        nArrayArray5[1] = nArrayArray7;
        nArrayArray2[1] = nArrayArray5;
        int[][][] nArrayArray8 = new int[2][][];
        int[][] nArrayArray9 = new int[3][];
        nArrayArray9[0] = new int[]{1, -1};
        int[] nArray52 = new int[2];
        nArray52[1] = 1;
        nArrayArray9[1] = nArray52;
        nArrayArray9[2] = new int[]{1, -1};
        nArrayArray8[0] = nArrayArray9;
        int[][] nArrayArray10 = new int[3][];
        int[] nArray53 = new int[2];
        nArray53[1] = 1;
        nArrayArray10[0] = nArray53;
        nArrayArray10[1] = new int[]{1, -1};
        int[] nArray54 = new int[2];
        nArray54[1] = 1;
        nArrayArray10[2] = nArray54;
        nArrayArray8[1] = nArrayArray10;
        nArrayArray2[2] = nArrayArray8;
        int[][][] nArrayArray11 = new int[2][][];
        nArrayArray11[0] = new int[][]{{1, -1}, new int[2], new int[2]};
        int[][] nArrayArray12 = new int[3][];
        int[] nArray55 = new int[2];
        nArray55[1] = 1;
        nArrayArray12[0] = nArray55;
        nArrayArray12[1] = new int[2];
        nArrayArray12[2] = new int[2];
        nArrayArray11[1] = nArrayArray12;
        nArrayArray2[3] = nArrayArray11;
        nArrayArray2[4] = new int[][][]{new int[][]{{2, -1}, {2, -1}, {2, -1}}, new int[][]{{1, -1}, {2, -1}, {2, -1}}};
        nArrayArray2[5] = new int[][][]{new int[][]{{1, -1}, new int[2], new int[2]}, new int[][]{{1, -1}, new int[2], new int[2]}};
        int[][][] nArrayArray13 = new int[2][][];
        int[][] nArrayArray14 = new int[3][];
        int[] nArray56 = new int[2];
        nArray56[1] = 1;
        nArrayArray14[0] = nArray56;
        nArrayArray14[1] = new int[]{1, -1};
        int[] nArray57 = new int[2];
        nArray57[1] = 1;
        nArrayArray14[2] = nArray57;
        nArrayArray13[0] = nArrayArray14;
        int[][] nArrayArray15 = new int[3][];
        nArrayArray15[0] = new int[]{1, -1};
        int[] nArray58 = new int[2];
        nArray58[1] = 1;
        nArrayArray15[1] = nArray58;
        nArrayArray15[2] = new int[]{1, -1};
        nArrayArray13[1] = nArrayArray15;
        nArrayArray2[6] = nArrayArray13;
        int[][][] nArrayArray16 = new int[2][][];
        int[][] nArrayArray17 = new int[3][];
        int[] nArray59 = new int[2];
        nArray59[1] = 1;
        nArrayArray17[0] = nArray59;
        int[] nArray60 = new int[2];
        nArray60[0] = 2;
        nArrayArray17[1] = nArray60;
        int[] nArray61 = new int[2];
        nArray61[0] = 2;
        nArrayArray17[2] = nArray61;
        nArrayArray16[0] = nArrayArray17;
        int[][] nArrayArray18 = new int[3][];
        nArrayArray18[0] = new int[]{1, -1};
        int[] nArray62 = new int[2];
        nArray62[0] = 2;
        nArrayArray18[1] = nArray62;
        int[] nArray63 = new int[2];
        nArray63[0] = 2;
        nArrayArray18[2] = nArray63;
        nArrayArray16[1] = nArrayArray18;
        nArrayArray2[7] = nArrayArray16;
        this.ssgenvtable = nArrayArray2;
        this.pmtable = new int[2][8][256];
        this.amtable = new int[2][4][256];
        this.tablemade = false;
        this.tablehasmade = false;
        this.sinetable = new int[1024];
        this.cltable = new int[8192];
        this.pms = new double[][]{{0.0, 0.002777777777777778, 0.005555555555555556, 0.008333333333333333, 0.011111111111111112, 0.016666666666666666, 0.03333333333333333, 0.06666666666666667}, {0.0, 0.0020833333333333333, 0.004166666666666667, 0.008333333333333333, 0.020833333333333332, 0.041666666666666664, 0.16666666666666666, 0.2916666666666667}};
        int[][] nArrayArray19 = new int[2][];
        nArrayArray19[0] = new int[]{31, 6, 4, 3};
        int[] nArray64 = new int[4];
        nArray64[0] = 31;
        nArray64[1] = 2;
        nArray64[2] = 1;
        nArrayArray19[1] = nArray64;
        this.amt = nArrayArray19;
        this.IS2EC_SHIFT = 16;
        if (!this.tablehasmade) {
            this.MakeTable();
        }
        this.key_scale_rate_ = 0;
        this.rr_ = 0;
        this.sr_ = 0;
        this.dr_ = 0;
        this.ar_ = 0;
        this.ams_ = this.amtable[0][0];
        this.mute_ = false;
        this.keyon_ = false;
        this.tl_out_ = 0;
        this.ssg_type_ = 0;
        this.multiple_ = 0;
        this.detune_ = 0;
        this.detune2_ = 0;
        this.ms_ = 0;
    }

    void Reset() {
        this.tl_latch_ = 127;
        this.tl_ = 127;
        this.ShiftPhase(5);
        this.eg_count_ = 0;
        this.eg_curve_count_ = 0;
        this.ssg_phase_ = 0;
        this.pg_count_ = 0;
        this.out2_ = 0;
        this.out_ = 0;
        this.param_changed_ = true;
    }

    private void MakeTable() {
        int[] p = this.cltable;
        int pidx = 0;
        int i = 0;
        while (i < 256) {
            int v = (int)Math.floor(Math.pow(2.0, 13.0 - (double)i / 256.0));
            v = v + 2 & 0xFFFFFFFC;
            p[pidx++] = v;
            p[pidx++] = -v;
            ++i;
        }
        while (pidx < 8192) {
            p[pidx] = p[pidx - 512] / 2;
            ++pidx;
        }
        double log2 = Math.log(2.0);
        i = 0;
        while (i < 512) {
            double r = (double)(i * 2 + 1) * Math.PI / 1024.0;
            double q = -256.0 * Math.log(Math.sin(r)) / log2;
            int s = (int)Math.floor(q + 0.5) + 1;
            this.sinetable[i] = s * 2;
            this.sinetable[512 + i] = s * 2 + 1;
            ++i;
        }
        this.MakeLFOTable();
        this.tablehasmade = true;
    }

    private void MakeLFOTable() {
        if (this.tablemade) {
            return;
        }
        this.tablemade = true;
        int type = 0;
        while (type < 2) {
            int i = 0;
            while (i < 8) {
                double pmb = this.pms[type][i];
                int j = 0;
                while (j < 256) {
                    double w = 0.6 * pmb * Math.sin((double)(2 * j) * Math.PI / 256.0) + 1.0;
                    this.pmtable[type][i][j] = (int)(65536.0 * (w - 1.0));
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 4) {
                int j = 0;
                while (j < 256) {
                    this.amtable[type][i][j] = (j * 4 >> this.amt[type][i]) * 2 << 2;
                    ++j;
                }
                ++i;
            }
            ++type;
        }
    }

    void SetDPBN(int dp, int bn) {
        this.dp_ = dp;
        this.bn_ = bn;
        this.param_changed_ = true;
    }

    void Prepare() {
        if (this.param_changed_) {
            this.param_changed_ = false;
            this.pg_diff_ = (this.dp_ + this.dttable[this.detune_ + this.bn_]) * this.chip_.GetMulValue(this.detune2_, this.multiple_);
            this.pg_diff_lfo_ = this.pg_diff_ >>> 11;
            this.key_scale_rate_ = this.bn_ >>> 3 - this.ks_;
            this.tl_out_ = this.mute_ ? 1023 : this.tl_ * 8;
            switch (this.eg_phase_) {
                case 1: {
                    this.SetEGRate(this.ar_ != 0 ? Math.min(63, this.ar_ + this.key_scale_rate_) : 0);
                    break;
                }
                case 2: {
                    this.SetEGRate(this.dr_ != 0 ? Math.min(63, this.dr_ + this.key_scale_rate_) : 0);
                    this.eg_level_on_next_phase_ = this.sl_ * 8;
                    break;
                }
                case 3: {
                    this.SetEGRate(this.sr_ != 0 ? Math.min(63, this.sr_ + this.key_scale_rate_) : 0);
                    break;
                }
                case 4: {
                    this.SetEGRate(Math.min(63, this.rr_ + this.key_scale_rate_));
                }
            }
            if (this.ssg_type_ != 0 && this.eg_phase_ != 4) {
                int m;
                int n = m = this.ar_ >= (this.ssg_type_ == 8 || this.ssg_type_ == 12 ? 56 : 60) ? 1 : 0;
                if (this.ssg_phase_ == -1) {
                    this.ssg_phase_ = 0;
                }
                int[] table = this.ssgenvtable[this.ssg_type_ & 7][m][this.ssg_phase_];
                this.ssg_offset_ = table[0] * 512;
                this.ssg_vector_ = table[1];
            }
            this.ams_ = this.amtable[this.type_][this.amon_ ? this.ms_ >>> 4 & 3 : 0];
            this.EGUpdate();
        }
    }

    private void ShiftPhase(int nextphase) {
        switch (nextphase) {
            case 1: {
                this.tl_ = this.tl_latch_;
                if (this.ssg_type_ != 0) {
                    ++this.ssg_phase_;
                    if (this.ssg_phase_ > 2) {
                        this.ssg_phase_ = 1;
                    }
                    int m = this.ar_ >= (this.ssg_type_ == 8 || this.ssg_type_ == 12 ? 56 : 60) ? 1 : 0;
                    int[] table = this.ssgenvtable[this.ssg_type_ & 7][m][this.ssg_phase_];
                    this.ssg_offset_ = table[0] * 512;
                    this.ssg_vector_ = table[1];
                }
                if (this.ar_ + this.key_scale_rate_ < 62) {
                    this.SetEGRate(this.ar_ != 0 ? Math.min(63, this.ar_ + this.key_scale_rate_) : 0);
                    this.eg_phase_ = 1;
                    break;
                }
            }
            case 2: {
                if (this.sl_ != 0) {
                    this.eg_level_ = 0;
                    this.eg_level_on_next_phase_ = this.ssg_type_ != 0 ? Math.min(this.sl_ * 8, 512) : this.sl_ * 8;
                    this.SetEGRate(this.dr_ != 0 ? Math.min(63, this.dr_ + this.key_scale_rate_) : 0);
                    this.eg_phase_ = 2;
                    break;
                }
            }
            case 3: {
                this.eg_level_ = this.sl_ * 8;
                this.eg_level_on_next_phase_ = this.ssg_type_ != 0 ? 512 : 1024;
                this.SetEGRate(this.sr_ != 0 ? Math.min(63, this.sr_ + this.key_scale_rate_) : 0);
                this.eg_phase_ = 3;
                break;
            }
            case 4: {
                if (this.ssg_type_ != 0) {
                    this.eg_level_ = this.eg_level_ * this.ssg_vector_ + this.ssg_offset_;
                    this.ssg_vector_ = 1;
                    this.ssg_offset_ = 0;
                }
                if (this.eg_phase_ == 1 || this.eg_level_ < 955) {
                    this.eg_level_on_next_phase_ = 1024;
                    this.SetEGRate(Math.min(63, this.rr_ + this.key_scale_rate_));
                    this.eg_phase_ = 4;
                    break;
                }
            }
            default: {
                this.eg_level_ = 955;
                this.eg_level_on_next_phase_ = 955;
                this.EGUpdate();
                this.SetEGRate(0);
                this.eg_phase_ = 5;
            }
        }
    }

    void SetFNum(int f) {
        this.dp_ = (f & 0x7FF) << (f >>> 11 & 7);
        this.bn_ = this.notetable[f >>> 7 & 0x7F];
        this.param_changed_ = true;
    }

    private int SINE(int s) {
        return this.sinetable[s & 0x3FF];
    }

    private int LogToLin(int a) {
        return a < 8192 ? this.cltable[a] : 0;
    }

    private void EGUpdate() {
        this.eg_out_ = this.ssg_type_ == 0 ? Math.min(this.tl_out_ + this.eg_level_, 1023) << 3 : Math.max(0, Math.min(this.tl_out_ + this.eg_level_ * this.ssg_vector_ + this.ssg_offset_, 1023) << 3);
    }

    private void SetEGRate(int rate) {
        this.eg_rate_ = rate;
        this.eg_count_diff_ = this.decaytable2[rate / 4] * this.chip_.GetRatio();
    }

    private void EGCalc() {
        this.eg_count_ = 786048;
        if (this.eg_phase_ == 1) {
            int c = this.attacktable[this.eg_rate_][this.eg_curve_count_ & 7];
            if (c >= 0) {
                this.eg_level_ -= 1 + (this.eg_level_ >> c);
                if (this.eg_level_ <= 0) {
                    this.ShiftPhase(2);
                }
            }
            this.EGUpdate();
        } else if (this.ssg_type_ == 0) {
            this.eg_level_ += this.decaytable1[this.eg_rate_][this.eg_curve_count_ & 7];
            if (this.eg_level_ >= this.eg_level_on_next_phase_) {
                this.ShiftPhase(this.eg_phase_ + 1);
            }
            this.EGUpdate();
        } else {
            this.eg_level_ += 4 * this.decaytable1[this.eg_rate_][this.eg_curve_count_ & 7];
            if (this.eg_level_ >= this.eg_level_on_next_phase_) {
                this.EGUpdate();
                switch (this.eg_phase_) {
                    case 2: {
                        this.ShiftPhase(3);
                        break;
                    }
                    case 3: {
                        this.ShiftPhase(1);
                        break;
                    }
                    case 4: {
                        this.ShiftPhase(5);
                    }
                }
            }
        }
        ++this.eg_curve_count_;
    }

    private void EGStep() {
        this.eg_count_ -= this.eg_count_diff_;
        if (this.eg_count_ <= 0) {
            this.EGCalc();
        }
    }

    private int PGCalc() {
        int ret = this.pg_count_;
        this.pg_count_ += this.pg_diff_;
        return ret;
    }

    private int PGCalcL() {
        int ret = this.pg_count_;
        this.pg_count_ += this.pg_diff_ + (this.pg_diff_lfo_ * this.chip_.GetPMV() >> 5);
        return ret;
    }

    int Calc(int in) {
        this.EGStep();
        this.out2_ = this.out_;
        int pgin = this.PGCalc() >>> 19;
        this.out_ = this.LogToLin(this.eg_out_ + this.SINE(pgin += in >> 1));
        return this.out_;
    }

    int CalcL(int in) {
        this.EGStep();
        int pgin = this.PGCalcL() >>> 19;
        this.out_ = this.LogToLin(this.eg_out_ + this.SINE(pgin += in >> 1) + this.ams_[this.chip_.GetAML()]);
        return this.out_;
    }

    int CalcN(int noise) {
        this.EGStep();
        int lv = Math.max(0, 1023 - (this.tl_out_ + this.eg_level_)) << 1;
        noise = (noise & 1) - 1;
        this.out_ = lv + noise ^ noise;
        return this.out_;
    }

    int CalcFB(int fb) {
        this.EGStep();
        int in = this.out_ + this.out2_;
        this.out2_ = this.out_;
        int pgin = this.PGCalc() >>> 19;
        if (fb < 31) {
            pgin += in << 17 >> fb >> 19;
        }
        this.out_ = this.LogToLin(this.eg_out_ + this.SINE(pgin));
        return this.out2_;
    }

    int CalcFBL(int fb) {
        this.EGStep();
        int in = this.out_ + this.out2_;
        this.out2_ = this.out_;
        int pgin = this.PGCalcL() >>> 19;
        if (fb < 31) {
            pgin += in << 17 >> fb >> 19;
        }
        this.out_ = this.LogToLin(this.eg_out_ + this.SINE(pgin) + this.ams_[this.chip_.GetAML()]);
        return this.out_;
    }

    void ResetFB() {
        this.out2_ = 0;
        this.out_ = 0;
    }

    void KeyOn() {
        if (!this.keyon_) {
            this.keyon_ = true;
            if (this.eg_phase_ == 5 || this.eg_phase_ == 4) {
                this.ssg_phase_ = -1;
                this.ShiftPhase(1);
                this.EGUpdate();
                this.out2_ = 0;
                this.out_ = 0;
                this.in2_ = 0;
                this.pg_count_ = 0;
            }
        }
    }

    void KeyOff() {
        if (this.keyon_) {
            this.keyon_ = false;
            this.ShiftPhase(4);
        }
    }

    int IsOn() {
        return this.eg_phase_ - 5;
    }

    void SetDT(int dt) {
        this.detune_ = dt * 32;
        this.param_changed_ = true;
    }

    void SetDT2(int dt2) {
        this.detune2_ = dt2 & 3;
        this.param_changed_ = true;
    }

    void SetMULTI(int mul) {
        this.multiple_ = mul;
        this.param_changed_ = true;
    }

    void SetTL(int tl, boolean csm) {
        if (!csm) {
            this.tl_ = tl;
            this.param_changed_ = true;
        }
        this.tl_latch_ = tl;
    }

    void SetAR(int ar) {
        this.ar_ = ar;
        this.param_changed_ = true;
    }

    void SetDR(int dr) {
        this.dr_ = dr;
        this.param_changed_ = true;
    }

    void SetSR(int sr) {
        this.sr_ = sr;
        this.param_changed_ = true;
    }

    void SetSL(int sl) {
        this.sl_ = sl;
        this.param_changed_ = true;
    }

    void SetRR(int rr) {
        this.rr_ = rr;
        this.param_changed_ = true;
    }

    void SetKS(int ks) {
        this.ks_ = ks;
        this.param_changed_ = true;
    }

    void SetSSGEC(int ssgec) {
        this.ssg_type_ = (ssgec & 8) != 0 ? ssgec : 0;
    }

    void SetAMON(boolean amon) {
        this.amon_ = amon;
        this.param_changed_ = true;
    }

    void Mute(boolean mute) {
        this.mute_ = mute;
        this.param_changed_ = true;
    }

    void SetMS(int ms) {
        this.ms_ = ms;
        this.param_changed_ = true;
    }

    void SetChip(Chip chip) {
        this.chip_ = chip;
    }

    int Out() {
        return this.out_;
    }
}

