/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class IniFile {
    private String ini = null;
    private Vector<String> entries = null;

    public IniFile(String ini) {
        this.ini = ini;
        this.entries = new Vector();
    }

    public void init() {
        this.entries.clear();
    }

    public boolean load() {
        boolean valid = false;
        BufferedReader reader = null;
        try {
            try {
                String line;
                reader = new BufferedReader(new FileReader(this.ini));
                while ((line = reader.readLine()) != null) {
                    this.entries.add(line);
                }
                valid = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (IOException iOException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return valid;
    }

    public boolean save() {
        boolean result = false;
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(this.ini));
                int i = 0;
                while (i < this.entries.size()) {
                    String line = this.entries.get(i);
                    writer.write(line, 0, line.length());
                    writer.newLine();
                    ++i;
                }
                result = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (IOException iOException) {
                try {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private String get(String section, String key) {
        String secstr = "[" + section + "]";
        String keystr = String.valueOf(key) + "=";
        boolean inner = false;
        int i = 0;
        while (i < this.entries.size()) {
            String line = this.entries.get(i);
            if (inner) {
                if (line.startsWith(keystr)) {
                    return line.substring(keystr.length());
                }
                if (line.startsWith("[")) {
                    inner = false;
                }
            }
            if (line.equals(secstr)) {
                inner = true;
            }
            ++i;
        }
        return null;
    }

    public void set(String section, String key, String value) {
        String secstr = "[" + section + "]";
        String keystr = String.valueOf(key) + "=";
        boolean inner = false;
        int i = 0;
        while (i < this.entries.size()) {
            String line = this.entries.get(i);
            if (inner) {
                if (line.startsWith(keystr)) {
                    this.entries.set(i, String.valueOf(keystr) + value);
                    return;
                }
                if (line.startsWith("[")) {
                    this.entries.add(i, String.valueOf(keystr) + value);
                    return;
                }
            }
            if (line.equals(secstr)) {
                inner = true;
            }
            ++i;
        }
        if (!inner) {
            this.entries.add(secstr);
        }
        this.entries.add(String.valueOf(keystr) + value);
    }

    public void clearSection(String section) {
        String secstr = "[" + section + "]";
        boolean inner = false;
        int i = 0;
        while (i < this.entries.size()) {
            String line = this.entries.get(i);
            if (inner) {
                if (line.startsWith("[")) {
                    return;
                }
                this.entries.remove(i);
            }
            if (line.equals(secstr)) {
                inner = true;
                this.entries.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void clearKey(String section, String key) {
        String secstr = "[" + section + "]";
        String keystr = String.valueOf(key) + "=";
        boolean inner = false;
        int i = 0;
        while (i < this.entries.size()) {
            String line = this.entries.get(i);
            if (inner) {
                if (line.startsWith(keystr)) {
                    this.entries.remove(i);
                    return;
                }
                if (line.startsWith("[")) {
                    return;
                }
            }
            if (line.equals(secstr)) {
                inner = true;
            }
            ++i;
        }
    }

    public boolean getBool(String section, String key, boolean value) {
        String str = this.get(section, key);
        if (str == null || str.equals("")) {
            return value;
        }
        return !str.equals("0");
    }

    public void setBool(String section, String key, boolean value) {
        this.set(section, key, value ? "1" : "0");
    }

    public int getInt(String section, String key, int defvalue) {
        String str = this.get(section, key);
        if (str == null) {
            return defvalue;
        }
        return Integer.parseInt(str);
    }

    public void setInt(String section, String key, int value) {
        this.set(section, key, Integer.toString(value));
    }

    public String getString(String section, String key, String defvalue) {
        String str = this.get(section, key);
        if (str == null) {
            return defvalue;
        }
        return str;
    }

    public void setString(String section, String key, String value) {
        this.set(section, key, value);
    }
}

