/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Dmac
extends Base
implements EventHandler {
    private int[] dma_adr = new int[4];
    private int[] dma_bcr = new int[4];
    private int[] dma_chcr = new int[4];
    private int dma_dcr;
    private int dma_pcr;
    private int dma_icr;
    private int dma_reg;
    boolean dma_flag;
    private final int dmac_start_ch0 = 0;
    private IntHolder wdat = new IntHolder();

    Dmac() {
    }

    boolean init() {
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        int i = 0;
        while (i < 4) {
            this.dma_adr[i] = 65535;
            this.dma_bcr[i] = 65535;
            this.dma_chcr[i] = 0;
            ++i;
        }
        this.dma_pcr = 0;
        this.dma_icr = 0;
        this.dma_dcr = 0;
        this.dma_reg = 0;
        this.dma_flag = false;
    }

    void start() {
        if (Dmac.vm.fm7_ver < 3) {
            return;
        }
        if (this.dma_flag) {
            return;
        }
        if (this.dma_bcr[0] == 0) {
            return;
        }
        if ((this.dma_pcr & 1) == 0) {
            return;
        }
        schedule.setevent(19, 50, this, 0);
    }

    @Override
    public boolean event(int callbackid) {
        schedule.delevent(19);
        this.dma_flag = true;
        this.dma_chcr[0] = this.dma_chcr[0] & 0xF | 0x40;
        return true;
    }

    void exec() {
        block9: {
            IntHolder dat = this.wdat;
            if ((this.dma_pcr & 1) == 0) {
                return;
            }
            if (this.dma_bcr[0] == 0) {
                this.dma_flag = false;
                this.dma_chcr[0] = this.dma_chcr[0] & 0xF | 0x80;
                return;
            }
            fdc.readb(64799, dat);
            if ((dat.value & 0x80) == 0) {
                return;
            }
            do {
                int seg = Dmac.mmr.mmr_seg;
                Dmac.mmr.mmr_seg = 0;
                if ((this.dma_chcr[0] & 1) != 0) {
                    dat.value = mainmem.readb(this.dma_adr[0]);
                    fdc.writeb(64795, dat.value);
                } else {
                    fdc.readb(64795, dat);
                    mainmem.writeb(this.dma_adr[0], dat.value);
                }
                Dmac.mmr.mmr_seg = seg;
                this.dma_adr[0] = (this.dma_chcr[0] & 8) != 0 ? this.dma_adr[0] - 1 : this.dma_adr[0] + 1;
                this.dma_bcr[0] = this.dma_bcr[0] - 1;
                if (this.dma_bcr[0] == 0) {
                    this.dma_flag = false;
                    this.dma_chcr[0] = this.dma_chcr[0] & 0xF | 0x80;
                    this.dma_dcr |= 0x10;
                    if ((this.dma_icr & 1) != 0) {
                        this.dma_icr |= 0x80;
                        Dmac.mainetc.dma_irq_flag = true;
                        maincpu.irq();
                    }
                    return;
                }
                if ((this.dma_chcr[0] & 2) == 0) {
                    Dmac.maincpu.total += 3;
                    break block9;
                }
                fdc.readb(64799, dat);
            } while ((dat.value & 0x80) != 0);
            return;
        }
    }

    private int readreg(int addr) {
        switch (addr) {
            case 0: {
                return this.dma_adr[0] >> 8 & 0xFF;
            }
            case 1: {
                return this.dma_adr[0] & 0xFF;
            }
            case 2: {
                return this.dma_bcr[0] >> 8 & 0xFF;
            }
            case 3: {
                return this.dma_bcr[0] & 0xFF;
            }
            case 16: {
                int tmp = this.dma_chcr[0];
                this.dma_chcr[0] = this.dma_chcr[0] & 0x7F;
                return tmp;
            }
            case 20: {
                return this.dma_pcr;
            }
            case 21: {
                int tmp = (this.dma_dcr >> 4 | 0x80) & this.dma_icr;
                this.dma_dcr &= 0xF;
                this.dma_icr &= 0xFFFFFF7F;
                Dmac.mainetc.dma_irq_flag = false;
                maincpu.irq();
                return tmp;
            }
            case 22: {
                return this.dma_dcr & 0xF;
            }
        }
        return 0;
    }

    private void writereg(int addr, int dat) {
        switch (addr) {
            case 0: 
            case 4: 
            case 8: 
            case 12: {
                this.dma_adr[addr >> 2] = this.dma_adr[addr >> 2] & 0xFF | dat << 8;
                return;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                this.dma_adr[addr >> 2] = this.dma_adr[addr >> 2] & 0xFF00 | dat;
                return;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                this.dma_bcr[addr >> 2] = this.dma_bcr[addr >> 2] & 0xFF | dat << 8;
                return;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                this.dma_bcr[addr >> 2] = this.dma_bcr[addr >> 2] & 0xFF00 | dat;
                return;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.dma_chcr[addr - 16] = this.dma_chcr[addr - 16] & 0xC0 | dat & 0xF;
                return;
            }
            case 20: {
                this.dma_pcr = dat & 0x8F;
                return;
            }
            case 21: {
                this.dma_icr = this.dma_icr & 0x80 | dat & 0xF;
                return;
            }
            case 22: {
                this.dma_dcr = this.dma_dcr & 0xF0 | dat & 0xF;
                return;
            }
        }
    }

    boolean readb(int addr, IntHolder dat) {
        if (Dmac.vm.fm7_ver < 3) {
            return false;
        }
        switch (addr) {
            case 64920: {
                dat.value = this.dma_reg;
                return true;
            }
            case 64921: {
                dat.value = this.readreg(this.dma_reg);
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        if (Dmac.vm.fm7_ver < 3) {
            return false;
        }
        switch (addr) {
            case 64920: {
                this.dma_reg = dat & 0x1F;
                return true;
            }
            case 64921: {
                this.writereg(this.dma_reg, dat);
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.word_write(fileh, this.dma_adr[0])) {
            return false;
        }
        if (!File.word_write(fileh, this.dma_bcr[0])) {
            return false;
        }
        if (!File.byte_write(fileh, this.dma_chcr[0])) {
            return false;
        }
        if (!File.byte_write(fileh, this.dma_pcr)) {
            return false;
        }
        if (!File.byte_write(fileh, this.dma_icr)) {
            return false;
        }
        if (!File.byte_write(fileh, this.dma_reg)) {
            return false;
        }
        if (!File.bool_write(fileh, this.dma_flag)) {
            return false;
        }
        return File.byte_write(fileh, this.dma_dcr);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 800) {
            this.reset();
            return true;
        }
        try {
            this.dma_adr[0] = File.word_read(fileh);
            this.dma_bcr[0] = File.word_read(fileh);
            this.dma_chcr[0] = File.byte_read(fileh);
            this.dma_pcr = File.byte_read(fileh);
            this.dma_icr = File.byte_read(fileh);
            this.dma_reg = File.byte_read(fileh);
            this.dma_flag = File.bool_read(fileh);
            this.dma_dcr = ver >= 900 ? File.byte_read(fileh) : 8;
            int i = 1;
            while (i < 4) {
                this.dma_adr[i] = 65535;
                this.dma_bcr[i] = 65535;
                this.dma_chcr[i] = 0;
                ++i;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

