/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Tapelp
extends Base
implements EventHandler {
    private boolean tape_in;
    private boolean tape_out;
    public boolean tape_motor;
    public boolean tape_rec;
    public boolean tape_writep;
    int tape_count;
    int tape_subcnt;
    public RandomAccessFile tape_fileh;
    public int tape_offset;
    private String tape_fname;
    private int tape_incnt;
    private int tape_fsize;
    private boolean tape_fetch;
    private int[] tape_savebuf;
    private int tape_saveptr;
    public boolean tape_monitor;
    public boolean tape_sound;
    public boolean lp_use;
    private int lp_data;
    private boolean lp_busy;
    private boolean lp_error;
    private boolean lp_pe;
    private boolean lp_ackng;
    private boolean lp_online;
    private boolean lp_strobe;
    private RandomAccessFile lp_fileh;
    private String lp_fname;
    private final int tape_outsnd = 0;

    Tapelp() {
    }

    boolean init() {
        this.tape_savebuf = null;
        this.tape_fileh = null;
        this.tape_fname = null;
        this.tape_offset = 0;
        this.tape_fsize = 0;
        this.tape_writep = false;
        this.tape_fetch = false;
        this.tape_saveptr = 0;
        this.tape_monitor = false;
        this.tape_motor = false;
        this.tape_sound = false;
        this.lp_use = true;
        this.lp_fileh = null;
        this.lp_setfile("lpr");
        int size = 4096;
        this.tape_savebuf = new int[size];
        return this.tape_savebuf != null;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        assert (this.tape_savebuf != null);
        if (this.tape_fileh != null) {
            this.tape_flush();
            File.close(this.tape_fileh);
            this.tape_fileh = null;
        }
        this.tape_motor = false;
        if (this.lp_fileh != null) {
            Tapelp.sysmain.sys_lpr.closefile();
            this.lp_fileh = null;
        }
        if (this.lp_fileh == null && this.lp_fname != null) {
            Tapelp.sysmain.sys_lpr.removefile();
        }
        if (this.tape_savebuf != null) {
            Util.free(this.tape_savebuf);
        }
    }

    void reset() {
        this.tape_flush();
        if (this.tape_motor && this.tape_sound) {
            Tapelp.sysmain.sys_snd.wav_notify(1);
        }
        this.tape_motor = false;
        this.tape_rec = false;
        this.tape_count = 0;
        this.tape_in = true;
        this.tape_out = false;
        this.tape_incnt = 0;
        this.tape_subcnt = 0;
        this.tape_fetch = false;
        this.lp_busy = false;
        this.lp_error = false;
        this.lp_ackng = true;
        this.lp_pe = false;
        this.lp_online = false;
        this.lp_strobe = false;
    }

    private void lp_output(int dat) {
        if (this.lp_fileh == null && this.lp_fname != null) {
            this.lp_fileh = Tapelp.sysmain.sys_lpr.openfile(this.lp_fname);
        }
        if (this.lp_fileh == null) {
            return;
        }
        Tapelp.sysmain.sys_lpr.writefile(dat);
    }

    public void lp_setfile(String fname) {
        if (this.lp_fileh != null) {
            Tapelp.sysmain.sys_lpr.closefile();
            this.lp_fileh = null;
        }
        if (fname == null) {
            this.lp_fname = null;
            return;
        }
        this.lp_fname = fname;
        if (this.lp_fileh == null && this.lp_fname != null) {
            this.lp_fileh = Tapelp.sysmain.sys_lpr.openfile(this.lp_fname);
        }
    }

    public void lp_print() {
        if (this.lp_use && this.lp_fileh != null) {
            Tapelp.sysmain.sys_lpr.printfile();
        }
    }

    private void tape_flush() {
        if (this.tape_fileh != null && this.tape_rec && this.tape_saveptr > 0) {
            File.write(this.tape_fileh, this.tape_savebuf, this.tape_saveptr);
        }
        this.tape_saveptr = 0;
    }

    private void tape_int_write(int dat) {
        this.tape_savebuf[this.tape_saveptr++] = dat;
        if (this.tape_saveptr >= 4096) {
            this.tape_flush();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tape_input(boolean flag) {
        high = new int[1];
        low = new int[1];
        dat = 0;
        if (!this.tape_motor) {
            return;
        }
        if (this.tape_rec) {
            return;
        }
        if (flag || !this.tape_fetch) ** GOTO lbl37
        return;
lbl-1000:
        // 1 sources

        {
            this.tape_count -= this.tape_incnt;
            this.tape_incnt = 0;
            this.tape_in = false;
            if (this.tape_fileh == null) {
                return;
            }
            if (this.tape_offset >= this.tape_fsize) {
                return;
            }
            if (!File.seek(this.tape_fileh, this.tape_offset)) {
                return;
            }
            if (!File.read(this.tape_fileh, high, 1)) {
                return;
            }
            if (!File.read(this.tape_fileh, low, 1)) {
                return;
            }
            dat = high[0] * 256 + low[0];
            if (dat > 32767) {
                this.tape_in = true;
            }
            v0 = this.tape_fetch = flag == false;
            if (!flag) {
                return;
            }
            this.tape_incnt = dat & 32767;
            if (this.tape_count > this.tape_incnt) {
                this.tape_count -= this.tape_incnt;
                this.tape_incnt = 0;
            } else {
                this.tape_incnt -= this.tape_count;
                this.tape_count = 0;
            }
            this.tape_offset += 2;
lbl37:
            // 2 sources

            ** while (this.tape_count >= this.tape_incnt)
        }
lbl38:
        // 1 sources

    }

    private void tape_output(boolean flag) {
        if (!this.tape_motor) {
            return;
        }
        if (!this.tape_rec) {
            return;
        }
        if (this.tape_count == 0) {
            return;
        }
        if (this.tape_writep) {
            return;
        }
        int dat = this.tape_count;
        if (dat >= 32768) {
            dat = Short.MAX_VALUE;
        }
        if (flag) {
            dat |= 0x8000;
        }
        int high = dat >> 8;
        int low = dat & 0xFF;
        if (this.tape_fileh != null) {
            this.tape_int_write(high);
            this.tape_int_write(low);
            this.tape_offset += 2;
            if (this.tape_offset >= this.tape_fsize) {
                this.tape_fsize = this.tape_offset;
            }
        }
        this.tape_count = 0;
        this.tape_subcnt = 0;
    }

    private void tape_mark() {
        if (!this.tape_motor) {
            return;
        }
        if (!this.tape_rec) {
            return;
        }
        if (this.tape_writep) {
            return;
        }
        if (this.tape_fileh != null) {
            this.tape_int_write(0);
            this.tape_int_write(0);
            this.tape_offset += 2;
            if (this.tape_offset >= this.tape_fsize) {
                this.tape_fsize = this.tape_offset;
            }
        }
    }

    public void tape_rew() {
        int dat = 0;
        if (this.tape_fileh == null) {
            return;
        }
        assert (this.tape_fsize >= 16);
        assert (this.tape_offset >= 16);
        assert ((this.tape_fsize & 1) == 0);
        assert ((this.tape_offset & 1) == 0);
        this.tape_flush();
        while (this.tape_offset > 16) {
            this.tape_offset -= 2;
            if (!File.seek(this.tape_fileh, this.tape_offset)) {
                return;
            }
            int[] t = new int[2];
            File.read(this.tape_fileh, t, 2);
            dat = (t[0] << 8 | t[1]) & 0xFFFF;
            if (dat == 0) {
                File.seek(this.tape_fileh, this.tape_offset);
                return;
            }
            if (File.seek(this.tape_fileh, this.tape_offset)) continue;
            return;
        }
    }

    public void tape_ff() {
        int dat = 0;
        if (this.tape_fileh == null) {
            return;
        }
        assert (this.tape_fsize >= 16);
        assert (this.tape_offset >= 16);
        assert ((this.tape_fsize & 1) == 0);
        assert ((this.tape_offset & 1) == 0);
        this.tape_flush();
        while (this.tape_offset < this.tape_fsize) {
            this.tape_offset += 2;
            if (this.tape_offset >= this.tape_fsize) {
                return;
            }
            if (!File.seek(this.tape_fileh, this.tape_offset)) {
                return;
            }
            int[] t = new int[2];
            File.read(this.tape_fileh, t, 2);
            dat = (t[0] << 8 | t[1]) & 0xFFFF;
            if (dat != 0) continue;
            this.tape_offset += 2;
            if (this.tape_offset >= this.tape_fsize) {
                this.tape_fsize = this.tape_offset;
            }
            return;
        }
    }

    public void tape_setfile(String fname) {
        String header = "XM7 TAPE IMAGE 0";
        byte[] buf = new byte[17];
        if (this.tape_fileh != null) {
            this.tape_flush();
            File.close(this.tape_fileh);
            this.tape_fileh = null;
            this.tape_writep = false;
        }
        this.tape_fname = fname == null ? null : fname;
        if (this.tape_fname != null) {
            this.tape_fileh = File.open(this.tape_fname, 3);
            if (this.tape_fileh != null) {
                this.tape_writep = false;
            } else {
                this.tape_fileh = File.open(this.tape_fname, 1);
                this.tape_writep = true;
            }
        }
        if (this.tape_fileh != null) {
            Util.memset(buf, (byte)0, buf.length);
            File.read(this.tape_fileh, buf, 16);
            String tape_header = Util.byt2str(buf);
            if (!header.equals(tape_header)) {
                File.close(this.tape_fileh);
                this.tape_fileh = null;
                this.tape_writep = false;
            }
        }
        this.tape_setrec(false);
        this.tape_count = 0;
        this.tape_incnt = 0;
        this.tape_subcnt = 0;
        if (this.tape_fileh != null) {
            this.tape_fsize = File.getsize(this.tape_fileh);
            this.tape_offset = 16;
        }
    }

    public void tape_setrec(boolean flag) {
        if (this.tape_motor && !this.tape_rec) {
            if (flag) {
                this.tape_rec = true;
                this.tape_mark();
                return;
            }
        } else if (this.tape_motor && this.tape_rec && !flag) {
            this.tape_flush();
        }
        this.tape_rec = flag;
    }

    @Override
    public boolean event(int callbackid) {
        if (this.tape_motor) {
            if (this.tape_rec) {
                if (!this.tape_writep) {
                    Tapelp.sysmain.sys_snd.tape_notify(this.tape_out);
                }
            } else {
                this.tape_input(false);
                Tapelp.sysmain.sys_snd.tape_notify(this.tape_in);
            }
        }
        return true;
    }

    boolean readb(int addr, IntHolder dat) {
        if (addr != 64770) {
            return false;
        }
        int ret = 112;
        if (this.lp_busy) {
            ret |= 1;
        }
        if (!this.lp_error) {
            ret |= 2;
        }
        if (!this.lp_ackng) {
            ret |= 4;
        }
        if (this.lp_pe) {
            ret |= 8;
        }
        if (!this.lp_use) {
            ret |= 0xF;
            int joy = Tapelp.sysmain.sys_kbd.joy_request(2);
            if ((this.lp_data & 1) == 0 && (joy & 8) != 0) {
                ret &= 0xFFFFFFF7;
            }
            if ((this.lp_data & 2) == 0 && (joy & 4) != 0) {
                ret &= 0xFFFFFFF7;
            }
            if ((this.lp_data & 4) == 0 && (joy & 1) != 0) {
                ret &= 0xFFFFFFF7;
            }
            if ((this.lp_data & 8) == 0 && (joy & 2) != 0) {
                ret &= 0xFFFFFFF7;
            }
            if ((this.lp_data & 0x10) == 0 && (joy & 0x20) != 0) {
                ret &= 0xFFFFFFF7;
            }
            if ((this.lp_data & 0x20) == 0 && (joy & 0x10) != 0) {
                ret &= 0xFFFFFFF7;
            }
        }
        this.tape_input(true);
        if (this.tape_in) {
            ret |= 0x80;
        }
        dat.value = ret;
        return true;
    }

    boolean writeb(int addr, int dat) {
        switch (addr) {
            case 64768: {
                this.lp_online = (dat & 0x80) == 0;
                if ((dat & 0x40) != 0) {
                    this.lp_strobe = true;
                } else {
                    if (this.lp_strobe && this.lp_online) {
                        this.lp_output(this.lp_data);
                        mainetc.lp();
                    }
                    this.lp_strobe = false;
                }
                if ((dat & 1) != 0) {
                    if (!this.tape_out) {
                        this.tape_output(false);
                    }
                    this.tape_out = true;
                } else {
                    if (this.tape_out) {
                        this.tape_output(true);
                    }
                    this.tape_out = false;
                }
                if ((dat & 2) != 0) {
                    if (!this.tape_motor) {
                        this.tape_count = 0;
                        this.tape_subcnt = 0;
                        this.tape_motor = true;
                        if (this.tape_rec) {
                            this.tape_mark();
                        }
                        if (this.tape_monitor) {
                            schedule.setevent(17, 40, this, 0);
                        }
                        if (this.tape_sound) {
                            Tapelp.sysmain.sys_snd.wav_notify(0);
                        }
                    }
                } else {
                    if (this.tape_motor && this.tape_sound) {
                        Tapelp.sysmain.sys_snd.wav_notify(1);
                    }
                    this.tape_motor = false;
                    schedule.delevent(17);
                    this.tape_flush();
                }
                return true;
            }
            case 64769: {
                this.lp_data = dat;
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        boolean tmp;
        byte[] fname;
        this.tape_flush();
        if (!File.bool_write(fileh, this.tape_in)) {
            return false;
        }
        if (!File.bool_write(fileh, this.tape_out)) {
            return false;
        }
        if (!File.bool_write(fileh, this.tape_motor)) {
            return false;
        }
        if (!File.bool_write(fileh, this.tape_rec)) {
            return false;
        }
        if (!File.bool_write(fileh, this.tape_writep)) {
            return false;
        }
        if (!File.word_write(fileh, this.tape_count)) {
            return false;
        }
        if (!File.byte_write(fileh, this.tape_subcnt)) {
            return false;
        }
        if (!File.dword_write(fileh, this.tape_offset)) {
            return false;
        }
        int fnamesize = 129;
        if (this.tape_fname != null) {
            fname = Util.str2byt(this.tape_fname);
            if (fname == null) {
                return false;
            }
            if (!File.write(fileh, fname, fname.length)) {
                return false;
            }
            fnamesize -= fname.length;
        }
        while (fnamesize > 0) {
            if (!File.byte_write(fileh, 0)) {
                return false;
            }
            --fnamesize;
        }
        boolean bl = tmp = this.tape_fileh != null;
        if (!File.bool_write(fileh, tmp)) {
            return false;
        }
        if (!File.word_write(fileh, this.tape_incnt)) {
            return false;
        }
        if (!File.dword_write(fileh, this.tape_fsize)) {
            return false;
        }
        if (!File.byte_write(fileh, this.lp_data)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_busy)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_error)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_pe)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_ackng)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_online)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_strobe)) {
            return false;
        }
        fnamesize = 129;
        if (this.lp_fname != null) {
            fname = Util.str2byt(this.lp_fname);
            if (fname == null) {
                return false;
            }
            if (!File.write(fileh, fname, fname.length)) {
                return false;
            }
            fnamesize -= fname.length;
        }
        while (fnamesize > 0) {
            if (!File.byte_write(fileh, 0)) {
                return false;
            }
            --fnamesize;
        }
        return true;
    }

    boolean load(RandomAccessFile fileh, int ver) {
        int offset = 0;
        byte[] fname = new byte[129];
        boolean flag = true;
        if (ver < 200) {
            return false;
        }
        try {
            this.tape_in = File.bool_read(fileh);
            this.tape_out = File.bool_read(fileh);
            this.tape_motor = File.bool_read(fileh);
            this.tape_rec = File.bool_read(fileh);
            this.tape_writep = File.bool_read(fileh);
            this.tape_count = File.word_read(fileh);
            this.tape_subcnt = File.byte_read(fileh);
            offset = File.dword_read(fileh);
            File.read(fileh, fname, 129);
            flag = File.bool_read(fileh);
            this.tape_setfile(null);
            if (flag) {
                this.tape_setfile(Util.byt2str(fname));
                if (this.tape_fileh != null && this.tape_fsize + 1 >= offset) {
                    File.seek(this.tape_fileh, offset);
                    this.tape_offset = offset;
                }
            }
            this.tape_incnt = File.word_read(fileh);
            offset = File.dword_read(fileh);
            this.lp_data = File.byte_read(fileh);
            this.lp_busy = File.bool_read(fileh);
            this.lp_error = File.bool_read(fileh);
            this.lp_pe = File.bool_read(fileh);
            this.lp_ackng = File.bool_read(fileh);
            this.lp_online = File.bool_read(fileh);
            this.lp_strobe = File.bool_read(fileh);
            byte[] lp_fnameb = new byte[129];
            File.read(fileh, lp_fnameb, 129);
            this.lp_fname = new String(Util.byt2str(lp_fnameb));
            schedule.handle(17, this, 0);
            this.tape_saveptr = 0;
            this.tape_fetch = false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

